/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.java.platform.JavaPlatformFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

class JDKDetectorUtils {
    JDKDetectorUtils() {
    }

    static void registerJDKs(List<Path> jdks, Function<Path, String> namer) {
        List platforms = Stream.of(JavaPlatformManager.getDefault().getInstalledPlatforms()).filter(JavaPlatform::isValid).collect(Collectors.toList());
        Set registeredJDKNames = platforms.stream().map(JavaPlatform::getDisplayName).collect(Collectors.toSet());
        Set registeredPaths = platforms.stream().flatMap(p -> p.getInstallFolders().stream()).map(f -> Paths.get(f.getPath(), new String[0])).collect(Collectors.toSet());
        for (JavaPlatformFactory.Provider provider : Lookup.getDefault().lookupAll(JavaPlatformFactory.Provider.class)) {
            Object value;
            Path jdk;
            FileObject fo;
            JavaPlatformFactory platformFactory = provider.forType("j2se");
            if (platformFactory == null) continue;
            Iterator<Path> iterator = jdks.iterator();
            while (iterator.hasNext() && ((fo = FileUtil.toFileObject((Path)(jdk = iterator.next()))) == null || !((value = fo.getAttribute("J2SEPlatform.displayName")) instanceof String))) {
                try {
                    String jdkName = namer.apply(jdk);
                    if (registeredJDKNames.contains(jdkName) || registeredPaths.contains(jdk)) continue;
                    platformFactory.create(FileUtil.toFileObject((Path)jdk), jdkName, true);
                }
                catch (IOException | IllegalArgumentException exception) {}
            }
        }
    }
}

