/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.documentation.ui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.documentation.PhpDocumentations;
import org.netbeans.modules.php.api.documentation.ui.actions.BaseSubMenu;
import org.netbeans.modules.php.api.documentation.ui.actions.Bundle;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.documentation.PhpDocumentationProvider;
import org.openide.LifecycleManager;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public final class GenerateDocumentationActionFactory
extends AbstractAction
implements ContextAwareAction {
    private static final long serialVersionUID = 5687856454545L;

    public GenerateDocumentationActionFactory() {
        this.setEnabled(false);
        this.putValue("hideWhenDisabled", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Collection projects = actionContext.lookupAll(Project.class);
        if (projects.size() != 1) {
            return this;
        }
        Project project = (Project)((Project)projects.iterator().next()).getLookup().lookup(Project.class);
        if (project == null) {
            return this;
        }
        List<PhpDocumentationProvider> docProviders = PhpDocumentations.getDocumentations();
        if (docProviders.isEmpty()) {
            return this;
        }
        PhpModule phpModule = PhpModule.Factory.lookupPhpModule((Project)project);
        if (phpModule == null) {
            return this;
        }
        ArrayList<PhpDocumentationProvider> projectDocProviders = new ArrayList<PhpDocumentationProvider>(docProviders.size());
        for (PhpDocumentationProvider docProvider : docProviders) {
            if (!docProvider.isInPhpModule(phpModule)) continue;
            projectDocProviders.add(docProvider);
        }
        if (projectDocProviders.isEmpty()) {
            projectDocProviders.addAll(docProviders);
        }
        if (projectDocProviders.size() == 1) {
            return new PhpDocAction(phpModule, (PhpDocumentationProvider)projectDocProviders.get(0));
        }
        return new DocumentationMenu(phpModule, projectDocProviders);
    }

    private static final class PhpDocAction
    extends AbstractAction {
        private static final long serialVersionUID = 178423135454L;
        private static final RequestProcessor RP = new RequestProcessor("Generating php documentation", 2);
        private final PhpModule phpModule;
        private final PhpDocumentationProvider docProvider;
        private final boolean remember;

        public PhpDocAction(PhpModule phpModule, PhpDocumentationProvider docProvider) {
            this(Bundle.GenerateDocumentationActionFactory_title(), phpModule, docProvider, false);
        }

        public PhpDocAction(String name, PhpModule phpModule, PhpDocumentationProvider docProvider, boolean remember) {
            this.phpModule = phpModule;
            this.docProvider = docProvider;
            this.remember = remember;
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.phpModule.isBroken()) {
                UiUtils.warnBrokenProject((PhpModule)this.phpModule);
                return;
            }
            RP.post(new Runnable(){

                @Override
                public void run() {
                    LifecycleManager.getDefault().saveAll();
                    if (remember) {
                        docProvider.notifyEnabled(phpModule, true);
                    }
                    docProvider.generateDocumentation(phpModule);
                }
            });
        }
    }

    private static final class DocumentationMenu
    extends AbstractAction
    implements Presenter.Popup {
        private static final long serialVersionUID = 1587896543546879L;
        private final PhpModule phpModule;
        private final List<PhpDocumentationProvider> docProviders;

        public DocumentationMenu(PhpModule phpModule, List<PhpDocumentationProvider> docProviders) {
            super(Bundle.GenerateDocumentationActionFactory_title(), null);
            assert (phpModule != null);
            assert (docProviders != null);
            this.putValue("ShortDescription", Bundle.GenerateDocumentationActionFactory_title());
            this.phpModule = phpModule;
            this.docProviders = docProviders;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public JMenuItem getPopupPresenter() {
            ArrayList<PhpDocAction> docActions = new ArrayList<PhpDocAction>(this.docProviders.size());
            for (PhpDocumentationProvider docProvider : this.docProviders) {
                docActions.add(new PhpDocAction(docProvider.getDisplayName(), this.phpModule, docProvider, true));
            }
            return new DocumentationSubMenu(docActions);
        }
    }

    private static class DocumentationSubMenu
    extends BaseSubMenu {
        private static final long serialVersionUID = -6764324657641L;

        public DocumentationSubMenu(List<PhpDocAction> docActions) {
            super(Bundle.GenerateDocumentationActionFactory_title());
            for (PhpDocAction action : docActions) {
                this.add(DocumentationSubMenu.toMenuItem(action));
            }
        }
    }
}

