/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum OperatingMode implements Api
{
    NATIVE("Native", "native"),
    EMULATED("Emulated", "emulated"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private OperatingMode(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public OperatingMode getDefault() {
        return NONE;
    }

    @Override
    public OperatingMode getNotFound() {
        return NOT_FOUND;
    }

    public OperatingMode[] getAll() {
        return OperatingMode.values();
    }

    public static OperatingMode fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "native": 
            case "NATIVE": 
            case "Native": {
                return NATIVE;
            }
            case "emulated": 
            case "EMULATED": 
            case "Emulated": {
                return EMULATED;
            }
        }
        return NOT_FOUND;
    }

    public static List<OperatingMode> getAsList() {
        return Arrays.asList(OperatingMode.values());
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.REDUCED_COMPRESSED);
    }
}

