/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.BreakpointsActivationProvider;
import org.netbeans.spi.debugger.ContextProvider;

public class JPDABreakpointsActivation
implements BreakpointsActivationProvider {
    private final JPDADebugger debugger;
    private final Map<PropertyChangeListener, DelegateListener> listenersMap = Collections.synchronizedMap(new HashMap());

    public JPDABreakpointsActivation(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public boolean areBreakpointsActive() {
        return this.debugger.getBreakpointsActive();
    }

    public void setBreakpointsActive(boolean active) {
        this.debugger.setBreakpointsActive(active);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        DelegateListener dl = new DelegateListener(this, l);
        this.listenersMap.put(l, dl);
        this.debugger.addPropertyChangeListener("breakpointsActive", (PropertyChangeListener)dl);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        DelegateListener dl = this.listenersMap.remove(l);
        if (dl != null) {
            this.debugger.removePropertyChangeListener("breakpointsActive", (PropertyChangeListener)dl);
        }
    }

    private static class DelegateListener
    implements PropertyChangeListener {
        private final Object source;
        private final PropertyChangeListener l;

        public DelegateListener(Object source, PropertyChangeListener l) {
            this.source = source;
            this.l = l;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.l.propertyChange(new PropertyChangeEvent(this.source, "breakpointsActive", evt.getOldValue(), evt.getNewValue()));
        }
    }
}

