/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

final class ReflectionUtils {
    private ReflectionUtils() {
    }

    static Class<?> forName(String clazz) throws ClassNotFoundException {
        try {
            return (Class)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> Class.forName(clazz));
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Could not retrieve class %s.", clazz), ex);
        }
    }

    static Field[] getDeclaredFields(Class<?> clazz) {
        return (Field[])PrivilegedAccessHelper.callDoPrivileged(() -> clazz.getDeclaredFields());
    }

    static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        return (Constructor[])PrivilegedAccessHelper.callDoPrivileged(() -> clazz.getDeclaredConstructors());
    }

    static Method[] getDeclaredMethods(Class<?> clazz) {
        return (Method[])PrivilegedAccessHelper.callDoPrivileged(() -> clazz.getDeclaredMethods());
    }
}

