/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Printer;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.StringUtils;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public abstract class AbstractDiagnosticFormatter
implements DiagnosticFormatter<JCDiagnostic> {
    protected JavacMessages messages;
    private SimpleConfiguration config;
    protected int depth = 0;
    private List<Type> allCaptured = List.nil();
    protected Printer printer = new Printer(){

        @Override
        protected String localize(Locale locale, String key, Object ... args) {
            return AbstractDiagnosticFormatter.this.localize(locale, key, args);
        }

        @Override
        protected String capturedVarId(Type.CapturedType t, Locale locale) {
            return "" + (AbstractDiagnosticFormatter.this.allCaptured.indexOf(t) + 1);
        }

        @Override
        public String visitCapturedType(Type.CapturedType t, Locale locale) {
            if (!AbstractDiagnosticFormatter.this.allCaptured.contains(t)) {
                AbstractDiagnosticFormatter.this.allCaptured = AbstractDiagnosticFormatter.this.allCaptured.append(t);
            }
            return super.visitCapturedType(t, locale);
        }
    };

    protected AbstractDiagnosticFormatter(JavacMessages messages, SimpleConfiguration config) {
        this.messages = messages;
        this.config = config;
    }

    @Override
    public String formatKind(JCDiagnostic d, Locale l) {
        switch (d.getType()) {
            case FRAGMENT: {
                return "";
            }
            case NOTE: {
                return this.localize(l, "compiler.note.note", new Object[0]);
            }
            case WARNING: {
                return this.localize(l, "compiler.warn.warning", new Object[0]);
            }
            case ERROR: {
                return this.localize(l, "compiler.err.error", new Object[0]);
            }
        }
        throw new AssertionError((Object)("Unknown diagnostic type: " + (Object)((Object)d.getType())));
    }

    @Override
    public String format(JCDiagnostic d, Locale locale) {
        this.allCaptured = List.nil();
        return this.formatDiagnostic(d, locale);
    }

    protected abstract String formatDiagnostic(JCDiagnostic var1, Locale var2);

    @Override
    public String formatPosition(JCDiagnostic d, DiagnosticFormatter.PositionKind pk, Locale l) {
        Assert.check(d.getPosition() != -1L);
        return String.valueOf(this.getPosition(d, pk));
    }

    private long getPosition(JCDiagnostic d, DiagnosticFormatter.PositionKind pk) {
        switch (pk) {
            case START: {
                return d.getIntStartPosition();
            }
            case END: {
                return d.getIntEndPosition();
            }
            case LINE: {
                return d.getLineNumber();
            }
            case COLUMN: {
                return d.getColumnNumber();
            }
            case OFFSET: {
                return d.getIntPosition();
            }
        }
        throw new AssertionError((Object)("Unknown diagnostic position: " + (Object)((Object)pk)));
    }

    @Override
    public String formatSource(JCDiagnostic d, boolean fullname, Locale l) {
        JavaFileObject fo = d.getSource();
        if (fo == null) {
            throw new IllegalArgumentException();
        }
        if (fullname) {
            return fo.getName();
        }
        if (fo instanceof PathFileObject) {
            PathFileObject pathFileObject = (PathFileObject)fo;
            return pathFileObject.getShortName();
        }
        return PathFileObject.getSimpleName(fo);
    }

    protected Collection<String> formatArguments(JCDiagnostic d, Locale l) {
        ListBuffer<String> buf = new ListBuffer<String>();
        for (Object o : d.getArgs()) {
            buf.append(this.formatArgument(d, o, l));
        }
        return buf.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatArgument(JCDiagnostic d, Object arg, Locale l) {
        if (arg instanceof JCDiagnostic) {
            JCDiagnostic diagnostic = (JCDiagnostic)arg;
            String s = null;
            ++this.depth;
            try {
                JCDiagnostic rewrittenDiagnostic = null;
                if (diagnostic.hasRewriter()) {
                    rewrittenDiagnostic = diagnostic.rewrite();
                }
                s = this.formatMessage(rewrittenDiagnostic != null ? rewrittenDiagnostic : diagnostic, l);
            }
            finally {
                --this.depth;
            }
            return s;
        }
        if (arg instanceof JCTree.JCExpression) {
            JCTree.JCExpression expression = (JCTree.JCExpression)arg;
            return this.expr2String(expression);
        }
        if (arg instanceof Iterable) {
            Iterable iterable = (Iterable)arg;
            if (!(arg instanceof Path)) {
                return this.formatIterable(d, iterable, l);
            }
        }
        if (arg instanceof Type) {
            Type type = (Type)arg;
            return this.printer.visit(type.stripMetadata(), l);
        }
        if (arg instanceof JCDiagnostic.AnnotatedType) {
            JCDiagnostic.AnnotatedType type = (JCDiagnostic.AnnotatedType)arg;
            return this.printer.visit(type.type(), l);
        }
        if (arg instanceof Symbol) {
            Symbol symbol = (Symbol)arg;
            return this.printer.visit(symbol, l);
        }
        if (arg instanceof JavaFileObject) {
            JavaFileObject javaFileObject = (JavaFileObject)arg;
            return javaFileObject.getName();
        }
        if (arg instanceof Profile) {
            Profile profile = (Profile)((Object)arg);
            return profile.name;
        }
        if (arg instanceof Option) {
            Option option = (Option)((Object)arg);
            return option.primaryName;
        }
        if (arg instanceof Formattable) {
            Formattable formattable = (Formattable)arg;
            return formattable.toString(l, this.messages);
        }
        if (arg instanceof Target) {
            Target target = (Target)((Object)arg);
            return target.name;
        }
        if (arg instanceof Source) {
            Source source = (Source)((Object)arg);
            return source.name;
        }
        if (arg instanceof JCTree.Tag) {
            JCTree.Tag tag = (JCTree.Tag)((Object)arg);
            return this.messages.getLocalizedString(l, "compiler.misc.tree.tag." + StringUtils.toLowerCase(tag.name()), new Object[0]);
        }
        return String.valueOf(arg);
    }

    private String expr2String(JCTree.JCExpression tree) {
        switch (tree.getTag()) {
            case PARENS: {
                return this.expr2String(((JCTree.JCParens)tree).expr);
            }
            case LAMBDA: 
            case REFERENCE: 
            case CONDEXPR: {
                return Pretty.toSimpleString(tree);
            }
        }
        Assert.error("unexpected tree kind " + (Object)((Object)tree.getKind()));
        return null;
    }

    protected String formatIterable(JCDiagnostic d, Iterable<?> it, Locale l) {
        StringBuilder sbuf = new StringBuilder();
        String sep = "";
        for (Object o : it) {
            sbuf.append(sep);
            sbuf.append(this.formatArgument(d, o, l));
            sep = ",";
        }
        return sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> formatSubdiagnostics(JCDiagnostic d, Locale l) {
        List<String> subdiagnostics = List.nil();
        int maxDepth = this.config.getMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.DEPTH);
        if (maxDepth == -1 || this.depth < maxDepth) {
            ++this.depth;
            try {
                int maxCount = this.config.getMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.LENGTH);
                int count = 0;
                for (JCDiagnostic d2 : d.getSubdiagnostics()) {
                    if (maxCount == -1 || count < maxCount) {
                        subdiagnostics = subdiagnostics.append(this.formatSubdiagnostic(d, d2, l));
                        ++count;
                        continue;
                    }
                    break;
                }
            }
            finally {
                --this.depth;
            }
        }
        return subdiagnostics;
    }

    protected String formatSubdiagnostic(JCDiagnostic parent, JCDiagnostic sub, Locale l) {
        return this.formatMessage(sub, l);
    }

    protected String formatSourceLine(JCDiagnostic d, int nSpaces) {
        String line;
        StringBuilder buf = new StringBuilder();
        DiagnosticSource source = d.getDiagnosticSource();
        int pos = d.getIntPosition();
        if (d.getIntPosition() == -1) {
            throw new AssertionError();
        }
        String string = line = source == null ? null : source.getLine(pos);
        if (line == null) {
            return "";
        }
        buf.append(this.indent(line, nSpaces));
        int col = source.getColumnNumber(pos, false);
        if (this.config.isCaretEnabled()) {
            buf.append("\n");
            for (int i = 0; i < col - 1; ++i) {
                buf.append(line.charAt(i) == '\t' ? "\t" : " ");
            }
            buf.append(this.indent("^", nSpaces));
        }
        return buf.toString();
    }

    protected String formatLintCategory(JCDiagnostic d, Locale l) {
        Lint.LintCategory lc = d.getLintCategory();
        if (lc == null) {
            return "";
        }
        return this.localize(l, "compiler.warn.lintOption", lc.option);
    }

    protected String localize(Locale l, String key, Object ... args) {
        return this.messages.getLocalizedString(l, key, args);
    }

    @Override
    public boolean displaySource(JCDiagnostic d) {
        return ((AbstractCollection)((Object)this.config.getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE) && d.getType() != JCDiagnostic.DiagnosticType.FRAGMENT && d.getIntPosition() != -1;
    }

    public boolean isRaw() {
        return false;
    }

    protected String indentString(int nSpaces) {
        String spaces = "                        ";
        if (nSpaces <= spaces.length()) {
            return spaces.substring(0, nSpaces);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < nSpaces; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    protected String indent(String s, int nSpaces) {
        String indent = this.indentString(nSpaces);
        StringBuilder buf = new StringBuilder();
        String nl = "";
        for (String line : s.split("\n")) {
            buf.append(nl);
            buf.append(indent + line);
            nl = "\n";
        }
        return buf.toString();
    }

    @Override
    public SimpleConfiguration getConfiguration() {
        return this.config;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public static class SimpleConfiguration
    implements DiagnosticFormatter.Configuration {
        protected Map<DiagnosticFormatter.Configuration.MultilineLimit, Integer> multilineLimits = new HashMap<DiagnosticFormatter.Configuration.MultilineLimit, Integer>();
        protected EnumSet<DiagnosticFormatter.Configuration.DiagnosticPart> visibleParts;
        protected boolean caretEnabled;

        public SimpleConfiguration(Set<DiagnosticFormatter.Configuration.DiagnosticPart> parts) {
            this.setVisible(parts);
            this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.DEPTH, -1);
            this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.LENGTH, -1);
            this.setCaretEnabled(true);
        }

        public SimpleConfiguration(Options options, Set<DiagnosticFormatter.Configuration.DiagnosticPart> parts) {
            this(parts);
            String diagOpts;
            String showSource = null;
            showSource = options.get("diags.showSource");
            if (showSource != null) {
                if (showSource.equals("true")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, true);
                } else if (showSource.equals("false")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, false);
                }
            }
            if ((diagOpts = options.get("diags.formatterOptions")) != null) {
                java.util.List<String> args = Arrays.asList(diagOpts.split(","));
                if (args.contains("short")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, false);
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, false);
                }
                if (args.contains("source")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, true);
                }
                if (args.contains("-source")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, false);
                }
            }
            String multiPolicy = null;
            multiPolicy = options.get("diags.multilinePolicy");
            if (multiPolicy != null) {
                if (multiPolicy.equals("disabled")) {
                    this.setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, false);
                } else if (multiPolicy.startsWith("limit:")) {
                    String limitString = multiPolicy.substring("limit:".length());
                    String[] limits = limitString.split(":");
                    try {
                        switch (limits.length) {
                            case 2: {
                                if (!limits[1].equals("*")) {
                                    this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.DEPTH, Integer.parseInt(limits[1]));
                                }
                            }
                            case 1: {
                                if (limits[0].equals("*")) break;
                                this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.LENGTH, Integer.parseInt(limits[0]));
                            }
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.DEPTH, -1);
                        this.setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit.LENGTH, -1);
                    }
                }
            }
            String showCaret = null;
            showCaret = options.get("diags.showCaret");
            if (showCaret != null && showCaret.equals("false")) {
                this.setCaretEnabled(false);
            } else {
                this.setCaretEnabled(true);
            }
        }

        @Override
        public int getMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit limit) {
            return this.multilineLimits.get((Object)limit);
        }

        public EnumSet<DiagnosticFormatter.Configuration.DiagnosticPart> getVisible() {
            return EnumSet.copyOf(this.visibleParts);
        }

        @Override
        public void setMultilineLimit(DiagnosticFormatter.Configuration.MultilineLimit limit, int value) {
            this.multilineLimits.put(limit, value < -1 ? -1 : value);
        }

        @Override
        public void setVisible(Set<DiagnosticFormatter.Configuration.DiagnosticPart> diagParts) {
            this.visibleParts = EnumSet.copyOf(diagParts);
        }

        public void setVisiblePart(DiagnosticFormatter.Configuration.DiagnosticPart diagParts, boolean enabled) {
            if (enabled) {
                this.visibleParts.add(diagParts);
            } else {
                this.visibleParts.remove((Object)diagParts);
            }
        }

        public void setCaretEnabled(boolean caretEnabled) {
            this.caretEnabled = caretEnabled;
        }

        public boolean isCaretEnabled() {
            return this.caretEnabled;
        }
    }
}

