/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.integration.outputs.s3;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GzipUtil {
    private static final int FILE_READ_SIZE = 1024;
    private static final String CORRUPTED_FILE_ERROR = "Unexpected end of ZLIB input stream";
    private static final Logger logger = LogManager.getLogger(GzipUtil.class);

    public static void compress(String sourcePath, String targetPath) {
        try {
            GzipUtil.compress(Paths.get(sourcePath, new String[0]), Paths.get(targetPath, new String[0]));
        }
        catch (IOException exception) {
            logger.error("Error occurred while compressing the file, error={}", (Object)exception.getMessage());
        }
    }

    public static void recover(String sourcePath, String targetPath) {
        try {
            GzipUtil.decompress(Paths.get(sourcePath, new String[0]), Paths.get(targetPath, new String[0]));
        }
        catch (IOException exception) {
            if (!CORRUPTED_FILE_ERROR.equals(exception.getMessage())) {
                logger.error("Error occurred while compressing the file, error={}", (Object)exception.getMessage());
            }
            logger.warn("Corrupted file recovered, path:" + targetPath);
        }
    }

    public static void decompress(String sourcePath, String targetPath) {
        try {
            GzipUtil.decompress(Paths.get(sourcePath, new String[0]), Paths.get(targetPath, new String[0]));
        }
        catch (IOException exception) {
            logger.error("Error occurred while decompressing the file, error={}", (Object)exception.getMessage());
        }
    }

    private static void compress(Path source, Path target) throws IOException {
        try (GZIPOutputStream outputStream = new GZIPOutputStream(new FileOutputStream(target.toFile()));
             FileInputStream inputStream = new FileInputStream(source.toFile());){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
        }
    }

    private static void decompress(Path source, Path target) throws IOException {
        FileInputStream inputStream = new FileInputStream(source.toFile());
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
             FileOutputStream outputStream = new FileOutputStream(target.toFile());){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = gzipInputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
        }
    }
}

