/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.remover.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.QueryBasedConditionalRemover;

abstract class MultipleConditionQueryRemover<K, V>
extends QueryBasedConditionalRemover<K, V> {
    private final List<RemoveCondition<K, V>> removes = new ArrayList<RemoveCondition<K, V>>();
    private int parameterIndex;

    MultipleConditionQueryRemover() {
    }

    @Override
    String getQueryConditions() {
        return this.removes.stream().map(RemoveCondition::getConditionalClause).collect(Collectors.joining(" || "));
    }

    @Override
    Map<String, Object> getQueryParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.removes.forEach(removeCondition -> removeCondition.addParameters(parameters));
        return parameters;
    }

    @Override
    boolean isEmpty() {
        return this.removes.isEmpty();
    }

    @Override
    public boolean willRemove(K key, V value) {
        return !this.isEmpty() && this.removes.stream().anyMatch(c -> c.willRemove(key, value));
    }

    String nextParameter() {
        return "p" + this.parameterIndex++;
    }

    void add(RemoveCondition<K, V> condition) {
        this.removes.add(condition);
    }

    static interface RemoveCondition<K, V> {
        public String getConditionalClause();

        public void addParameters(Map<String, Object> var1);

        public boolean willRemove(K var1, V var2);
    }
}

