/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.spi;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.Hibernate;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentMap;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.spi.JsonGeneratingVisitor;
import org.hibernate.type.format.JsonDocumentWriter;

public class DescriptiveJsonGeneratingVisitor
extends JsonGeneratingVisitor {
    private Map<String, IdentitySet<Object>> circularityTracker;

    @Override
    protected void serializeEntity(Object value, EntityMappingType entityType, WrapperOptions options, JsonDocumentWriter writer) {
        EntityIdentifierMapping identifierMapping = entityType.getIdentifierMapping();
        this.trackingEntity(value, entityType, shouldProcessEntity -> {
            try {
                writer.startObject();
                writer.objectKey(identifierMapping.getAttributeName());
                this.serializeEntityIdentifier(value, identifierMapping, options, writer);
                if (shouldProcessEntity.booleanValue()) {
                    this.serializeObjectValues(entityType, value, options, writer);
                }
                writer.endObject();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error serializing entity", e);
            }
        });
    }

    private void trackingEntity(Object entity, EntityMappingType entityType, Consumer<Boolean> action) {
        if (this.circularityTracker == null) {
            this.circularityTracker = new HashMap<String, IdentitySet<Object>>();
        }
        IdentitySet entities = this.circularityTracker.computeIfAbsent(entityType.getEntityName(), k -> new IdentitySet());
        boolean added = entities.add(entity);
        action.accept(added);
        if (added) {
            entities.remove(entity);
        }
    }

    @Override
    protected boolean handleNullOrLazy(Object value, JsonDocumentWriter writer) {
        if (value == null) {
            writer.nullValue();
            return true;
        }
        if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            writer.stringValue(value.toString());
            return true;
        }
        if (!Hibernate.isInitialized(value)) {
            writer.stringValue("<uninitialized>");
            return true;
        }
        return false;
    }

    @Override
    protected void serializeModelPart(ValuedModelPart modelPart, Object value, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        if (modelPart instanceof SelectableMapping) {
            writer.objectKey(modelPart.getPartName());
            this.visit(modelPart.getMappedType(), value, options, writer);
        } else if (modelPart instanceof EmbeddedAttributeMapping) {
            EmbeddedAttributeMapping embeddedAttribute = (EmbeddedAttributeMapping)modelPart;
            writer.objectKey(embeddedAttribute.getAttributeName());
            this.visit(embeddedAttribute.getMappedType(), value, options, writer);
        } else if (modelPart instanceof EntityValuedModelPart) {
            EntityValuedModelPart entityPart = (EntityValuedModelPart)((Object)modelPart);
            writer.objectKey(entityPart.getPartName());
            this.visit(entityPart.getEntityMappingType(), value, options, writer);
        } else if (modelPart instanceof PluralAttributeMapping) {
            PluralAttributeMapping plural = (PluralAttributeMapping)modelPart;
            writer.objectKey(plural.getPartName());
            this.serializePluralAttribute(value, plural, options, writer);
        } else {
            throw new UnsupportedOperationException("Support for model part type not yet implemented: " + (modelPart != null ? modelPart.getClass().getName() : "null"));
        }
    }

    private void serializePluralAttribute(Object value, PluralAttributeMapping plural, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        if (this.handleNullOrLazy(value, writer)) {
            return;
        }
        CollectionPart element = plural.getElementDescriptor();
        CollectionSemantics collectionSemantics = plural.getMappedType().getCollectionSemantics();
        switch (collectionSemantics.getCollectionClassification()) {
            case MAP: 
            case SORTED_MAP: 
            case ORDERED_MAP: {
                this.serializePersistentMap((PersistentMap)value, plural.getIndexDescriptor(), element, options, writer);
                break;
            }
            default: {
                this.serializePersistentCollection((PersistentCollection)value, plural.getCollectionDescriptor(), element, options, writer);
            }
        }
    }

    private <K, E> void serializePersistentMap(PersistentMap<K, E> map, CollectionPart key, CollectionPart value, WrapperOptions options, JsonDocumentWriter writer) throws IOException {
        writer.startArray();
        for (Map.Entry<K, E> entry : map.entrySet()) {
            writer.startObject();
            writer.objectKey("key");
            this.serializeCollectionPart(entry.getKey(), key, options, writer);
            writer.objectKey("value");
            this.serializeCollectionPart(entry.getValue(), value, options, writer);
            writer.endObject();
        }
        writer.endArray();
    }

    private <E> void serializePersistentCollection(PersistentCollection<E> collection, CollectionPersister persister, CollectionPart element, WrapperOptions options, JsonDocumentWriter appender) throws IOException {
        appender.startArray();
        Iterator<?> entries = collection.entries(persister);
        while (entries.hasNext()) {
            this.serializeCollectionPart(entries.next(), element, options, appender);
        }
        appender.endArray();
    }

    private void serializeCollectionPart(Object value, CollectionPart collectionPart, WrapperOptions options, JsonDocumentWriter appender) throws IOException {
        if (collectionPart instanceof BasicValuedCollectionPart) {
            BasicValuedCollectionPart basic = (BasicValuedCollectionPart)collectionPart;
            appender.serializeJsonValue(value, basic.getJavaType(), basic.getJdbcMapping().getJdbcType(), options);
        } else {
            this.visit(collectionPart.getMappedType(), value, options, appender);
        }
    }
}

