/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractQueryParameter;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.type.BindableType;

public class QueryParameterIdentifiedImpl<T>
extends AbstractQueryParameter<T> {
    private final int unnamedParameterId;

    public static <T> QueryParameterIdentifiedImpl<T> fromSqm(SqmJpaCriteriaParameterWrapper<T> parameter) {
        assert (parameter.getName() == null);
        assert (parameter.getPosition() == null);
        return new QueryParameterIdentifiedImpl<T>(parameter.getUnnamedParameterId(), parameter.allowMultiValuedBinding(), parameter.getAnticipatedType());
    }

    private QueryParameterIdentifiedImpl(int unnamedParameterId, boolean allowMultiValuedBinding, @Nullable BindableType<T> anticipatedType) {
        super(allowMultiValuedBinding, anticipatedType);
        this.unnamedParameterId = unnamedParameterId;
    }

    public int getUnnamedParameterId() {
        return this.unnamedParameterId;
    }

    @Override
    public NamedQueryMemento.ParameterMemento toMemento() {
        return session -> new QueryParameterIdentifiedImpl(this.unnamedParameterId, this.allowsMultiValuedBinding(), this.getHibernateType());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof QueryParameterIdentifiedImpl && this.unnamedParameterId == ((QueryParameterIdentifiedImpl)o).unnamedParameterId;
    }

    public int hashCode() {
        return this.unnamedParameterId;
    }
}

