/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.HashMap;
import java.util.Map;

public class OAuth2Code {
    private static final String ID_NOTE = "id";
    private static final String EXPIRATION_NOTE = "exp";
    private static final String NONCE_NOTE = "nonce";
    private static final String SCOPE_NOTE = "scope";
    private static final String REDIRECT_URI_PARAM_NOTE = "redirectUri";
    private static final String CODE_CHALLENGE_NOTE = "code_challenge";
    private static final String CODE_CHALLENGE_METHOD_NOTE = "code_challenge_method";
    private static final String DPOP_JKT_NOTE = "dpop_jkt";
    private static final String USER_SESSION_ID_NOTE = "user_session_id";
    private final String id;
    private final int expiration;
    private final String nonce;
    private final String scope;
    private final String redirectUriParam;
    private final String codeChallenge;
    private final String codeChallengeMethod;
    private final String dpopJkt;
    private final String userSessionId;

    public OAuth2Code(String id, int expiration, String nonce, String scope, String userSessionId) {
        this.id = id;
        this.expiration = expiration;
        this.nonce = nonce;
        this.scope = scope;
        this.redirectUriParam = null;
        this.codeChallenge = null;
        this.codeChallengeMethod = null;
        this.dpopJkt = null;
        this.userSessionId = userSessionId;
    }

    public OAuth2Code(String id, int expiration, String nonce, String scope, String redirectUriParam, String codeChallenge, String codeChallengeMethod, String dpopJkt, String userSessionId) {
        this.id = id;
        this.expiration = expiration;
        this.nonce = nonce;
        this.scope = scope;
        this.redirectUriParam = redirectUriParam;
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
        this.dpopJkt = dpopJkt;
        this.userSessionId = userSessionId;
    }

    private OAuth2Code(Map<String, String> data) {
        this.id = data.get(ID_NOTE);
        this.expiration = Integer.parseInt(data.get(EXPIRATION_NOTE));
        this.nonce = data.get(NONCE_NOTE);
        this.scope = data.get(SCOPE_NOTE);
        this.redirectUriParam = data.get(REDIRECT_URI_PARAM_NOTE);
        this.codeChallenge = data.get(CODE_CHALLENGE_NOTE);
        this.codeChallengeMethod = data.get(CODE_CHALLENGE_METHOD_NOTE);
        this.dpopJkt = data.get(DPOP_JKT_NOTE);
        this.userSessionId = data.get(USER_SESSION_ID_NOTE);
    }

    public static OAuth2Code deserializeCode(Map<String, String> data) {
        return new OAuth2Code(data);
    }

    public Map<String, String> serializeCode() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ID_NOTE, this.id);
        result.put(EXPIRATION_NOTE, String.valueOf(this.expiration));
        result.put(NONCE_NOTE, this.nonce);
        result.put(SCOPE_NOTE, this.scope);
        result.put(REDIRECT_URI_PARAM_NOTE, this.redirectUriParam);
        result.put(CODE_CHALLENGE_NOTE, this.codeChallenge);
        result.put(CODE_CHALLENGE_METHOD_NOTE, this.codeChallengeMethod);
        result.put(DPOP_JKT_NOTE, this.dpopJkt);
        result.put(USER_SESSION_ID_NOTE, this.userSessionId);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getScope() {
        return this.scope;
    }

    public String getRedirectUriParam() {
        return this.redirectUriParam;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public String getDpopJkt() {
        return this.dpopJkt;
    }

    public String getUserSessionId() {
        return this.userSessionId;
    }
}

