/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.concurrent.Callable;
import liquibase.command.CommandFailedException;
import lombok.Generated;

public class ExceptionUtil {
    public static Throwable findExceptionInCauseChain(Throwable exceptionToSearchIn, Class<?> desiredCause) {
        if (exceptionToSearchIn == null || exceptionToSearchIn.getCause() == null) {
            return null;
        }
        if (desiredCause.isAssignableFrom(exceptionToSearchIn.getCause().getClass())) {
            return exceptionToSearchIn;
        }
        return ExceptionUtil.findExceptionInCauseChain(exceptionToSearchIn.getCause(), desiredCause);
    }

    public static boolean showExceptionInLog(Throwable exception) {
        for (Throwable t = exception; t != null; t = t.getCause()) {
            if (!(t instanceof CommandFailedException) || !((CommandFailedException)t).isExpected()) continue;
            return false;
        }
        return true;
    }

    public static <T> T doSilently(Callable<T> callback) {
        try {
            return callback.call();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> void doSilently(ExceptionRunnable callback) {
        try {
            callback.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Generated
    private ExceptionUtil() {
    }

    @FunctionalInterface
    public static interface ExceptionRunnable {
        public void run() throws Exception;
    }
}

