/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;

public class WorkflowStep
implements Comparable<WorkflowStep> {
    private String id;
    private final String providerId;
    private MultivaluedHashMap<String, String> config;

    public WorkflowStep(String providerId, MultivaluedHashMap<String, String> config) {
        this.providerId = providerId;
        this.config = config;
    }

    public WorkflowStep(ComponentModel model) {
        this.id = model.getId();
        this.providerId = model.getProviderId();
        this.config = model.getConfig();
    }

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public WorkflowStep setConfig(String key, String value) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.putSingle((Object)key, (Object)value);
        return this;
    }

    public MultivaluedHashMap<String, String> getConfig() {
        if (this.config == null) {
            return new MultivaluedHashMap();
        }
        return this.config;
    }

    public void setPriority(int priority) {
        this.setConfig("priority", String.valueOf(priority));
    }

    public int getPriority() {
        String value = (String)this.getConfig().getFirst((Object)"priority");
        if (value == null) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return Integer.MAX_VALUE;
        }
    }

    public void setAfter(Long ms) {
        this.setConfig("after", String.valueOf(ms));
    }

    public Long getAfter() {
        return Long.valueOf((String)this.getConfig().getFirstOrDefault((Object)"after", (Object)"0"));
    }

    @Override
    public int compareTo(WorkflowStep other) {
        return Integer.compare(this.getPriority(), other.getPriority());
    }
}

