// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GDKMM_GRAPHENE_SIZE_H
#define _GDKMM_GRAPHENE_SIZE_H

#include <gdkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
struct _graphene_size_t;
using graphene_size_t = _graphene_size_t;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{
namespace Graphene
{
//TODO: When we can break ABI, _CLASS_OPAQUE_COPYABLE -> _CLASS_GENERIC.
// graphene_size_t gobject_; //Not a pointer.
// https://gitlab.gnome.org/GNOME/gtkmm/-/issues/155

/** %Size representation.
 *
 * %Gdk::Graphene::Size represents a size composed of a @a width by a @a height.
 *
 * @newin{4,12}
 */
class GDKMM_API Size
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Size;
  using BaseObjectType = graphene_size_t;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Constructs an invalid object.
   * E.g. for output arguments to methods. There is not much you can do with
   * the object before it has been assigned a valid value.
   */
  Size();

  // Use make_a_copy=true when getting it directly from a struct.
  explicit Size(graphene_size_t* castitem, bool make_a_copy = false);

  Size(const Size& src);
  Size& operator=(const Size& src);

  Size(Size&& other) noexcept;
  Size& operator=(Size&& other) noexcept;

  ~Size() noexcept;

  void swap(Size& other) noexcept;

  graphene_size_t*       gobj()       { return gobject_; }
  const graphene_size_t* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  graphene_size_t* gobj_copy() const;

protected:
  graphene_size_t* gobject_;

private:

  
public:
  Size(float width, float height);

  /** Checks if this instance is valid.
   * It is valid if and only if it contains a value.
   * For instance,
   * @code
   * if (size)
   *   do_something()
   * @endcode
   */
  explicit operator bool() const;

  float get_width() const;
  void set_width(const float& value);
  float get_height() const;
  void set_height(const float& value);

  
  /** Checks whether the two give #graphene_size_t are equal.
   * 
   * @newin{4,12}
   * 
   * @param b A #graphene_size_t.
   * @return `true` if the sizes are equal.
   */
  bool equal(const Size& b) const;


};
} // namespace Graphene
} // namespace Gdk


namespace Gdk
{

namespace Graphene
{

/** @relates Gdk::Graphene::Size
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Size& lhs, Size& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Graphene

} // namespace Gdk

namespace Glib
{

  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Graphene::Size
   */
  GDKMM_API
  Gdk::Graphene::Size wrap(graphene_size_t* object, bool take_copy = false);

} // namespace Glib


#endif /* _GDKMM_GRAPHENE_SIZE_H */

