/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;

@ServiceScope(value={Scope.Global.class})
public class ModelSchemaAspectExtractor {
    private final List<ModelSchemaAspectExtractionStrategy> strategies;

    public ModelSchemaAspectExtractor() {
        this(Collections.emptyList());
    }

    public ModelSchemaAspectExtractor(Collection<ModelSchemaAspectExtractionStrategy> strategies) {
        this.strategies = ImmutableList.copyOf(strategies);
    }

    public <T> List<ModelSchemaAspect> extract(ModelSchemaExtractionContext<T> extractionContext, List<ModelPropertyExtractionResult<?>> propertyResults) {
        ArrayList<ModelSchemaAspect> aspects = new ArrayList<ModelSchemaAspect>();
        for (ModelSchemaAspectExtractionStrategy strategy : this.strategies) {
            ModelSchemaAspectExtractionResult result = strategy.extract(extractionContext, propertyResults);
            if (result == null) continue;
            aspects.add(result.getAspect());
        }
        return aspects;
    }
}

