/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import * as fs from 'node:fs';
import * as path from 'node:path';
import { CommandKind } from './types.js';
import { performInit } from '@google/gemini-cli-core';
export const initCommand = {
    name: 'init',
    description: 'Analyzes the project and creates a tailored GEMINI.md file',
    kind: CommandKind.BUILT_IN,
    autoExecute: true,
    action: async (context, _args) => {
        if (!context.services.config) {
            return {
                type: 'message',
                messageType: 'error',
                content: 'Configuration not available.',
            };
        }
        const targetDir = context.services.config.getTargetDir();
        const geminiMdPath = path.join(targetDir, 'GEMINI.md');
        const result = performInit(fs.existsSync(geminiMdPath));
        if (result.type === 'submit_prompt') {
            // Create an empty GEMINI.md file
            fs.writeFileSync(geminiMdPath, '', 'utf8');
            context.ui.addItem({
                type: 'info',
                text: 'Empty GEMINI.md created. Now analyzing the project to populate it.',
            }, Date.now());
        }
        // eslint-disable-next-line @typescript-eslint/no-unsafe-type-assertion
        return result;
    },
};
//# sourceMappingURL=initCommand.js.map