/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.GlobalConfiguration;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.UpdateSummaryEnum;
import liquibase.UpdateSummaryOutputEnum;
import liquibase.analytics.configuration.AnalyticsArgs;
import liquibase.configuration.ConfiguredValue;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.IntegrationDetails;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.integration.spring.Customizer;
import liquibase.integration.spring.SpringResourceAccessor;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.ui.UIServiceEnum;
import liquibase.util.StringUtil;
import lombok.Generated;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class SpringLiquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    protected final Logger log = Scope.getCurrentScope().getLog(SpringLiquibase.class);
    protected String beanName;
    protected ResourceLoader resourceLoader;
    protected DataSource dataSource;
    protected String changeLog;
    protected String contexts;
    protected String labelFilter;
    protected String tag;
    protected Map<String, String> parameters;
    protected String defaultSchema;
    protected String liquibaseSchema;
    protected String databaseChangeLogTable;
    protected String databaseChangeLogLockTable;
    protected String liquibaseTablespace;
    protected boolean dropFirst;
    protected boolean clearCheckSums;
    protected String licenseKey = null;
    protected Boolean analyticsEnabled = null;
    protected boolean shouldRun = true;
    protected File rollbackFile;
    protected UpdateSummaryEnum showSummary;
    protected UpdateSummaryOutputEnum showSummaryOutput = UpdateSummaryOutputEnum.LOG;
    protected boolean testRollbackOnUpdate = false;
    protected UIServiceEnum uiService = UIServiceEnum.LOGGER;
    protected Customizer<Liquibase> customizer;

    public String getDatabaseProductName() throws DatabaseException {
        Connection connection = null;
        Database database = null;
        String name = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            name = database.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (database != null) {
                database.close();
            } else if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (SQLException e) {
                    this.log.warning("problem closing connection", e);
                }
            }
        }
        return name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    @Deprecated
    public String getLabels() {
        return this.getLabelFilter();
    }

    @Deprecated
    public void setLabels(String labels) {
        this.setLabelFilter(labels);
    }

    public boolean isTestRollbackOnUpdate() {
        return this.testRollbackOnUpdate;
    }

    public void setTestRollbackOnUpdate(boolean testRollbackOnUpdate) {
        this.testRollbackOnUpdate = testRollbackOnUpdate;
    }

    public void afterPropertiesSet() throws LiquibaseException {
        ConfiguredValue<Boolean> shouldRunProperty = LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentConfiguredValue();
        if (!shouldRunProperty.getValue().booleanValue()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Liquibase did not run because " + shouldRunProperty.getProvidedValue().describe() + " was set to false");
            return;
        }
        if (!this.shouldRun) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Liquibase did not run because 'shouldRun' property was set to false on " + this.getBeanName() + " Liquibase Spring bean.");
            return;
        }
        try {
            HashMap<String, Object> scopeVars = new HashMap<String, Object>();
            scopeVars.put(Scope.Attr.ui.name(), this.uiService.getUiServiceClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            scopeVars.put(Scope.Attr.integrationDetails.name(), new IntegrationDetails("spring"));
            if (this.analyticsEnabled != null) {
                scopeVars.put(AnalyticsArgs.ENABLED.getKey(), this.analyticsEnabled);
            }
            scopeVars.put(Scope.Attr.maxAnalyticsCacheSize.name(), 10);
            if (this.licenseKey != null) {
                this.log.fine("Using licenseKey.");
                scopeVars.put("liquibase.licenseKey", this.licenseKey);
            }
            Scope.child(scopeVars, () -> {
                try (Liquibase liquibase = null;){
                    Connection c = this.getDataSource().getConnection();
                    liquibase = this.createLiquibase(c);
                    this.generateRollbackFile(liquibase);
                    this.performUpdate(liquibase);
                }
            });
        }
        catch (Exception e) {
            throw new LiquibaseException(e);
        }
    }

    private void generateRollbackFile(Liquibase liquibase) throws LiquibaseException {
        if (this.rollbackFile != null) {
            try (OutputStream outputStream = Files.newOutputStream(this.rollbackFile.toPath(), new OpenOption[0]);
                 OutputStreamWriter output = new OutputStreamWriter(outputStream, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());){
                if (this.tag != null) {
                    liquibase.futureRollbackSQL(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()), (Writer)output);
                } else {
                    liquibase.futureRollbackSQL(new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()), (Writer)output);
                }
            }
            catch (IOException e) {
                throw new LiquibaseException("Unable to generate rollback file.", e);
            }
        }
    }

    protected void performUpdate(Liquibase liquibase) throws LiquibaseException {
        if (this.isClearCheckSums()) {
            liquibase.clearCheckSums();
        }
        if (this.isTestRollbackOnUpdate()) {
            if (this.tag != null) {
                liquibase.updateTestingRollback(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()));
            } else {
                liquibase.updateTestingRollback(new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()));
            }
        } else if (this.tag != null) {
            liquibase.update(this.tag, new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()));
        } else {
            liquibase.update(new Contexts(this.getContexts()), new LabelExpression(this.getLabelFilter()));
        }
    }

    protected Liquibase createLiquibase(Connection c) throws LiquibaseException {
        SpringResourceAccessor resourceAccessor = this.createResourceOpener();
        Liquibase liquibase = new Liquibase(this.getChangeLog(), (ResourceAccessor)resourceAccessor, this.createDatabase(c, resourceAccessor));
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
        }
        if (this.isDropFirst()) {
            liquibase.dropAll();
        }
        liquibase.setShowSummaryOutput(this.showSummaryOutput);
        liquibase.setShowSummary(this.showSummary);
        if (liquibase.getDatabase() instanceof DerbyDatabase) {
            ((DerbyDatabase)liquibase.getDatabase()).setShutdownEmbeddedDerby(false);
        }
        if (this.customizer != null) {
            this.customizer.customize(liquibase);
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c, ResourceAccessor resourceAccessor) throws DatabaseException {
        DatabaseConnection liquibaseConnection;
        if (c == null) {
            this.log.warning("Null connection returned by liquibase datasource. Using offline unknown database");
            liquibaseConnection = new OfflineConnection("offline:unknown", resourceAccessor);
        } else {
            liquibaseConnection = new JdbcConnection(c);
        }
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(liquibaseConnection);
        if (StringUtil.trimToNull(this.defaultSchema) != null) {
            if (database.supports(Schema.class)) {
                database.setDefaultSchemaName(this.defaultSchema);
            } else if (database.supports(Catalog.class)) {
                database.setDefaultCatalogName(this.defaultSchema);
            }
        }
        if (StringUtil.trimToNull(this.liquibaseSchema) != null) {
            if (database.supports(Schema.class)) {
                database.setLiquibaseSchemaName(this.liquibaseSchema);
            } else if (database.supports(Catalog.class)) {
                database.setLiquibaseCatalogName(this.liquibaseSchema);
            }
        }
        if (StringUtil.trimToNull(this.liquibaseTablespace) != null && database.supportsTablespaces()) {
            database.setLiquibaseTablespaceName(this.liquibaseTablespace);
        }
        if (StringUtil.trimToNull(this.databaseChangeLogTable) != null) {
            database.setDatabaseChangeLogTableName(this.databaseChangeLogTable);
        }
        if (StringUtil.trimToNull(this.databaseChangeLogLockTable) != null) {
            database.setDatabaseChangeLogLockTableName(this.databaseChangeLogLockTable);
        }
        return database;
    }

    public void setChangeLogParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    protected SpringResourceAccessor createResourceOpener() {
        return new SpringResourceAccessor(this.resourceLoader);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setShowSummaryOutput(UpdateSummaryOutputEnum showSummaryOutput) {
        if (showSummaryOutput == null) {
            return;
        }
        this.showSummaryOutput = showSummaryOutput;
    }

    public void setUiService(UIServiceEnum uiService) {
        if (uiService == null) {
            return;
        }
        this.uiService = uiService;
    }

    public String toString() {
        return this.getClass().getName() + "(" + String.valueOf(this.getResourceLoader()) + ")";
    }

    @Generated
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Generated
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Generated
    public String getContexts() {
        return this.contexts;
    }

    @Generated
    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    @Generated
    public String getLabelFilter() {
        return this.labelFilter;
    }

    @Generated
    public void setLabelFilter(String labelFilter) {
        this.labelFilter = labelFilter;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Generated
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Generated
    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    @Generated
    public String getLiquibaseSchema() {
        return this.liquibaseSchema;
    }

    @Generated
    public void setLiquibaseSchema(String liquibaseSchema) {
        this.liquibaseSchema = liquibaseSchema;
    }

    @Generated
    public String getDatabaseChangeLogTable() {
        return this.databaseChangeLogTable;
    }

    @Generated
    public void setDatabaseChangeLogTable(String databaseChangeLogTable) {
        this.databaseChangeLogTable = databaseChangeLogTable;
    }

    @Generated
    public String getDatabaseChangeLogLockTable() {
        return this.databaseChangeLogLockTable;
    }

    @Generated
    public void setDatabaseChangeLogLockTable(String databaseChangeLogLockTable) {
        this.databaseChangeLogLockTable = databaseChangeLogLockTable;
    }

    @Generated
    public String getLiquibaseTablespace() {
        return this.liquibaseTablespace;
    }

    @Generated
    public void setLiquibaseTablespace(String liquibaseTablespace) {
        this.liquibaseTablespace = liquibaseTablespace;
    }

    @Generated
    public boolean isDropFirst() {
        return this.dropFirst;
    }

    @Generated
    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    @Generated
    public boolean isClearCheckSums() {
        return this.clearCheckSums;
    }

    @Generated
    public void setClearCheckSums(boolean clearCheckSums) {
        this.clearCheckSums = clearCheckSums;
    }

    @Generated
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Generated
    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    @Generated
    public Boolean getAnalyticsEnabled() {
        return this.analyticsEnabled;
    }

    @Generated
    public void setAnalyticsEnabled(Boolean analyticsEnabled) {
        this.analyticsEnabled = analyticsEnabled;
    }

    @Generated
    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    @Generated
    public void setRollbackFile(File rollbackFile) {
        this.rollbackFile = rollbackFile;
    }

    @Generated
    public void setShowSummary(UpdateSummaryEnum showSummary) {
        this.showSummary = showSummary;
    }

    @Generated
    public UIServiceEnum getUiService() {
        return this.uiService;
    }

    @Generated
    public Customizer<Liquibase> getCustomizer() {
        return this.customizer;
    }

    @Generated
    public void setCustomizer(Customizer<Liquibase> customizer) {
        this.customizer = customizer;
    }
}

