/*
 * Decompiled with CFR 0.152.
 */
package scala.sys.process;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Null$;
import scala.sys.process.BasicIO$LazilyListed$;
import scala.sys.process.BasicIO$Streamed$;
import scala.sys.process.BasicIO$Uncloseable$;
import scala.sys.process.ProcessIO;
import scala.sys.process.ProcessLogger;
import scala.sys.process.processInternal$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BasicIO$
implements Serializable {
    private static final String Newline;
    public static final BasicIO$LazilyListed$ LazilyListed;
    public static final BasicIO$Streamed$ Streamed;
    public static final BasicIO$Uncloseable$ Uncloseable;
    private static final Function1<OutputStream, BoxedUnit> connectToStdIn;
    private static final Function1<OutputStream, BoxedUnit> connectNoOp;
    public static final BasicIO$ MODULE$;

    private BasicIO$() {
    }

    static {
        MODULE$ = new BasicIO$();
        Newline = System.lineSeparator();
        connectToStdIn = _$3 -> {};
        connectNoOp = _$4 -> {};
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BasicIO$.class);
    }

    public final int BufferSize() {
        return 8192;
    }

    public final String Newline() {
        return Newline;
    }

    public ProcessIO apply(boolean withIn, Function1<String, BoxedUnit> output, Option<ProcessLogger> log) {
        return new ProcessIO(this.input(withIn), this.processFully(output), this.getErr(log));
    }

    public ProcessIO apply(boolean withIn, Appendable buffer, Option<ProcessLogger> log) {
        return new ProcessIO(this.input(withIn), this.processFully(buffer), this.getErr(log));
    }

    public ProcessIO apply(boolean withIn, ProcessLogger log) {
        return new ProcessIO(this.input(withIn), this.processOutFully(log), this.processErrFully(log));
    }

    public Function1<InputStream, BoxedUnit> getErr(Option<ProcessLogger> log) {
        Option<ProcessLogger> option = log;
        if (option instanceof Some) {
            Some some = (Some)option;
            ProcessLogger lg = (ProcessLogger)some.value();
            return this.processErrFully(lg);
        }
        if (None$.MODULE$.equals(option)) {
            return this.toStdErr();
        }
        throw new MatchError(option);
    }

    private Function1<InputStream, BoxedUnit> processErrFully(ProcessLogger log) {
        return this.processFully((String _$1) -> log.err(() -> BasicIO$.processErrFully$$anonfun$1$$anonfun$1(_$1)));
    }

    private Function1<InputStream, BoxedUnit> processOutFully(ProcessLogger log) {
        return this.processFully((String _$2) -> log.out(() -> BasicIO$.processOutFully$$anonfun$1$$anonfun$1(_$2)));
    }

    public void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {}
    }

    public Function1<InputStream, BoxedUnit> processFully(Appendable buffer) {
        return this.processFully(this.appendLine(buffer));
    }

    public Function1<InputStream, BoxedUnit> processFully(Function1<String, BoxedUnit> processLine) {
        return in -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));){
                MODULE$.processLinesFully(processLine, (Function0<String> & Serializable)() -> reader.readLine());
            }
        };
    }

    public void processLinesFully(Function1<String, BoxedUnit> processLine, Function0<String> readLine) {
        this.readFully$1(readLine, processLine);
    }

    public void connectToIn(OutputStream o) {
        this.transferFully(BasicIO$Uncloseable$.MODULE$.protect(scala.sys.process.package$.MODULE$.stdin()), o);
    }

    public Function1<OutputStream, BoxedUnit> input(boolean connect) {
        if (connect) {
            return this.connectToStdIn();
        }
        return this.connectNoOp();
    }

    public Function1<OutputStream, BoxedUnit> connectToStdIn() {
        return connectToStdIn;
    }

    public Function1<OutputStream, BoxedUnit> connectNoOp() {
        return connectNoOp;
    }

    public ProcessIO standard(boolean connectInput) {
        return this.standard(this.input(connectInput));
    }

    public ProcessIO standard(Function1<OutputStream, BoxedUnit> in) {
        return new ProcessIO(in, this.toStdOut(), this.toStdErr());
    }

    public Function1<InputStream, BoxedUnit> toStdErr() {
        return in -> MODULE$.transferFully((InputStream)in, scala.sys.process.package$.MODULE$.stderr());
    }

    public Function1<InputStream, BoxedUnit> toStdOut() {
        return in -> MODULE$.transferFully((InputStream)in, scala.sys.process.package$.MODULE$.stdout());
    }

    public void transferFully(InputStream in, OutputStream out) {
        try {
            this.transferFullyImpl(in, out);
        }
        catch (Throwable ex$) {
            PartialFunction $1$ = processInternal$.MODULE$.onIOInterrupt((Function0<Object> & Serializable)() -> {
                BasicIO$.$anonfun$2();
                return BoxedUnit.UNIT;
            });
            if ($1$.isDefinedAt(ex$)) {
                $1$.apply(ex$);
            }
            throw ex$;
        }
    }

    private Function1<String, BoxedUnit> appendLine(Appendable buffer) {
        return line -> {
            buffer.append((CharSequence)line);
            buffer.append(MODULE$.Newline());
        };
    }

    private void transferFullyImpl(InputStream in, OutputStream out) {
        byte[] buffer = new byte[8192];
        this.loop$1(in, buffer, out);
        in.close();
    }

    public static final /* synthetic */ Option scala$sys$process$BasicIO$LazilyListed$$$_$_$$anonfun$1(boolean nonzeroException$1, LinkedBlockingQueue q) {
        Either either = (Either)q.take();
        if (either instanceof Left) {
            Left left = (Left)either;
            int n = BoxesRunTime.unboxToInt(left.value());
            if (0 == n) {
                return None$.MODULE$;
            }
            int code = n;
            if (nonzeroException$1) {
                throw scala.sys.package$.MODULE$.error("Nonzero exit code: " + code);
            }
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Object s = right.value();
            return Some$.MODULE$.apply(Tuple2$.MODULE$.apply(s, q));
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ void scala$sys$process$BasicIO$LazilyListed$$$_$apply$$anonfun$1(LinkedBlockingQueue queue$1, Object s) {
        queue$1.put(package$.MODULE$.Right().apply(s));
    }

    public static /* bridge */ /* synthetic */ Object scala$sys$process$BasicIO$LazilyListed$$$_$apply$$anonfun$adapted$1(LinkedBlockingQueue queue$3, Object v1) {
        queue$3.put(package$.MODULE$.Left().apply(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(v1))));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void scala$sys$process$BasicIO$Streamed$$$_$apply$$anonfun$3(LinkedBlockingQueue q$2, Object s) {
        q$2.put(package$.MODULE$.Right().apply(s));
    }

    public static /* bridge */ /* synthetic */ Object scala$sys$process$BasicIO$Streamed$$$_$apply$$anonfun$adapted$2(LinkedBlockingQueue q$5, Object v1) {
        q$5.put(package$.MODULE$.Left().apply(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(v1))));
        return BoxedUnit.UNIT;
    }

    private static final String processErrFully$$anonfun$1$$anonfun$1(String _$1$1) {
        return _$1$1;
    }

    private static final String processOutFully$$anonfun$1$$anonfun$1(String _$2$1) {
        return _$2$1;
    }

    private final boolean working$1() {
        return !Thread.currentThread().isInterrupted();
    }

    private final Null$ halting$1() {
        Thread.currentThread().interrupt();
        return null;
    }

    private final void readFully$1(Function0 readLine$1, Function1 processLine$2) {
        while (this.working$1()) {
            String line;
            String string2;
            try {
                string2 = (String)readLine$1.apply();
            }
            catch (InterruptedException interruptedException) {
                this.halting$1();
                string2 = null;
            }
            catch (Throwable throwable) {
                block9: {
                    block8: {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof IOException)) break block8;
                        IOException iOException = (IOException)throwable2;
                        if (!this.working$1()) break block9;
                    }
                    throw throwable;
                }
                this.halting$1();
                string2 = line = null;
            }
            if (line != null) {
                processLine$2.apply(line);
                continue;
            }
            return;
        }
    }

    private static final void $anonfun$2() {
    }

    private final void loop$1(InputStream in$2, byte[] buffer$2, OutputStream out$2) {
        int byteCount;
        while ((byteCount = in$2.read(buffer$2)) > 0) {
            boolean available;
            boolean bl;
            out$2.write(buffer$2, 0, byteCount);
            try {
                out$2.flush();
                bl = true;
            }
            catch (IOException iOException) {
                bl = available = false;
            }
            if (available) continue;
            return;
        }
    }
}

