/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Arrays;
import scala.MatchError;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector0$;
import scala.collection.immutable.Vector1;
import scala.collection.immutable.Vector2;
import scala.collection.immutable.Vector3;
import scala.collection.immutable.Vector4;
import scala.collection.immutable.Vector5;
import scala.collection.immutable.Vector6;
import scala.collection.immutable.VectorInline$;
import scala.collection.immutable.VectorStatics$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public final class VectorSliceBuilder {
    private final int lo;
    private final int hi;
    private final Object[][] slices;
    private int len;
    private int pos;
    private int maxDim;

    public VectorSliceBuilder(int lo, int hi) {
        this.lo = lo;
        this.hi = hi;
        this.slices = new Object[11][];
        this.len = 0;
        this.pos = 0;
        this.maxDim = 0;
    }

    private int prefixIdx(int n) {
        return n - 1;
    }

    private int suffixIdx(int n) {
        return 11 - n;
    }

    public <T> void consider(int n, T[] a) {
        int count = a.length * (1 << 5 * (n - 1));
        int lo0 = Math.max(this.lo - this.pos, 0);
        int hi0 = Math.min(this.hi - this.pos, count);
        if (hi0 > lo0) {
            this.addSlice(n, a, lo0, hi0);
            this.len += hi0 - lo0;
        }
        this.pos += count;
    }

    private <T> void addSlice(int n, T[] a, int lo, int hi) {
        while (true) {
            if (n == 1) {
                this.add(1, VectorInline$.MODULE$.copyOrUse(a, lo, hi));
                return;
            }
            int bitsN = 5 * (n - 1);
            int widthN = 1 << bitsN;
            int loN = lo >>> bitsN;
            int hiN = hi >>> bitsN;
            int loRest = lo & widthN - 1;
            int hiRest = hi & widthN - 1;
            if (loRest == 0) {
                if (hiRest == 0) {
                    this.add(n, VectorInline$.MODULE$.copyOrUse(a, loN, hiN));
                    return;
                }
                if (hiN > loN) {
                    this.add(n, VectorInline$.MODULE$.copyOrUse(a, loN, hiN));
                }
                int n2 = n - 1;
                Object[] objectArray = (Object[])a[hiN];
                int n3 = 0;
                int n4 = hiRest;
                n = n2;
                a = objectArray;
                lo = n3;
                hi = n4;
                continue;
            }
            if (hiN == loN) {
                int n5 = n - 1;
                Object[] objectArray = (Object[])a[loN];
                int n6 = loRest;
                int n7 = hiRest;
                n = n5;
                a = objectArray;
                lo = n6;
                hi = n7;
                continue;
            }
            this.addSlice(n - 1, (Object[])a[loN], loRest, widthN);
            if (hiRest == 0) {
                if (hiN > loN + 1) {
                    this.add(n, VectorInline$.MODULE$.copyOrUse(a, loN + 1, hiN));
                    return;
                }
                return;
            }
            if (hiN > loN + 1) {
                this.add(n, VectorInline$.MODULE$.copyOrUse(a, loN + 1, hiN));
            }
            int n8 = n - 1;
            Object[] objectArray = (Object[])a[hiN];
            int n9 = 0;
            int n10 = hiRest;
            n = n8;
            a = objectArray;
            lo = n9;
            hi = n10;
        }
    }

    private <T> void add(int n, T[] a) {
        int n2;
        if (n <= this.maxDim) {
            n2 = this.suffixIdx(n);
        } else {
            this.maxDim = n;
            n2 = this.prefixIdx(n);
        }
        int idx = n2;
        this.slices[idx] = a;
    }

    public <A> Vector<A> result() {
        Object[] x$proxy1;
        if (this.len <= 32) {
            Object[] objectArray;
            if (this.len == 0) {
                return Vector0$.MODULE$;
            }
            Object[] prefix1 = this.slices[this.prefixIdx(1)];
            Object[] suffix1 = this.slices[this.suffixIdx(1)];
            if (!(prefix1 == null)) {
                objectArray = !(suffix1 == null) ? VectorInline$.MODULE$.concatArrays(prefix1, suffix1) : prefix1;
            } else if (!(suffix1 == null)) {
                objectArray = suffix1;
            } else {
                Object[][] prefix2 = (Object[][])this.slices[this.prefixIdx(2)];
                if (!(prefix2 == null)) {
                    objectArray = prefix2[0];
                } else {
                    Object[][] suffix2 = (Object[][])this.slices[this.suffixIdx(2)];
                    objectArray = suffix2[0];
                }
            }
            Object[] a = objectArray;
            return new Vector1(a);
        }
        this.balancePrefix(1);
        this.balanceSuffix(1);
        int resultDim = this.maxDim;
        if (resultDim < 6) {
            Object[] pre = this.slices[this.prefixIdx(this.maxDim)];
            Object[] suf = this.slices[this.suffixIdx(this.maxDim)];
            if (!(pre == null) && !(suf == null)) {
                if (pre.length + suf.length <= 30) {
                    this.slices[this.prefixIdx((int)this.maxDim)] = VectorInline$.MODULE$.concatArrays(pre, suf);
                    this.slices[this.suffixIdx((int)this.maxDim)] = null;
                } else {
                    ++resultDim;
                }
            } else {
                Object[] one;
                Object[] objectArray = one = !(pre == null) ? pre : suf;
                if (one == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (one.length > 30) {
                    ++resultDim;
                }
            }
        }
        if ((x$proxy1 = this.slices[this.prefixIdx(1)]) == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        Object[] prefix1 = x$proxy1;
        Object[] x$proxy2 = this.slices[this.suffixIdx(1)];
        if (x$proxy2 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        Object[] suffix1 = x$proxy2;
        int len1 = prefix1.length;
        int n = resultDim;
        Vector2 res = switch (n) {
            case 2 -> {
                Object[][] data2 = (Object[][])this.dataOr(2, (T[])VectorStatics$.MODULE$.empty2());
                yield new Vector2(prefix1, len1, data2, suffix1, this.len);
            }
            case 3 -> {
                Object[][] prefix2 = (Object[][])this.prefixOr(2, (T[])VectorStatics$.MODULE$.empty2());
                Object[][][] data3 = (Object[][][])this.dataOr(3, (T[])VectorStatics$.MODULE$.empty3());
                Object[][] suffix2 = (Object[][])this.suffixOr(2, (T[])VectorStatics$.MODULE$.empty2());
                int len12 = len1 + prefix2.length * 32;
                yield new Vector3(prefix1, len1, prefix2, len12, data3, suffix2, suffix1, this.len);
            }
            case 4 -> {
                Object[][] prefix2 = (Object[][])this.prefixOr(2, (T[])VectorStatics$.MODULE$.empty2());
                Object[][][] prefix3 = (Object[][][])this.prefixOr(3, (T[])VectorStatics$.MODULE$.empty3());
                Object[][][][] data4 = (Object[][][][])this.dataOr(4, (T[])VectorStatics$.MODULE$.empty4());
                Object[][][] suffix3 = (Object[][][])this.suffixOr(3, (T[])VectorStatics$.MODULE$.empty3());
                Object[][] suffix2 = (Object[][])this.suffixOr(2, (T[])VectorStatics$.MODULE$.empty2());
                int len12 = len1 + prefix2.length * 32;
                int len123 = len12 + prefix3.length * 1024;
                yield new Vector4(prefix1, len1, prefix2, len12, prefix3, len123, data4, suffix3, suffix2, suffix1, this.len);
            }
            case 5 -> {
                Object[][] prefix2 = (Object[][])this.prefixOr(2, (T[])VectorStatics$.MODULE$.empty2());
                Object[][][] prefix3 = (Object[][][])this.prefixOr(3, (T[])VectorStatics$.MODULE$.empty3());
                Object[][][][] prefix4 = (Object[][][][])this.prefixOr(4, (T[])VectorStatics$.MODULE$.empty4());
                Object[][][][][] data5 = (Object[][][][][])this.dataOr(5, (T[])VectorStatics$.MODULE$.empty5());
                Object[][][][] suffix4 = (Object[][][][])this.suffixOr(4, (T[])VectorStatics$.MODULE$.empty4());
                Object[][][] suffix3 = (Object[][][])this.suffixOr(3, (T[])VectorStatics$.MODULE$.empty3());
                Object[][] suffix2 = (Object[][])this.suffixOr(2, (T[])VectorStatics$.MODULE$.empty2());
                int len12 = len1 + prefix2.length * 32;
                int len123 = len12 + prefix3.length * 1024;
                int len1234 = len123 + prefix4.length * 32768;
                yield new Vector5(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, data5, suffix4, suffix3, suffix2, suffix1, this.len);
            }
            case 6 -> {
                Object[][] prefix2 = (Object[][])this.prefixOr(2, (T[])VectorStatics$.MODULE$.empty2());
                Object[][][] prefix3 = (Object[][][])this.prefixOr(3, (T[])VectorStatics$.MODULE$.empty3());
                Object[][][][] prefix4 = (Object[][][][])this.prefixOr(4, (T[])VectorStatics$.MODULE$.empty4());
                Object[][][][][] prefix5 = (Object[][][][][])this.prefixOr(5, (T[])VectorStatics$.MODULE$.empty5());
                Object[][][][][][] data6 = (Object[][][][][][])this.dataOr(6, (T[])VectorStatics$.MODULE$.empty6());
                Object[][][][][] suffix5 = (Object[][][][][])this.suffixOr(5, (T[])VectorStatics$.MODULE$.empty5());
                Object[][][][] suffix4 = (Object[][][][])this.suffixOr(4, (T[])VectorStatics$.MODULE$.empty4());
                Object[][][] suffix3 = (Object[][][])this.suffixOr(3, (T[])VectorStatics$.MODULE$.empty3());
                Object[][] suffix2 = (Object[][])this.suffixOr(2, (T[])VectorStatics$.MODULE$.empty2());
                int len12 = len1 + prefix2.length * 32;
                int len123 = len12 + prefix3.length * 1024;
                int len1234 = len123 + prefix4.length * 32768;
                int len12345 = len1234 + prefix5.length * 0x100000;
                yield new Vector6(prefix1, len1, prefix2, len12, prefix3, len123, prefix4, len1234, prefix5, len12345, data6, suffix5, suffix4, suffix3, suffix2, suffix1, this.len);
            }
            default -> throw new MatchError(BoxesRunTime.boxToInteger(n));
        };
        return res;
    }

    private <T> T[] prefixOr(int n, T[] a) {
        Object[] p = this.slices[this.prefixIdx(n)];
        if (!(p == null)) {
            return p;
        }
        return a;
    }

    private <T> T[] suffixOr(int n, T[] a) {
        Object[] s = this.slices[this.suffixIdx(n)];
        if (!(s == null)) {
            return s;
        }
        return a;
    }

    private <T> T[] dataOr(int n, T[] a) {
        Object[] p = this.slices[this.prefixIdx(n)];
        if (!(p == null)) {
            return p;
        }
        Object[] s = this.slices[this.suffixIdx(n)];
        if (!(s == null)) {
            return s;
        }
        return a;
    }

    private void balancePrefix(int n) {
        if (this.slices[this.prefixIdx(n)] == null) {
            if (n == this.maxDim) {
                this.slices[this.prefixIdx((int)n)] = this.slices[this.suffixIdx(n)];
                this.slices[this.suffixIdx((int)n)] = null;
                return;
            }
            this.balancePrefix(n + 1);
            Object[][] preN1 = (Object[][])this.slices[this.prefixIdx(n + 1)];
            this.slices[this.prefixIdx((int)n)] = preN1[0];
            if (preN1.length == 1) {
                this.slices[this.prefixIdx((int)(n + 1))] = null;
                if (this.maxDim == n + 1 && this.slices[this.suffixIdx(n + 1)] == null) {
                    this.maxDim = n;
                    return;
                }
                return;
            }
            this.slices[this.prefixIdx((int)(n + 1))] = Arrays.copyOfRange(preN1, 1, preN1.length);
            return;
        }
    }

    private void balanceSuffix(int n) {
        if (this.slices[this.suffixIdx(n)] == null) {
            if (n == this.maxDim) {
                this.slices[this.suffixIdx((int)n)] = this.slices[this.prefixIdx(n)];
                this.slices[this.prefixIdx((int)n)] = null;
                return;
            }
            this.balanceSuffix(n + 1);
            Object[][] sufN1 = (Object[][])this.slices[this.suffixIdx(n + 1)];
            this.slices[this.suffixIdx((int)n)] = sufN1[sufN1.length - 1];
            if (sufN1.length == 1) {
                this.slices[this.suffixIdx((int)(n + 1))] = null;
                if (this.maxDim == n + 1 && this.slices[this.prefixIdx(n + 1)] == null) {
                    this.maxDim = n;
                    return;
                }
                return;
            }
            this.slices[this.suffixIdx((int)(n + 1))] = Arrays.copyOfRange(sufN1, 0, sufN1.length - 1);
            return;
        }
    }

    public String toString() {
        return "VectorSliceBuilder(lo=" + this.lo + ", hi=" + this.hi + ", len=" + this.len + ", pos=" + this.pos + ", maxDim=" + this.maxDim + ")";
    }

    public Object[][] getSlices() {
        return this.slices;
    }
}

