/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class ItemUtil {
    public static final String EXTENSION_SEPARATOR = ":";

    private ItemUtil() {
    }

    public static boolean isValidItemName(@Nullable String itemName) {
        return itemName != null && !itemName.isEmpty() && itemName.matches("[a-zA-Z_][a-zA-Z0-9_]*");
    }

    public static void assertValidItemName(String itemName) throws IllegalArgumentException {
        if (!ItemUtil.isValidItemName(itemName)) {
            throw new IllegalArgumentException("The specified name of the item '" + itemName + "' is not valid!");
        }
    }

    public static String getMainItemType(String itemTypeName) {
        Objects.requireNonNull(itemTypeName);
        if (itemTypeName.contains(EXTENSION_SEPARATOR)) {
            return itemTypeName.substring(0, itemTypeName.indexOf(EXTENSION_SEPARATOR));
        }
        return itemTypeName;
    }

    public static @Nullable String getItemTypeExtension(@Nullable String itemTypeName) {
        if (itemTypeName == null) {
            return null;
        }
        if (itemTypeName.contains(EXTENSION_SEPARATOR)) {
            return itemTypeName.substring(itemTypeName.indexOf(EXTENSION_SEPARATOR) + 1);
        }
        return null;
    }
}

