/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.internal.extension;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.console.ConsoleCommandCompleter;
import org.openhab.core.io.console.StringsCompleter;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemNotUniqueException;
import org.openhab.core.items.ItemRegistry;

@NonNullByDefault
public class ItemConsoleCommandCompleter
implements ConsoleCommandCompleter {
    private final ItemRegistry itemRegistry;
    private final @Nullable Function<Item, Class<?>[]> dataTypeGetter;

    public ItemConsoleCommandCompleter(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
        this.dataTypeGetter = null;
    }

    public ItemConsoleCommandCompleter(ItemRegistry itemRegistry, Function<Item, Class<?>[]> dataTypeGetter) {
        this.itemRegistry = itemRegistry;
        this.dataTypeGetter = dataTypeGetter;
    }

    @Override
    public boolean complete(String[] args, int cursorArgumentIndex, int cursorPosition, List<String> candidates) {
        if (cursorArgumentIndex <= 0) {
            return new StringsCompleter(this.itemRegistry.getAll().stream().map(Item::getName).toList(), true).complete(args, cursorArgumentIndex, cursorPosition, candidates);
        }
        Function<Item, Class<?>[]> localDataTypeGetter = this.dataTypeGetter;
        if (cursorArgumentIndex == 1 && localDataTypeGetter != null) {
            try {
                Item item = this.itemRegistry.getItemByPattern(args[0]);
                Stream<Class> enums = Stream.of(localDataTypeGetter.apply(item)).filter(Class::isEnum);
                Stream<String> enumConstants = enums.flatMap(t -> Stream.of(Objects.requireNonNull((Enum[])t.getEnumConstants())));
                return new StringsCompleter(enumConstants.map(Object::toString).toList(), false).complete(args, cursorArgumentIndex, cursorPosition, candidates);
            }
            catch (ItemNotFoundException | ItemNotUniqueException e) {
                return false;
            }
        }
        return false;
    }
}

