/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.state;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;

@Component(name="ServiceComponentRuntimeBundleStateService")
public class ScrBundleStateService
implements BundleStateService {
    @Reference
    private ServiceComponentRuntime scr;

    public String getName() {
        return "Declarative Services";
    }

    public String getDiag(Bundle bundle) {
        return this.allCompConfigs(bundle).map(this::diagComponent).collect(Collectors.joining());
    }

    public BundleState getState(Bundle bundle) {
        boolean waiting = bundle.getState() == 32 && this.allCompConfigs(bundle).anyMatch(this::unsatisfied);
        return waiting ? BundleState.Waiting : BundleState.Unknown;
    }

    private String diagComponent(ComponentConfigurationDTO cfg) {
        StringBuilder sb = new StringBuilder();
        sb.append(cfg.description.name).append(" (").append(cfg.id).append(")\n");
        if ((cfg.state & 1) != 0) {
            sb.append("  missing configurations: ");
            sb.append(String.join((CharSequence)", ", cfg.description.configurationPid));
            sb.append("\n");
        }
        if ((cfg.state & 2) != 0) {
            sb.append("  missing references: ");
            String references = Arrays.asList(cfg.unsatisfiedReferences).stream().map(ref -> ref.name).collect(Collectors.joining(", "));
            sb.append(references);
            sb.append("\n");
        }
        return sb.toString();
    }

    private Stream<ComponentConfigurationDTO> allCompConfigs(Bundle bundle) {
        return this.scr.getComponentDescriptionDTOs(new Bundle[]{bundle}).stream().flatMap(desc -> this.scr.getComponentConfigurationDTOs(desc).stream());
    }

    private boolean unsatisfied(ComponentConfigurationDTO cfg) {
        return cfg.state != 8 && cfg.state != 4;
    }
}

