/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.tasks.GTreeExpandPathsTask;
import docking.widgets.tree.tasks.GTreeSelectPathsTask;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import javax.swing.tree.TreePath;

public class GTreeRestoreTreeStateTask
extends GTreeTask {
    private GTreeState state;

    public GTreeRestoreTreeStateTask(GTree gTree, GTreeState state) {
        super(gTree);
        this.state = state;
    }

    public void run(TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        if (this.state == null) {
            return;
        }
        if (this.tree.hasFilterText()) {
            monitor.setMessage("Restoring tree selection state");
            this.selectPathsInThisTask(this.state, monitor, false);
        } else {
            monitor.setMessage("Restoring tree expansion state");
            this.expandPathsInThisTask(this.state, monitor);
            monitor.setMessage("Restoring tree selection state");
            this.selectPathsInThisTask(this.state, monitor, true);
            this.tree.expandedStateRestored(monitor);
            this.tree.clearFilterRestoreState();
        }
    }

    private void selectPathsInThisTask(GTreeState treeState, TaskMonitor monitor, boolean disableExpansion) {
        List<TreePath> selectedPaths = treeState.getSelectedPaths();
        if (selectedPaths.isEmpty()) {
            this.restoreViewToFirstPathIn(treeState.getViewPaths(), monitor);
            return;
        }
        GTreeSelectPathsTask task = new GTreeSelectPathsTask(this.tree, this.jTree, selectedPaths, GTreeSelectionEvent.EventOrigin.INTERNAL_GENERATED);
        task.setExpandingDisabled(disableExpansion);
        task.run(monitor);
    }

    private void restoreViewToFirstPathIn(TreePath[] viewPaths, TaskMonitor monitor) {
        for (TreePath path : viewPaths) {
            TreePath currentPath = this.translatePath(path, monitor);
            if (currentPath == null) continue;
            Swing.runLater(() -> this.tree.scrollPathToVisible(currentPath));
            break;
        }
    }

    private void expandPathsInThisTask(GTreeState treeState, TaskMonitor monitor) {
        List<TreePath> expandedPaths = treeState.getExpandedPaths();
        GTreeExpandPathsTask task = new GTreeExpandPathsTask(this.tree, expandedPaths);
        task.run(monitor);
    }
}

