/*
 * Decompiled with CFR 0.152.
 */
package docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;

public class DropDownMenuIcon
implements Icon {
    private static final int ICON_SIZE = 16;
    private Color color;
    private Shape shape;

    public DropDownMenuIcon(Color color) {
        this.color = color;
        this.shape = this.buildShape();
    }

    private Shape buildShape() {
        GeneralPath path = new GeneralPath();
        double iconSize = 16.0;
        double height = 6.0;
        double width = 10.0;
        double leftMargin = (iconSize - width) / 2.0;
        double topMargin = (iconSize - height) / 2.0;
        double p1x = leftMargin + width / 2.0;
        double p1y = topMargin + height;
        double p2x = leftMargin;
        double p2y = topMargin;
        double p3x = leftMargin + width;
        double p3y = topMargin;
        path.moveTo(p1x, p1y);
        path.lineTo(p2x, p2y);
        path.lineTo(p3x, p3y);
        path.lineTo(p1x, p1y);
        path.closePath();
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            g2d.translate(x, y);
            g2d.setColor(this.color);
            g2d.fill(this.shape);
        }
        finally {
            g2d.translate(-x, -y);
        }
    }

    @Override
    public int getIconWidth() {
        return 16;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }
}

