/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.swift.SwiftDemangledNodeKind;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftFunction;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftAllocatorNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        String name = null;
        Demangled namespace = null;
        Demangled type = null;
        Demangled labelList = null;
        String callingConvention = "default";
        block7: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Class: {
                    namespace = child.demangle(demangler);
                    name = "__allocating_init";
                    callingConvention = "__thiscall";
                    continue block7;
                }
                case Extension: {
                    namespace = child.demangle(demangler);
                    if (child.hasChild(SwiftDemangledNodeKind.Class)) {
                        name = "__allocating_init";
                        callingConvention = "__thiscall";
                        continue block7;
                    }
                    if (child.hasChild(SwiftDemangledNodeKind.Protocol) || child.hasChild(SwiftDemangledNodeKind.Structure)) {
                        name = "init";
                        continue block7;
                    }
                    return this.getUnknown();
                }
                case Enum: 
                case Protocol: 
                case Structure: {
                    namespace = child.demangle(demangler);
                    name = "init";
                    continue block7;
                }
                case Type: {
                    type = child.demangle(demangler);
                    continue block7;
                }
                case LabelList: {
                    labelList = child.demangle(demangler);
                    continue block7;
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        SwiftFunction function = new SwiftFunction(this.properties.mangled(), this.properties.originalDemangled(), name, namespace, callingConvention);
        if (type instanceof SwiftFunction) {
            SwiftFunction functionType = (SwiftFunction)type;
            function.setType(functionType, labelList);
        }
        return function;
    }
}

