/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.WeakSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;

class CopyOnWriteWeakSet<T>
extends WeakSet<T> {
    CopyOnWriteWeakSet() {
    }

    @Override
    public Iterator<T> iterator() {
        return IteratorUtils.unmodifiableIterator(this.weakHashStorage.keySet().iterator());
    }

    @Override
    public synchronized boolean add(T t) {
        this.maybeWarnAboutAnonymousValue(t);
        WeakHashMap newStorage = new WeakHashMap(this.weakHashStorage);
        boolean contains = newStorage.containsKey(t);
        newStorage.put(t, null);
        this.weakHashStorage = newStorage;
        return !contains;
    }

    @Override
    public synchronized boolean remove(Object t) {
        WeakHashMap newStorage = new WeakHashMap(this.weakHashStorage);
        boolean contains = newStorage.containsKey(t);
        newStorage.remove(t);
        this.weakHashStorage = newStorage;
        return contains;
    }

    @Override
    public synchronized void clear() {
        this.weakHashStorage = new WeakHashMap();
    }

    @Override
    public Collection<T> values() {
        return this.weakHashStorage.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.weakHashStorage.isEmpty();
    }

    @Override
    public int size() {
        return this.weakHashStorage.size();
    }

    @Override
    public boolean contains(Object t) {
        return this.weakHashStorage.containsKey(t);
    }

    @Override
    public Stream<T> stream() {
        return this.values().stream();
    }

    public String toString() {
        return this.values().toString();
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        WeakHashMap newStorage = new WeakHashMap(this.weakHashStorage);
        for (T t : c) {
            changed |= !newStorage.containsKey(t);
            newStorage.put(t, null);
        }
        this.weakHashStorage = newStorage;
        return changed;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        WeakHashMap newStorage = new WeakHashMap(this.weakHashStorage);
        boolean changed = false;
        for (Object t : newStorage.keySet()) {
            if (c.contains(t)) continue;
            newStorage.remove(t);
            changed = true;
        }
        this.weakHashStorage = newStorage;
        return changed;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        WeakHashMap newStorage = new WeakHashMap(this.weakHashStorage);
        boolean changed = newStorage.keySet().removeAll(c);
        this.weakHashStorage = newStorage;
        return changed;
    }
}

