/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFDataInstanceHelper;
import ghidra.app.util.bin.format.dwarf.DWARFDataTypeConflictHandler;
import ghidra.app.util.bin.format.dwarf.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf.DWARFLocation;
import ghidra.app.util.bin.format.dwarf.DWARFLocationList;
import ghidra.app.util.bin.format.dwarf.DWARFName;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.app.util.bin.format.dwarf.DWARFRangeList;
import ghidra.app.util.bin.format.dwarf.DWARFSourceInfo;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.dwarf.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpression;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.table.field.AddressBasedLocation;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class DWARFFunctionImporter {
    private static final int INLINE_FUNC_SHORT_LEN = 8;
    private final DWARFProgram prog;
    private final Program currentProgram;
    private final DWARFDataTypeManager dwarfDTM;
    private final DWARFImportOptions importOptions;
    private final DWARFImportSummary importSummary;
    private ProgramModule rootModule;
    private Set<Long> processedOffsets = new HashSet<Long>();
    private Set<Address> functionsProcessed = new HashSet<Address>();
    private Set<Address> variablesProcesesed = new HashSet<Address>();
    private TaskMonitor monitor;

    public static boolean hasDWARFProgModule(Program prog, String progModuleName) {
        ProgramModule dwarfModule = prog.getListing().getRootModule(progModuleName);
        return dwarfModule != null;
    }

    public DWARFFunctionImporter(DWARFProgram prog, TaskMonitor monitor) {
        this.prog = prog;
        this.monitor = monitor;
        this.currentProgram = prog.getGhidraProgram();
        this.dwarfDTM = prog.getDwarfDTM();
        this.importOptions = prog.getImportOptions();
        this.importSummary = prog.getImportSummary();
    }

    private boolean shouldProcess(DIEAggregate diea) {
        if (this.processedOffsets.contains(diea.getOffset())) {
            return false;
        }
        this.processedOffsets.add(diea.getOffset());
        return true;
    }

    public void importFunctions() throws CancelledException {
        this.rootModule = this.currentProgram.getListing().getRootModule("DWARF");
        if (this.rootModule == null) {
            try {
                this.rootModule = this.currentProgram.getListing().createRootModule("DWARF");
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
        this.monitor.initialize((long)this.prog.getTotalAggregateCount(), "DWARF - Create Funcs & Symbols");
        for (DIEAggregate diea : this.prog.allAggregates()) {
            this.monitor.increment();
            try {
                switch (diea.getTag()) {
                    case DW_TAG_gnu_call_site: 
                    case DW_TAG_call_site: {
                        diea = DIEAggregate.createSkipHead(diea);
                    }
                    case DW_TAG_subprogram: {
                        try {
                            this.processSubprogram(diea);
                        }
                        catch (InvalidInputException e) {
                            Msg.error((Object)this, (Object)("Failed to process subprog " + diea.getHexOffset()), (Throwable)e);
                        }
                        break;
                    }
                    case DW_TAG_variable: {
                        if (diea.getDepth() != 1) break;
                        this.outputGlobal(DWARFVariable.readGlobalVariable(diea));
                        break;
                    }
                    case DW_TAG_label: {
                        this.processLabel(diea);
                        break;
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                throw oom;
            }
            catch (Throwable th) {
                Msg.error((Object)this, (Object)"Error when processing DWARF information for DIE %x".formatted(diea.getOffset()), (Throwable)th);
                Msg.info((Object)this, (Object)("DIE info:\n" + diea.toString()));
            }
        }
    }

    private void markAllChildrenAsProcessed(DebugInfoEntry die) {
        for (DebugInfoEntry child : die.getChildren()) {
            this.processedOffsets.add(child.getOffset());
            this.markAllChildrenAsProcessed(child);
        }
    }

    private void processSubprogram(DIEAggregate diea) throws IOException, InvalidInputException, DWARFExpressionException {
        if (diea == null || !this.shouldProcess(diea)) {
            return;
        }
        DWARFFunction dfunc = DWARFFunction.read(diea);
        if (dfunc == null) {
            this.markAllChildrenAsProcessed(diea.getHeadFragment());
            return;
        }
        FunctionDefinition origFuncDef = dfunc.asFunctionDefinition(true);
        if (this.functionsProcessed.contains(dfunc.address)) {
            this.markAllChildrenAsProcessed(dfunc.diea.getHeadFragment());
            Function currentFunction = this.currentProgram.getListing().getFunctionAt(dfunc.address);
            if (currentFunction != null) {
                this.decorateFunctionWithAlternateInfo(dfunc, currentFunction, origFuncDef);
            }
            return;
        }
        this.functionsProcessed.add(dfunc.address);
        this.processFuncChildren(diea, dfunc, 0L);
        if (!dfunc.syncWithExistingGhidraFunction(true)) {
            return;
        }
        dfunc.runFixups();
        String defaultCC = this.prog.getImportOptions().getDefaultCC();
        if (defaultCC != null && defaultCC.isBlank()) {
            defaultCC = null;
        }
        if (dfunc.callingConventionName == null && defaultCC != null) {
            dfunc.callingConventionName = defaultCC;
        }
        this.decorateFunctionWithDWARFInfo(dfunc, origFuncDef);
        if (dfunc.signatureCommitMode != DWARFFunction.CommitMode.SKIP) {
            dfunc.updateFunctionSignature();
        } else {
            this.prog.logWarningAt(dfunc.function.getEntryPoint(), dfunc.function.getName(), "Failed to get DWARF function signature information, leaving undefined");
        }
        for (DWARFVariable localVar : dfunc.localVars) {
            if (localVar.isRamStorage()) {
                this.outputGlobal(localVar);
                continue;
            }
            dfunc.commitLocalVariable(localVar);
        }
        if (this.importOptions.isCreateFuncSignatures()) {
            FunctionDefinition funcDefDT = dfunc.asFunctionDefinition(false);
            funcDefDT = this.prog.getGhidraProgram().getDataTypeManager().addDataType((DataType)funcDefDT, (DataTypeConflictHandler)DWARFDataTypeConflictHandler.INSTANCE);
            this.dwarfDTM.addDataType(diea.getOffset(), (DataType)funcDefDT, DWARFSourceInfo.getSourceInfoWithFallbackToParent(diea));
        }
    }

    private void decorateFunctionWithAlternateInfo(DWARFFunction dfunc, Function gfunc, FunctionDefinition funcDef) {
        String newAlternatePrototype = funcDef.getPrototypeString(false);
        String currentPrototype = gfunc.getSignature(true).getPrototypeString(false);
        if (!currentPrototype.equals(newAlternatePrototype)) {
            this.appendPlateComment(dfunc.address, "DWARF alternate signature: ", newAlternatePrototype);
        }
    }

    private void decorateFunctionWithDWARFInfo(DWARFFunction dfunc, FunctionDefinition origFuncDef) {
        if (dfunc.sourceInfo != null) {
            this.moveIntoFragment(dfunc.function.getName(), dfunc.getBody(), dfunc.sourceInfo.filename());
            if (this.importOptions.isOutputSourceLocationInfo()) {
                this.appendPlateComment(dfunc.address, "", dfunc.sourceInfo.getDescriptionStr());
            }
        }
        if (this.importOptions.isOutputDIEInfo()) {
            this.appendPlateComment(dfunc.address, "DWARF DIE: ", dfunc.diea.getHexOffset());
            this.appendPlateComment(dfunc.address, "DWARF signature update mode: ", dfunc.signatureCommitMode.toString());
        }
        if (this.importOptions.isShowVariableStorageInfo()) {
            try {
                DWARFLocation frameLoc;
                DWARFLocationList frameBaseLocs = dfunc.diea.getLocationList(DWARFAttribute.DW_AT_frame_base);
                if (!frameBaseLocs.isEmpty() && (frameLoc = frameBaseLocs.getLocationContaining(dfunc.getEntryPc())) != null) {
                    DWARFCompilationUnit cu = dfunc.diea.getCompilationUnit();
                    DWARFExpression expr = DWARFExpression.read(frameLoc.getExpr(), cu);
                    Varnode frameBaseVal = dfunc.funcEntryFrameBaseLoc != null ? dfunc.funcEntryFrameBaseLoc.getResolvedValue() : null;
                    AddressBasedLocation abl = frameBaseVal != null ? new AddressBasedLocation(this.currentProgram, frameBaseVal.getAddress()) : null;
                    String fbDestStr = abl != null ? abl.toString() : "???";
                    this.appendPlateComment(dfunc.address, "DWARF frame base: ", expr.toString(cu) + "=" + fbDestStr);
                }
            }
            catch (DWARFExpressionException | IOException frameBaseLocs) {
                // empty catch block
            }
        }
        if (dfunc.name.isNameModified()) {
            this.appendPlateComment(dfunc.address, "DWARF original name: ", dfunc.name.getOriginalName());
        }
        FunctionDefinition newFuncDef = dfunc.asFunctionDefinition(true);
        String origFuncDefStr = origFuncDef.getPrototypeString(true);
        if (!newFuncDef.getPrototypeString(true).equals(origFuncDefStr)) {
            this.appendPlateComment(dfunc.address, "DWARF original prototype: ", origFuncDefStr);
        }
        if (dfunc.getBody().getNumAddressRanges() > 1) {
            String mainFuncAnnotate = AddressAnnotatedStringHandler.createAddressAnnotationString(dfunc.address.getOffset(), dfunc.name.getName());
            int rngNum = 0;
            for (AddressRange rng : dfunc.getBody().getAddressRanges()) {
                String rngMinAnnotate = AddressAnnotatedStringHandler.createAddressAnnotationString(rng.getMinAddress().getOffset(), rng.getMinAddress().toString());
                String comment = rngMinAnnotate + " (" + rng.getLength() + " bytes)";
                this.appendPlateComment(dfunc.address, "DWARF func body range[" + rngNum + "]: ", comment);
                if (rngNum != 0) {
                    this.appendPlateComment(rng.getMinAddress(), "DWARF: ", mainFuncAnnotate + " disjoint block " + rngNum);
                }
                ++rngNum;
            }
        }
    }

    private void processFuncChildren(DIEAggregate diea, DWARFFunction dfunc, long offsetFromFuncStart) throws InvalidInputException, IOException, DWARFExpressionException {
        block7: for (DebugInfoEntry childEntry : diea.getHeadFragment().getChildren()) {
            DIEAggregate childDIEA = this.prog.getAggregate(childEntry);
            switch (childDIEA.getTag()) {
                case DW_TAG_variable: {
                    if (offsetFromFuncStart < 0L) break;
                    DWARFVariable localVar = DWARFVariable.readLocalVariable(childDIEA, dfunc, offsetFromFuncStart);
                    if (!localVar.isMissingStorage()) {
                        if (!this.prog.getImportOptions().isImportLocalVariables() && !localVar.isRamStorage()) continue block7;
                        dfunc.localVars.add(localVar);
                        break;
                    }
                    String s = "%s %s@[%s]".formatted(localVar.type.getName(), localVar.name.getName(), localVar.comment != null && !localVar.comment.isEmpty() ? localVar.comment : "???");
                    DWARFUtil.appendComment(this.currentProgram, dfunc.address.add(offsetFromFuncStart), CommentType.PRE, "Unresolved local var: ", s, "\n");
                    break;
                }
                case DW_TAG_lexical_block: {
                    this.processLexicalBlock(childDIEA, dfunc);
                    break;
                }
                case DW_TAG_label: {
                    this.processLabel(childDIEA);
                    break;
                }
                case DW_TAG_inlined_subroutine: {
                    this.processInlinedSubroutine(childDIEA, dfunc);
                    break;
                }
                case DW_TAG_gnu_call_site: 
                case DW_TAG_call_site: {
                    DIEAggregate partDIEA = DIEAggregate.createSkipHead(diea);
                    this.processSubprogram(partDIEA);
                    break;
                }
            }
        }
    }

    private void outputGlobal(DWARFVariable globalVar) {
        DWARFDataInstanceHelper dih;
        if (globalVar == null) {
            return;
        }
        Namespace namespace = globalVar.name.getParentNamespace(this.currentProgram);
        String name = globalVar.name.getName();
        Address address = globalVar.getRamAddress();
        DataType dataType = globalVar.type;
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        Symbol labelSym = null;
        if (!this.currentProgram.getMemory().contains(address)) {
            if (!globalVar.isZeroByte()) {
                Msg.error((Object)this, (Object)"Invalid location for global variable %s:%s @%s".formatted(name, dataType.getName(), address));
            }
            return;
        }
        if (globalVar.isZeroByte() || !this.variablesProcesesed.contains(address)) {
            try {
                labelSym = symbolTable.createLabel(address, name, namespace, SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)"Error creating label for global variable %s/%s at %s".formatted(namespace, name, address));
                return;
            }
        }
        if (globalVar.isZeroByte()) {
            this.appendComment(address, CommentType.PRE, "Zero length variable: %s: %s".formatted(name, dataType.getDisplayName()), "\n");
            return;
        }
        if (this.variablesProcesesed.contains(address)) {
            return;
        }
        labelSym.setPrimary();
        if (globalVar.isExternal) {
            this.setExternalEntryPoint(true, address);
        }
        if (dataType instanceof Dynamic || dataType instanceof FactoryDataType) {
            this.appendComment(address, CommentType.EOL, "Unsupported dynamic data type: " + String.valueOf(dataType), "\n");
            dataType = Undefined.getUndefinedDataType((int)1);
        }
        if (!(dih = new DWARFDataInstanceHelper(this.currentProgram)).isDataTypeCompatibleWithAddress(dataType, address)) {
            this.appendComment(address, CommentType.EOL, "Could not place DWARF static variable %s: %s @%s because existing data type conflicts.".formatted(name, dataType.getName(), address), "\n");
        } else {
            try {
                Data varData = DataUtilities.createData((Program)this.currentProgram, (Address)address, (DataType)dataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
                if (varData != null && globalVar.sourceInfo != null) {
                    AddressSet dataRng = new AddressSet(varData.getMinAddress(), varData.getMaxAddress());
                    this.moveIntoFragment(name, (AddressSetView)dataRng, globalVar.sourceInfo.filename());
                }
                this.variablesProcesesed.add(address);
                ++this.importSummary.globalVarsAdded;
            }
            catch (CodeUnitInsertionException e) {
                Msg.error((Object)this, (Object)"Error creating global variable %s:%s @%s: %s".formatted(name, dataType.getName(), address, e.getMessage()));
            }
        }
        if (globalVar.sourceInfo != null) {
            this.appendComment(address, CommentType.EOL, globalVar.sourceInfo.getDescriptionStr(), "\n");
        }
    }

    private void processLexicalBlock(DIEAggregate diea, DWARFFunction dfunc) throws IOException, InvalidInputException, DWARFExpressionException {
        if (!this.shouldProcess(diea)) {
            return;
        }
        Address blockStart = null;
        DWARFRangeList blockRanges = DWARFFunction.getFuncBodyRanges(diea);
        if (!blockRanges.isEmpty()) {
            blockStart = this.prog.getCodeAddress(blockRanges.getFirst().getFrom());
            if (this.importOptions.isOutputLexicalBlockComments()) {
                boolean disjoint = blockRanges.getListCount() > 1;
                DWARFName dni = this.prog.getName(diea);
                this.appendComment(blockStart, CommentType.PRE, "Begin: %s%s".formatted(dni.getName(), disjoint ? " - Disjoint" : ""), "\n");
            }
        }
        this.processFuncChildren(diea, dfunc, blockStart != null ? blockStart.subtract(dfunc.address) : -1L);
    }

    private void processInlinedSubroutine(DIEAggregate diea, DWARFFunction dfunc) throws IOException, InvalidInputException, DWARFExpressionException {
        if (!this.shouldProcess(diea)) {
            return;
        }
        AddressRange body = DWARFFunction.getFuncBody(diea, true);
        if (body != null) {
            if (this.importOptions.isOutputInlineFuncComments()) {
                this.addCommentsForInlineFunc(diea, body);
            }
            this.processFuncChildren(diea, dfunc, body.getMinAddress().subtract(dfunc.address));
        }
    }

    private void addCommentsForInlineFunc(DIEAggregate diea, AddressRange range) {
        FunctionDefinition funcDef = this.dwarfDTM.getFunctionSignature(diea);
        if (funcDef != null) {
            boolean isShort;
            long inlineFuncLen = range.getLength();
            boolean bl = isShort = inlineFuncLen < 8L;
            if (isShort) {
                this.appendComment(range.getMinAddress(), CommentType.EOL, "inline " + funcDef.getPrototypeString(), "; ");
            } else {
                this.appendComment(range.getMinAddress(), CommentType.PRE, "Begin: inline " + funcDef.getPrototypeString(), "\n");
            }
        }
    }

    private void appendComment(Address address, CommentType commentType, String comment, String sep) {
        DWARFUtil.appendComment(this.currentProgram, address, commentType, "", comment, sep);
    }

    private void appendPlateComment(Address address, String prefix, String comment) {
        DWARFUtil.appendComment(this.currentProgram, address, CommentType.PLATE, prefix, comment, "\n");
    }

    private void setExternalEntryPoint(boolean external, Address address) {
        if (external) {
            this.currentProgram.getSymbolTable().addExternalEntryPoint(address);
        } else {
            this.currentProgram.getSymbolTable().removeExternalEntryPoint(address);
        }
    }

    private void moveIntoFragment(String name, AddressSetView addrs, String fileName) {
        if (fileName != null) {
            ProgramModule module = null;
            int index = this.rootModule.getIndex(fileName);
            if (index == -1) {
                try {
                    module = this.rootModule.createModule(fileName);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)"Error while moving fragment %s (%s)".formatted(name, addrs), (Throwable)e);
                    return;
                }
            } else {
                Group[] children = this.rootModule.getChildren();
                module = (ProgramModule)children[index];
            }
            if (module != null) {
                try {
                    ProgramFragment frag = null;
                    index = module.getIndex(name);
                    if (index == -1) {
                        frag = module.createFragment(name);
                    } else {
                        Group[] children = module.getChildren();
                        frag = (ProgramFragment)children[index];
                    }
                    for (AddressRange rng : addrs.getAddressRanges()) {
                        frag.move(rng.getMinAddress(), rng.getMaxAddress());
                    }
                }
                catch (NotFoundException e) {
                    Msg.error((Object)this, (Object)"Error while moving fragment %s (%s)".formatted(name, addrs), (Throwable)e);
                    return;
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
            }
        }
    }

    private void processLabel(DIEAggregate diea) {
        if (!this.shouldProcess(diea)) {
            return;
        }
        String name = this.prog.getEntryName(diea);
        DWARFRange labelPc = diea.getPCRange();
        if (name != null && !labelPc.isEmpty() && labelPc.getFrom() != 0L) {
            Address address = this.prog.getCodeAddress(labelPc.getFrom());
            try {
                SymbolTable symbolTable = this.currentProgram.getSymbolTable();
                symbolTable.createLabel(address, name, this.currentProgram.getGlobalNamespace(), SourceType.IMPORTED);
                String locationInfo = DWARFSourceInfo.getDescriptionStr(diea);
                if (locationInfo != null) {
                    this.appendComment(address, CommentType.EOL, locationInfo, "; ");
                }
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Problem creating label at " + String.valueOf(address) + " with name " + name), (Throwable)e);
            }
        }
    }
}

