/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import generic.jar.ResourceFile;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.script.GhidraScriptComponentProvider;
import ghidra.app.plugin.core.script.KeyBindingsInfo;
import ghidra.app.script.GhidraScriptInfoManager;
import ghidra.app.script.ScriptInfo;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.DateUtils;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.CaseInsensitiveDuplicateStringComparator;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import resources.Icons;

class GhidraScriptTableModel
extends GDynamicColumnTableModel<ResourceFile, Object> {
    static final String SCRIPT_ACTION_COLUMN_NAME = "In Tool";
    static final String SCRIPT_STATUS_COLUMN_NAME = "Status";
    private static final String EMPTY_STRING = "";
    private static final Icon ERROR_IMG = Icons.ERROR_ICON;
    private GhidraScriptComponentProvider provider;
    private List<ResourceFile> scriptList = new ArrayList<ResourceFile>();
    private final GhidraScriptInfoManager infoManager;

    GhidraScriptTableModel(GhidraScriptComponentProvider provider, GhidraScriptInfoManager infoManager) {
        super((ServiceProvider)provider.getTool());
        this.provider = provider;
        this.infoManager = infoManager;
    }

    protected TableColumnDescriptor<ResourceFile> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ScriptActionColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new StatusColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new NameColumn(this), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new DescriptionColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new KeyBindingColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new PathColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new CategoryColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new CreatedColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ModifiedColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new RuntimeColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ProviderColumn());
        return descriptor;
    }

    public String getName() {
        return "Scripts";
    }

    boolean contains(int row) {
        return row >= 0 && row < this.scriptList.size();
    }

    int getScriptIndex(ResourceFile script) {
        return this.scriptList.indexOf(script);
    }

    List<ResourceFile> getScripts() {
        return new ArrayList<ResourceFile>(this.scriptList);
    }

    ResourceFile getScriptAt(int row) {
        if (row < 0 || row > this.scriptList.size() - 1) {
            return null;
        }
        return this.scriptList.get(row);
    }

    void insertScript(ResourceFile script) {
        if (!this.scriptList.contains(script)) {
            int row = this.scriptList.size();
            this.scriptList.add(script);
            this.fireTableRowsInserted(row, row);
        }
    }

    void insertScripts(List<ResourceFile> scriptFiles) {
        int rowStart = this.scriptList.size();
        for (ResourceFile script : scriptFiles) {
            if (this.scriptList.contains(script)) continue;
            this.scriptList.add(script);
        }
        this.fireTableRowsInserted(rowStart, rowStart + scriptFiles.size() - 1);
    }

    void removeScript(ResourceFile script) {
        int row = this.scriptList.indexOf(script);
        if (row >= 0) {
            this.scriptList.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }

    void switchScript(ResourceFile oldScript, ResourceFile newScript) {
        int index = this.scriptList.indexOf(oldScript);
        if (index != -1) {
            this.scriptList.set(index, newScript);
            this.fireTableRowsUpdated(index, index);
        }
    }

    int getNameColumnIndex() {
        return this.getColumnIndex(NameColumn.class);
    }

    public int getRowCount() {
        if (this.scriptList == null) {
            return 0;
        }
        return this.scriptList.size();
    }

    public boolean isCellEditable(int row, int col) {
        DynamicTableColumn column = this.getColumn(col);
        String columnName = column.getColumnName();
        return SCRIPT_ACTION_COLUMN_NAME.equals(columnName);
    }

    public void setValueAt(Object value, int row, int col) {
        DynamicTableColumn column = this.getColumn(col);
        String columnName = column.getColumnName();
        if (SCRIPT_ACTION_COLUMN_NAME.equals(columnName)) {
            ResourceFile script = this.getScriptAt(row);
            if (((Boolean)value).booleanValue()) {
                this.provider.getActionManager().createAction(script);
            } else {
                this.provider.getActionManager().removeAction(script);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    private String getCategoryString(ScriptInfo info) {
        String[] category = info.getCategory();
        if (category.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder buffy = new StringBuilder();
        for (String string : category) {
            buffy.append(string).append('-').append('>');
        }
        buffy.delete(buffy.length() - 2, buffy.length());
        return buffy.toString();
    }

    public List<ResourceFile> getModelData() {
        return this.scriptList;
    }

    public Object getDataSource() {
        return null;
    }

    public void fireTableChanged(TableModelEvent e) {
        Swing.runIfSwingOrRunLater(() -> super.fireTableChanged(e));
    }

    private class ScriptActionColumn
    extends AbstractDynamicTableColumn<ResourceFile, Boolean, Object> {
        private ScriptActionColumn() {
        }

        public String getColumnDescription() {
            return "When selected, the script has been added as an action to the tool";
        }

        public String getColumnName() {
            return GhidraScriptTableModel.SCRIPT_ACTION_COLUMN_NAME;
        }

        public Boolean getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return GhidraScriptTableModel.this.provider.getActionManager().hasScriptAction(rowObject);
        }
    }

    private class StatusColumn
    extends AbstractDynamicTableColumn<ResourceFile, Icon, Object> {
        private Comparator<Icon> comparator = (i1, i2) -> {
            if (i1 == i2) {
                return 0;
            }
            if (i1 == ERROR_IMG && i2 != ERROR_IMG) {
                return -1;
            }
            if (i1 != ERROR_IMG && i2 == ERROR_IMG) {
                return 1;
            }
            if (i1 == null) {
                return 1;
            }
            if (i2 == null) {
                return -1;
            }
            String d1 = this.getDescription((Icon)i1);
            String d2 = this.getDescription((Icon)i2);
            return SystemUtilities.compareTo((Comparable)((Object)d1), (Comparable)((Object)d2));
        };
        private GColumnRenderer<Icon> renderer = new AbstractGColumnRenderer<Icon>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                ResourceFile file = (ResourceFile)data.getRowObject();
                ScriptInfo info = GhidraScriptTableModel.this.infoManager.getExistingScriptInfo(file);
                label.setText(null);
                label.setToolTipText(null);
                Icon icon = (Icon)data.getValue();
                label.setIcon(null);
                if (icon != null) {
                    label.setIcon(icon);
                    if (info.hasErrors()) {
                        label.setToolTipText("Status: " + info.getErrorMessage());
                    } else {
                        label.setToolTipText("Status: Script has toolbar icon");
                    }
                } else {
                    label.setToolTipText("Status: No script toolbar icon has been set");
                }
                return label;
            }

            public String getFilterString(Icon t, Settings settings) {
                return GhidraScriptTableModel.EMPTY_STRING;
            }
        };

        private StatusColumn() {
        }

        private String getDescription(Icon icon) {
            if (icon instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)icon;
                return imageIcon.getDescription();
            }
            return icon.getClass().getName();
        }

        public GColumnRenderer<Icon> getColumnRenderer() {
            return this.renderer;
        }

        public String getColumnName() {
            return GhidraScriptTableModel.SCRIPT_STATUS_COLUMN_NAME;
        }

        public Icon getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            ScriptInfo info = GhidraScriptTableModel.this.infoManager.getExistingScriptInfo(rowObject);
            if (info.hasErrors()) {
                return ERROR_IMG;
            }
            return info.getToolBarImage(true);
        }

        public Comparator<Icon> getComparator() {
            return this.comparator;
        }
    }

    private class NameColumn
    extends AbstractDynamicTableColumn<ResourceFile, String, Object> {
        private Comparator<String> comparator = new CaseInsensitiveDuplicateStringComparator();

        private NameColumn(GhidraScriptTableModel ghidraScriptTableModel) {
        }

        public Comparator<String> getComparator() {
            return this.comparator;
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getName();
        }

        public int getColumnPreferredWidth() {
            return 250;
        }
    }

    private class DescriptionColumn
    extends AbstractDynamicTableColumn<ResourceFile, String, Object> {
        private DescriptionColumn() {
        }

        public String getColumnName() {
            return "Description";
        }

        public String getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            ScriptInfo info = GhidraScriptTableModel.this.infoManager.getExistingScriptInfo(rowObject);
            return info.getDescription();
        }

        public int getColumnPreferredWidth() {
            return 250;
        }
    }

    private class KeyBindingColumn
    extends AbstractDynamicTableColumn<ResourceFile, KeyBindingsInfo, Object> {
        private GColumnRenderer<KeyBindingsInfo> renderer = new AbstractGColumnRenderer<KeyBindingsInfo>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JComponent component = (JComponent)super.getTableCellRendererComponent(data);
                Object value = data.getValue();
                boolean isSelected = data.isSelected();
                KeyBindingsInfo info = (KeyBindingsInfo)value;
                if (info.errorMessage != null) {
                    component.setForeground((Color)GThemeDefaults.Colors.Tables.ERROR_UNSELECTED);
                    component.setToolTipText(info.errorMessage);
                } else {
                    Object keybindingText = GhidraScriptTableModel.EMPTY_STRING;
                    if (!info.keystroke.isEmpty()) {
                        keybindingText = ": " + info.toString();
                    }
                    if (info.hasAction) {
                        component.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
                        component.setToolTipText("Keybinding for action in tool" + (String)keybindingText);
                    } else {
                        component.setForeground((Color)GThemeDefaults.Colors.FOREGROUND_DISABLED);
                        component.setToolTipText("Keybinding for script" + (String)keybindingText);
                    }
                }
                if (isSelected) {
                    JTable table = data.getTable();
                    Object selectedForegroundColor = info.errorMessage != null ? GThemeDefaults.Colors.Tables.ERROR_SELECTED : table.getSelectionForeground();
                    component.setForeground((Color)selectedForegroundColor);
                }
                return component;
            }

            public String getFilterString(KeyBindingsInfo t, Settings settings) {
                return t.toString();
            }
        };

        private KeyBindingColumn() {
        }

        public GColumnRenderer<KeyBindingsInfo> getColumnRenderer() {
            return this.renderer;
        }

        public String getColumnName() {
            return "Key";
        }

        public KeyBindingsInfo getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            String errorMessage;
            ScriptInfo info = GhidraScriptTableModel.this.infoManager.getExistingScriptInfo(rowObject);
            KeyStroke actionKeyStroke = GhidraScriptTableModel.this.provider.getActionManager().getKeyBinding(rowObject);
            boolean isActionBinding = false;
            KeyStroke keyBinding = info.getKeyBinding();
            if (actionKeyStroke != null) {
                keyBinding = actionKeyStroke;
                isActionBinding = true;
            }
            if ((errorMessage = info.getKeyBindingErrorMessage()) != null) {
                return new KeyBindingsInfo(isActionBinding, keyBinding, errorMessage);
            }
            return new KeyBindingsInfo(isActionBinding, keyBinding);
        }

        public int getColumnPreferredWidth() {
            return 80;
        }
    }

    private class PathColumn
    extends AbstractDynamicTableColumn<ResourceFile, String, Object> {
        private PathColumn(GhidraScriptTableModel ghidraScriptTableModel) {
        }

        public String getColumnName() {
            return "Path";
        }

        public String getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getAbsolutePath();
        }

        public int getColumnPreferredWidth() {
            return 250;
        }
    }

    private class CategoryColumn
    extends AbstractDynamicTableColumn<ResourceFile, String, Object> {
        private Comparator<String> comparator = new CaseInsensitiveDuplicateStringComparator();

        private CategoryColumn() {
        }

        public Comparator<String> getComparator() {
            return this.comparator;
        }

        public String getColumnName() {
            return "Category";
        }

        public String getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            ScriptInfo info = GhidraScriptTableModel.this.infoManager.getExistingScriptInfo(rowObject);
            return GhidraScriptTableModel.this.getCategoryString(info);
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class CreatedColumn
    extends AbstractDynamicTableColumn<ResourceFile, Date, Object> {
        private DateRenderer renderer;

        private CreatedColumn() {
            this.renderer = new DateRenderer();
        }

        public GColumnRenderer<Date> getColumnRenderer() {
            return this.renderer;
        }

        public String getColumnName() {
            return "Created";
        }

        public Date getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return new Date(rowObject.lastModified());
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class ModifiedColumn
    extends AbstractDynamicTableColumn<ResourceFile, Date, Object> {
        private DateRenderer renderer;

        private ModifiedColumn() {
            this.renderer = new DateRenderer();
        }

        public GColumnRenderer<Date> getColumnRenderer() {
            return this.renderer;
        }

        public String getColumnName() {
            return "Modified";
        }

        public Date getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return new Date(rowObject.lastModified());
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class RuntimeColumn
    extends AbstractDynamicTableColumn<ResourceFile, String, Object> {
        private Comparator<String> comparator = new CaseInsensitiveDuplicateStringComparator();

        private RuntimeColumn() {
        }

        public Comparator<String> getComparator() {
            return this.comparator;
        }

        public String getColumnName() {
            return "Runtime";
        }

        public String getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return GhidraScriptTableModel.this.infoManager.getExistingScriptInfo(rowObject).getRuntimeEnvironmentName();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class ProviderColumn
    extends AbstractDynamicTableColumn<ResourceFile, String, Object> {
        private Comparator<String> comparator = new CaseInsensitiveDuplicateStringComparator();

        private ProviderColumn() {
        }

        public Comparator<String> getComparator() {
            return this.comparator;
        }

        public String getColumnName() {
            return "Runtime Provider";
        }

        public String getValue(ResourceFile rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return GhidraScriptTableModel.this.infoManager.getExistingScriptInfo(rowObject).getProvider().getClass().getSimpleName();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class DateRenderer
    extends AbstractGColumnRenderer<Date> {
        private DateRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Date date = (Date)data.getValue();
            String formatted = DateUtils.formatDate((Date)date);
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            renderer.setText(formatted);
            return renderer;
        }

        public GColumnRenderer.ColumnConstraintFilterMode getColumnConstraintFilterMode() {
            return GColumnRenderer.ColumnConstraintFilterMode.ALLOW_ALL_FILTERS;
        }

        public String getFilterString(Date t, Settings settings) {
            String formatted = DateUtils.formatDate((Date)t);
            return formatted;
        }
    }
}

