/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import docking.DialogComponentProvider;
import docking.Tool;
import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.TextFilterStrategy;
import docking.widgets.label.GDLabel;
import docking.widgets.tree.DefaultGTreeFilterProvider;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.ArchiveRootNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class DataTypeChooserDialog
extends DialogComponentProvider {
    private DataTypeManagerPlugin plugin;
    private DataTypeArchiveGTree tree;
    private DataType selectedDataType;
    private CategoryPath selectedCategoryPath;
    private GDLabel messageLabel;
    private boolean isFilterEditable;
    private boolean categorySelectionMode;

    public DataTypeChooserDialog(DataTypeManagerPlugin plugin) {
        super("Data Type Chooser", true, true, true, false);
        this.plugin = plugin;
        this.tree = new DataTypeArchiveGTree(plugin);
        this.tree.setEditable(false);
        this.tree.updateFilterForChoosingDataType();
        this.tree.addGTreeSelectionListener(e -> this.setOkEnabled(this.isValidNodeSelected()));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                if (DataTypeChooserDialog.this.categorySelectionMode) {
                    CategoryPath path = DataTypeChooserDialog.this.getCurrentCategoryPath();
                    if (path == null) {
                        return;
                    }
                    DataTypeChooserDialog.this.selectedCategoryPath = path;
                    DataTypeChooserDialog.this.close();
                    return;
                }
                DataTypeNode selectedNode = DataTypeChooserDialog.this.getSelectedDtNode();
                if (selectedNode == null) {
                    return;
                }
                DataTypeChooserDialog.this.selectedDataType = selectedNode.getDataType();
                DataTypeChooserDialog.this.close();
            }
        });
        this.setPreferredSize(400, 400);
        this.addWorkPanel(this.createWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(false);
        this.setHelpLocation(new HelpLocation("DataTypeEditors", "browse"));
    }

    public void setCategorySelectionMode(boolean categorySelectionMode) {
        this.categorySelectionMode = categorySelectionMode;
        if (categorySelectionMode) {
            this.setTitle("Category Chooser");
            this.messageLabel.setText("Choose a category:");
        } else {
            this.setTitle("Data Type Chooser");
            this.messageLabel.setText("Choose a data type:");
        }
    }

    public void setShowProgramArchiveOnly(boolean programOnly) {
        DataTypeManager programDtm;
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        if (programOnly && (programDtm = handler.getProgramDataTypeManager()) != null) {
            ArchiveRootNode root = new ArchiveRootNode(handler, true);
            this.tree.setRootNode((GTreeNode)root);
            return;
        }
        ArchiveRootNode root = new ArchiveRootNode(handler);
        this.tree.setRootNode((GTreeNode)root);
    }

    private boolean isValidNodeSelected() {
        TreePath[] selectionPath = this.tree.getSelectionPaths();
        if (selectionPath.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPath[0].getLastPathComponent();
        return node instanceof DataTypeTreeNode;
    }

    private DataTypeNode getSelectedDtNode() {
        TreePath[] selectionPath = this.tree.getSelectionPaths();
        if (selectionPath.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPath[0].getLastPathComponent();
        if (node instanceof DataTypeNode) {
            DataTypeNode dtNode = (DataTypeNode)node;
            return dtNode;
        }
        return null;
    }

    private CategoryNode getSelectedCategoryNode() {
        TreePath[] selectionPath = this.tree.getSelectionPaths();
        if (selectionPath.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPath[0].getLastPathComponent();
        if (node instanceof CategoryNode) {
            CategoryNode catNode = (CategoryNode)node;
            return catNode;
        }
        return null;
    }

    public void close() {
        this.tree.dispose();
        super.close();
    }

    private JComponent createWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.messageLabel = new GDLabel("Choose the data type you wish to use.");
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.messageLabel.getAccessibleContext().setAccessibleName("Message");
        panel.add((Component)this.messageLabel, "North");
        panel.add((Component)((Object)this.tree), "Center");
        panel.getAccessibleContext().setAccessibleName("Data Type Chooser");
        return panel;
    }

    protected void okCallback() {
        if (this.categorySelectionMode) {
            this.selectedCategoryPath = this.getCurrentCategoryPath();
        } else {
            DataTypeNode dtNode = this.getSelectedDtNode();
            this.selectedDataType = dtNode.getDataType();
        }
        this.close();
    }

    private CategoryPath getCurrentCategoryPath() {
        DataTypeNode dtNode = this.getSelectedDtNode();
        if (dtNode != null) {
            return dtNode.getDataType().getCategoryPath();
        }
        CategoryNode categoryNode = this.getSelectedCategoryNode();
        if (categoryNode != null) {
            Category category = categoryNode.getCategory();
            return category.getCategoryPath();
        }
        return null;
    }

    public void showPrepopulatedDialog(Tool tool, String dataTypeText) {
        if (this.isShowing()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)dataTypeText)) {
            throw new IllegalArgumentException("Cannot pre-populate the data type chooser dialog with blank filter text");
        }
        this.tree.setFilterText(dataTypeText);
        this.setFilterFieldEditable(false);
        this.installExactMatchFilter();
        this.setFirstNodeSelected();
        tool.showDialog((DialogComponentProvider)this);
    }

    public void setFilterText(String filterText) {
        this.tree.setFilterText(filterText);
    }

    public void setFirstNodeSelected() {
        this.tree.runTask(new SelectFirstNodeTask(this, this.tree));
    }

    public void setSelectedPath(TreePath selectedPath) {
        this.tree.setSelectedNodeByPathName(selectedPath);
    }

    public void setFilterFieldEditable(boolean editable) {
        this.isFilterEditable = editable;
        this.tree.setFilterFieldEnabled(editable);
    }

    public GTreeFilterProvider getTreeFilterProvider() {
        return this.tree.getFilterProvider();
    }

    public void setTreeFilterProvider(GTreeFilterProvider provider) {
        this.tree.setFilterProvider(provider);
    }

    public CategoryPath getSelectedCategoryPath() {
        return this.selectedCategoryPath;
    }

    public DataType getSelectedDataType() {
        return this.selectedDataType;
    }

    public Component getFocusComponent() {
        if (this.isFilterEditable) {
            return this.tree.getFilterField();
        }
        return null;
    }

    private void installExactMatchFilter() {
        GTreeFilterProvider filterProvider = this.tree.getFilterProvider();
        if (filterProvider instanceof DefaultGTreeFilterProvider) {
            DefaultGTreeFilterProvider provider = (DefaultGTreeFilterProvider)filterProvider;
            provider.setPreferredFilterOptions(new FilterOptions(TextFilterStrategy.MATCHES_EXACTLY, false, false, false));
        }
    }

    private class SelectFirstNodeTask
    extends GTreeTask {
        protected SelectFirstNodeTask(DataTypeChooserDialog dataTypeChooserDialog, GTree tree) {
            super(tree);
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            GTreeNode root = this.tree.getViewRoot();
            ArrayList<GTreeNode> dtNodes = new ArrayList<GTreeNode>();
            this.getDataTypeNodes(root, dtNodes);
            if (dtNodes.isEmpty()) {
                return;
            }
            this.tree.setSelectedNode((GTreeNode)dtNodes.get(0));
        }

        private void getDataTypeNodes(GTreeNode node, List<GTreeNode> dtNodes) {
            if (node instanceof DataTypeNode) {
                dtNodes.add(node);
                return;
            }
            List children = node.getChildren();
            for (GTreeNode child : children) {
                this.getDataTypeNodes(child, dtNodes);
            }
        }
    }
}

