/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.RegisterContextBuilder;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Pic12Analyzer
extends AbstractAnalyzer {
    private static final String NAME = "PIC-12C5xx or PIC-16C5x";
    private static final String DESCRIPTION = "Analyzes PIC 12-bit instructions (PIC-12C5xx or PIC-16C5x).";
    private static final int INSTRUCTION_LENGTH = 2;
    private static final long RESET_VECTOR_OFFSET = 0L;
    private static final Character DEST_W = Character.valueOf('w');
    private static final Character DEST_FREG = Character.valueOf('f');
    private static final String CODE_SPACE_NAME = "CODE";
    private static final HashSet<String> WREG_MODIFICATION_MNEMONICS = new HashSet();
    private static final HashSet<String> REG_MODIFICATION_MNEMONICS;
    private static final HashSet<String> FREG_INSTRUCTIONS;
    private static final HashSet<String> FREG_BIT_INSTRUCTIONS;
    private static final HashSet<String> SKIP_INSTRUCTIONS;
    private static final HashSet<String> CALL_BRANCH_INSTRUCTIONS;
    private static final HashMap<String, String[]> FREG_BIT_NAMES_MAP;
    private Program program;
    private Listing listing;
    private EquateTable equateTable;
    private ReferenceManager refMgr;
    private Register status0Reg;
    private Register fsr0Reg;
    private Register pcl0Reg;
    private Register statusReg;
    private Register fsrReg;
    private Register pclReg;
    private Register wReg;
    private Register paStatusReg;
    private RegisterContextBuilder wContext;
    private RegisterContextBuilder paContext;
    private RegisterContextBuilder fsrContext;
    private AddressSet disassemblyPoints;

    public Pic12Analyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.DISASSEMBLY.after().after().after());
    }

    public boolean canAnalyze(Program p) {
        LanguageID languageID = p.getLanguageID();
        return languageID.equals((Object)new LanguageID("PIC-12:LE:16:PIC-12C5xx")) || languageID.equals((Object)new LanguageID("PIC-16:LE:16:PIC-16C5x"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean added(Program p, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        this.program = p;
        this.listing = this.program.getListing();
        this.refMgr = this.program.getReferenceManager();
        this.equateTable = this.program.getEquateTable();
        this.status0Reg = this.program.getRegister("STATUS.0");
        this.fsr0Reg = this.program.getRegister("FSR.0");
        this.pcl0Reg = this.program.getRegister("PCL.0");
        this.statusReg = this.program.getRegister("STATUS");
        this.fsrReg = this.program.getRegister("FSR");
        this.pclReg = this.program.getRegister("PCL");
        this.wReg = this.program.getRegister("W");
        this.paStatusReg = this.program.getRegister("PA");
        this.wContext = new RegisterContextBuilder(this.program, this.wReg, false);
        this.fsrContext = new RegisterContextBuilder(this.program, this.fsrReg, false);
        this.paContext = new RegisterContextBuilder(this.program, this.paStatusReg, 3L);
        this.disassemblyPoints = new AddressSet();
        boolean newBlock = true;
        try {
            Instruction fallThroughInstr = null;
            InstructionIterator instIter = this.listing.getInstructions(set, true);
            while (!monitor.isCancelled() && instIter.hasNext()) {
                String mnemonic;
                FlowType flowType;
                Instruction instr = instIter.next();
                if (fallThroughInstr != null && instr != fallThroughInstr) {
                    Address endAddr = fallThroughInstr.getMinAddress().subtract(1L);
                    this.fsrContext.writeValue(endAddr);
                    this.paContext.writeValue(endAddr);
                    newBlock = true;
                }
                if (newBlock) {
                    this.startNewBlock(instr);
                    newBlock = false;
                }
                if ((flowType = instr.getFlowType()).isCall() || flowType.isJump()) {
                    this.handleCallOrBranch(instr);
                }
                if (!this.handleWRegModification(instr)) {
                    this.checkRegisterAccess(instr);
                }
                if (FREG_INSTRUCTIONS.contains(mnemonic = instr.getMnemonicString())) {
                    this.markupFRegInstruction(instr);
                } else if (FREG_BIT_INSTRUCTIONS.contains(mnemonic)) {
                    this.markupFRegAndBitInstruction(instr);
                }
                fallThroughInstr = this.getFallthrough(instr);
                if (flowType != RefType.UNCONDITIONAL_JUMP && !flowType.isTerminal() && fallThroughInstr != null && set.contains(fallThroughInstr.getMinAddress())) continue;
                Address endAddr = instr.getMaxAddress();
                this.fsrContext.writeValue(endAddr);
                this.paContext.writeValue(endAddr);
                newBlock = true;
            }
            if (!this.disassemblyPoints.isEmpty()) {
                AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)this.program);
                mgr.disassemble((AddressSetView)this.disassemblyPoints);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.program = null;
            this.listing = null;
            this.refMgr = null;
            this.equateTable = null;
            this.status0Reg = null;
            this.fsr0Reg = null;
            this.pcl0Reg = null;
            this.statusReg = null;
            this.fsrReg = null;
            this.pclReg = null;
            this.wReg = null;
            this.paStatusReg = null;
        }
    }

    private void markupFRegAndBitInstruction(Instruction instr) {
        if (instr.getNumOperands() != 2) {
            return;
        }
        String regName = this.markupFRegInstruction(instr);
        if (regName == null) {
            return;
        }
        Object[] objs = instr.getOpObjects(1);
        if (objs.length != 1 || !(objs[0] instanceof Scalar)) {
            return;
        }
        int bit = (int)((Scalar)objs[0]).getUnsignedValue();
        String[] bitNames = FREG_BIT_NAMES_MAP.get(regName);
        if (bitNames == null || bit >= bitNames.length || bitNames[bit] == null) {
            return;
        }
        String bitName = bitNames[bit];
        Equate bitEquate = this.equateTable.getEquate(bitName);
        if (bitEquate == null) {
            try {
                bitEquate = this.equateTable.createEquate(bitName, (long)bit);
            }
            catch (Exception e) {
                return;
            }
        }
        bitEquate.addReference(instr.getMinAddress(), 1);
    }

    private String markupFRegInstruction(Instruction instr) {
        List repObjs;
        Address addr;
        Object[] objs = instr.getOpObjects(0);
        if (objs.length != 1) {
            return null;
        }
        Register reg = null;
        if (objs[0] instanceof Register) {
            reg = (Register)objs[0];
            addr = reg.getAddress();
        } else if (objs[0] instanceof Address) {
            addr = (Address)objs[0];
            reg = this.program.getRegister(addr, 1);
        } else if (objs[0] instanceof Scalar) {
            long offset = ((Scalar)objs[0]).getUnsignedValue();
            if ((offset & 0x1FL) >= 16L) {
                if (!this.fsrContext.hasValue()) {
                    return null;
                }
                offset = (this.fsrContext.longValue() & 0x60L) + offset;
            }
            addr = this.program.getAddressFactory().getAddressSpace("DATA").getAddress(offset);
            reg = this.program.getRegister(addr);
        } else {
            return null;
        }
        String mnemonic = instr.getMnemonicString();
        RefType refType = RefType.READ;
        if ("CLRF".equals(mnemonic) || "MOVWF".equals(mnemonic)) {
            refType = RefType.WRITE;
        } else if (FREG_BIT_INSTRUCTIONS.contains(mnemonic)) {
            if ("BCF".equals(mnemonic) || "BSF".equals(mnemonic)) {
                refType = RefType.READ_WRITE;
            }
        } else if (instr.getNumOperands() == 2 && (repObjs = instr.getDefaultOperandRepresentationList(1)).size() == 1 && DEST_FREG.equals(repObjs.get(0))) {
            refType = RefType.READ_WRITE;
        }
        if (this.statusReg.equals((Object)reg)) {
            addr = this.status0Reg.getAddress();
        } else if (this.fsrReg.equals((Object)reg)) {
            addr = this.fsr0Reg.getAddress();
        } else if (this.pclReg.equals((Object)reg)) {
            addr = this.pcl0Reg.getAddress();
        }
        if (addr.isMemoryAddress()) {
            this.refMgr.addMemoryReference(instr.getMinAddress(), addr, refType, SourceType.DEFAULT, 0);
        }
        return reg != null ? reg.getName() : null;
    }

    private boolean isCodeAddress(Address addr) {
        return CODE_SPACE_NAME.equals(addr.getAddressSpace().getName());
    }

    private void startNewBlock(Instruction instr) {
        Reference ref;
        Address instrAddr = instr.getMinAddress();
        long instrOffset = instrAddr.getOffset();
        if (instrOffset == 0L) {
            this.fsrContext.setValueAt(instr, 96L, true);
            this.paContext.setValueAt(instr, 0L, true);
            this.wContext.setValueUnknown();
            return;
        }
        this.fsrContext.setValueAt(instr, instrAddr, true);
        this.paContext.setValueAt(instr, instrAddr, true);
        this.wContext.setValueAt(instr, instrAddr, true);
        Instruction fallFromInstr = this.getFallFrom(instr);
        if (fallFromInstr != null) {
            Address fallFrom = fallFromInstr.getMinAddress();
            this.fsrContext.setValueAt(instr, fallFrom, false);
            this.paContext.setValueAt(instr, fallFrom, false);
            this.wContext.setValueAt(instr, fallFrom, false);
        } else {
            Address skipFromAddr;
            if (instrOffset >= 4L && (ref = this.refMgr.getReference(skipFromAddr = instrAddr.subtract(4L), instrAddr, -1)) != null && ref.getReferenceType() == RefType.CONDITIONAL_JUMP) {
                this.paContext.setValueAt(instr, skipFromAddr, false);
                this.fsrContext.setValueAt(instr, skipFromAddr, false);
                this.wContext.setValueAt(instr, skipFromAddr, false);
            }
            if (!this.paContext.hasValue()) {
                this.paContext.setValueAt(instr, instrOffset / 2L >> 9, true);
            }
        }
        ReferenceIterator refIter = this.refMgr.getReferencesTo(instrAddr);
        while (!(this.fsrContext.hasValue() && this.wContext.hasValue() || !refIter.hasNext())) {
            ref = refIter.next();
            Address fromAddr = ref.getFromAddress();
            if (!this.isCodeAddress(fromAddr)) continue;
            this.fsrContext.setValueAt(instr, fromAddr, false);
            this.wContext.setValueAt(instr, fromAddr, false);
        }
        if (!this.fsrContext.hasValue()) {
            Msg.warn((Object)((Object)this), (Object)("Initial FSR unknown at: " + String.valueOf(instrAddr)));
        }
    }

    private void handleCallOrBranch(Instruction instr) {
        String mnemonic = instr.getMnemonicString();
        if (CALL_BRANCH_INSTRUCTIONS.contains(mnemonic)) {
            Object[] objs;
            if (this.paContext.hasValue() && (objs = instr.getOpObjects(0)).length == 1 && objs[0] instanceof Scalar) {
                Scalar s = (Scalar)objs[0];
                long offset = ((this.paContext.longValue() << 9) + s.getUnsignedValue()) * 2L;
                Address destAddr = instr.getMinAddress().getNewAddress(offset);
                FlowType flowType = instr.getFlowType().isCall() ? RefType.UNCONDITIONAL_CALL : RefType.UNCONDITIONAL_JUMP;
                this.refMgr.addMemoryReference(instr.getMinAddress(), destAddr, (RefType)flowType, SourceType.DEFAULT, 0);
                this.disassembleAt(destAddr);
            }
        } else if (SKIP_INSTRUCTIONS.contains(mnemonic)) {
            Address skipAddr = instr.getMinAddress().add(4L);
            this.refMgr.addMemoryReference(instr.getMinAddress(), skipAddr, (RefType)RefType.CONDITIONAL_JUMP, SourceType.DEFAULT, -1);
            this.disassembleAt(skipAddr);
        }
    }

    private void disassembleAt(Address addr) {
        if (this.listing.getInstructionAt(addr) == null) {
            this.disassemblyPoints.addRange(addr, addr);
        }
    }

    private boolean handleWRegModification(Instruction instr) {
        String mnemonic = instr.getMnemonicString();
        boolean modUnknown = false;
        if ("CLRW".equals(mnemonic)) {
            this.wContext.setValueAt(instr, 0L, false);
            return true;
        }
        if ("MOVF".equals(mnemonic)) {
            modUnknown = true;
        } else if ("MOVLW".equals(mnemonic)) {
            Scalar s = instr.getScalar(0);
            if (s != null) {
                this.wContext.setValueAt(instr, s.getUnsignedValue(), false);
                return true;
            }
            modUnknown = true;
        } else if (REG_MODIFICATION_MNEMONICS.contains(mnemonic) && instr.getNumOperands() == 2) {
            List repObjs = instr.getDefaultOperandRepresentationList(1);
            if (repObjs.size() == 1 && DEST_W.equals(repObjs.get(0))) {
                this.wContext.setValueUnknown();
                return true;
            }
        } else if (WREG_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            modUnknown = true;
        }
        if (modUnknown) {
            this.wContext.setValueUnknown();
            return true;
        }
        return false;
    }

    private void checkRegisterAccess(Instruction instr) {
        if (instr.getNumOperands() == 0) {
            return;
        }
        Object[] objs = instr.getOpObjects(0);
        if (objs.length == 0) {
            return;
        }
        if (this.statusReg.equals(objs[0]) || this.statusReg.getAddress().equals(objs[0])) {
            this.handleStatusModification(instr);
        } else if (this.fsrReg.equals(objs[0]) || this.fsrReg.getAddress().equals(objs[0])) {
            this.handleFSRModification(instr);
        }
    }

    private void handleStatusModification(Instruction instr) {
        this.paContext.writeValue(instr.getMaxAddress());
        String mnemonic = instr.getMnemonicString();
        if ("CLRF".equals(mnemonic)) {
            this.paContext.setValueAt(instr, 0L, false);
        } else if ("BSF".equals(mnemonic)) {
            Scalar s = instr.getScalar(1);
            boolean success = false;
            if (s != null) {
                int bit = (int)s.getUnsignedValue();
                success = bit == 5 || bit == 6 ? this.paContext.setBitAt(instr, bit - 5) : true;
            }
            if (!success) {
                Msg.warn((Object)((Object)this), (Object)("Unhandled STATUS bit-set at: " + String.valueOf(instr.getMinAddress())));
            }
        } else if ("BCF".equals(mnemonic)) {
            Scalar s = instr.getScalar(1);
            boolean success = false;
            if (s != null) {
                int bit = (int)s.getUnsignedValue();
                success = bit == 5 || bit == 6 ? this.paContext.clearBitAt(instr, bit - 5) : true;
            }
            if (!success) {
                Msg.warn((Object)((Object)this), (Object)("Unhandled STATUS bit-set at: " + String.valueOf(instr.getMinAddress())));
            }
        } else if ("MOVWF".equals(mnemonic)) {
            if (this.wContext.hasValue()) {
                this.paContext.setValueAt(instr, this.wContext.longValue() >> 5, false);
            } else {
                this.paContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled STATUS change at: " + String.valueOf(instr.getMinAddress())));
            }
        } else if (REG_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            if (instr.getNumOperands() == 2) {
                List repObjs = instr.getDefaultOperandRepresentationList(1);
                if (repObjs.size() == 1 && DEST_FREG.equals(repObjs.get(0))) {
                    this.paContext.setValueUnknown();
                    Msg.warn((Object)((Object)this), (Object)("Unhandled STATUS change at: " + String.valueOf(instr.getMinAddress())));
                }
            } else if (instr.getNumOperands() == 1) {
                this.paContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled STATUS change at: " + String.valueOf(instr.getMinAddress())));
            }
        }
    }

    private void handleFSRModification(Instruction instr) {
        this.fsrContext.writeValue(instr.getMaxAddress());
        String mnemonic = instr.getMnemonicString();
        if ("CLRF".equals(mnemonic)) {
            this.fsrContext.setValueAt(instr, 0L, false);
        } else if ("BSF".equals(mnemonic)) {
            if (!this.fsrContext.setBitAt(instr, instr.getScalar(1), 0)) {
                this.fsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled FSR bit-set at: " + String.valueOf(instr.getMinAddress())));
            }
        } else if ("BCF".equals(mnemonic)) {
            if (!this.fsrContext.clearBitAt(instr, instr.getScalar(1), 0)) {
                this.fsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled FSR bit-set at: " + String.valueOf(instr.getMinAddress())));
            }
        } else if ("INCF".equals(mnemonic)) {
            if (this.fsrContext.hasValue()) {
                this.fsrContext.setValueAt(instr, this.fsrContext.longValue() + 1L, false);
            } else {
                this.fsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled FSR change at: " + String.valueOf(instr.getMinAddress())));
            }
        } else if ("DECF".equals(mnemonic)) {
            if (this.fsrContext.hasValue()) {
                this.fsrContext.setValueAt(instr, this.fsrContext.longValue() - 1L, false);
            } else {
                this.fsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled FSR change at: " + String.valueOf(instr.getMinAddress())));
            }
        } else if ("MOVWF".equals(mnemonic)) {
            if (this.wContext.hasValue()) {
                this.fsrContext.setValueAt(instr, this.wContext.longValue(), false);
            } else {
                this.fsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled FSR change at: " + String.valueOf(instr.getMinAddress())));
            }
        } else if (REG_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            if (instr.getNumOperands() == 2) {
                List repObjs = instr.getDefaultOperandRepresentationList(1);
                if (repObjs.size() == 1 && DEST_FREG.equals(repObjs.get(0)) && !"INCF".equals(mnemonic)) {
                    this.fsrContext.setValueUnknown();
                    Msg.warn((Object)((Object)this), (Object)("Unhandled FSR change at: " + String.valueOf(instr.getMinAddress())));
                }
            } else if (instr.getNumOperands() == 1) {
                this.fsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled FSR change at: " + String.valueOf(instr.getMinAddress())));
            }
        }
    }

    private Instruction getFallthrough(Instruction instr) {
        Instruction nextInstr;
        if (instr != null && (nextInstr = instr.getNext()) != null && nextInstr.getMinAddress().equals((Object)instr.getFallThrough())) {
            return nextInstr;
        }
        return null;
    }

    private Instruction getFallFrom(Instruction instr) {
        Address fallFromAddr;
        if (instr != null && (fallFromAddr = instr.getFallFrom()) != null) {
            return this.listing.getInstructionAt(fallFromAddr);
        }
        return null;
    }

    static {
        WREG_MODIFICATION_MNEMONICS.add("ANDLW");
        WREG_MODIFICATION_MNEMONICS.add("IORLW");
        WREG_MODIFICATION_MNEMONICS.add("XORLW");
        REG_MODIFICATION_MNEMONICS = new HashSet();
        REG_MODIFICATION_MNEMONICS.add("ADDWF");
        REG_MODIFICATION_MNEMONICS.add("ANDWF");
        REG_MODIFICATION_MNEMONICS.add("COMF");
        REG_MODIFICATION_MNEMONICS.add("DECF");
        REG_MODIFICATION_MNEMONICS.add("DECFSZ");
        REG_MODIFICATION_MNEMONICS.add("INCF");
        REG_MODIFICATION_MNEMONICS.add("INCFSZ");
        REG_MODIFICATION_MNEMONICS.add("IORWF");
        REG_MODIFICATION_MNEMONICS.add("MOVWF");
        REG_MODIFICATION_MNEMONICS.add("RLF");
        REG_MODIFICATION_MNEMONICS.add("RRF");
        REG_MODIFICATION_MNEMONICS.add("SUBWF");
        REG_MODIFICATION_MNEMONICS.add("SWAPF");
        REG_MODIFICATION_MNEMONICS.add("XORWF");
        FREG_INSTRUCTIONS = new HashSet();
        FREG_INSTRUCTIONS.add("ADDWF");
        FREG_INSTRUCTIONS.add("ANDWF");
        FREG_INSTRUCTIONS.add("CLRF");
        FREG_INSTRUCTIONS.add("COMF");
        FREG_INSTRUCTIONS.add("DECF");
        FREG_INSTRUCTIONS.add("DECFSZ");
        FREG_INSTRUCTIONS.add("INCF");
        FREG_INSTRUCTIONS.add("INCFSZ");
        FREG_INSTRUCTIONS.add("IORWF");
        FREG_INSTRUCTIONS.add("MOVF");
        FREG_INSTRUCTIONS.add("MOVWF");
        FREG_INSTRUCTIONS.add("RLF");
        FREG_INSTRUCTIONS.add("RRF");
        FREG_INSTRUCTIONS.add("SUBWF");
        FREG_INSTRUCTIONS.add("SWAPF");
        FREG_INSTRUCTIONS.add("XORWF");
        FREG_BIT_INSTRUCTIONS = new HashSet();
        FREG_BIT_INSTRUCTIONS.add("BCF");
        FREG_BIT_INSTRUCTIONS.add("BSF");
        FREG_BIT_INSTRUCTIONS.add("BTFSC");
        FREG_BIT_INSTRUCTIONS.add("BTFSS");
        SKIP_INSTRUCTIONS = new HashSet();
        SKIP_INSTRUCTIONS.add("DECFSZ");
        SKIP_INSTRUCTIONS.add("INCFSZ");
        SKIP_INSTRUCTIONS.add("BTFSC");
        SKIP_INSTRUCTIONS.add("BTFSS");
        CALL_BRANCH_INSTRUCTIONS = new HashSet();
        CALL_BRANCH_INSTRUCTIONS.add("CALL");
        CALL_BRANCH_INSTRUCTIONS.add("GOTO");
        FREG_BIT_NAMES_MAP = new HashMap();
        FREG_BIT_NAMES_MAP.put("STATUS", new String[]{"C", "DC", "Z", "!PD", "!TO", "PA0", "PA1", "GPWUF"});
        FREG_BIT_NAMES_MAP.put("GPIO", new String[]{"GP0", "GP1", "GP2", "GP3", "GP4", "GP5", "SDA", "SCL"});
    }
}

