/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.analyzers;

import ghidra.util.Msg;
import java.lang.reflect.Field;

public final class MethodHandleBytecodeBehaviors {
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;

    public static final String getName(int kind) {
        Field[] fields;
        for (Field field : fields = MethodHandleBytecodeBehaviors.class.getDeclaredFields()) {
            if (!field.getName().startsWith("REF_")) continue;
            try {
                Integer value = (Integer)field.get(null);
                if (value != kind) continue;
                return field.getName();
            }
            catch (Exception e) {
                Msg.error(MethodHandleBytecodeBehaviors.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }
        return "Unrecognized kind: 0x" + Integer.toHexString(kind);
    }
}

