/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.type;

import ghidra.pcode.emu.jit.gen.FieldForArrDirect;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.type.MethodAccessGen;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;
import org.objectweb.asm.MethodVisitor;

public enum LongReadGen implements MethodAccessGen
{
    BE{

        @Override
        public String chooseName(int size) {
            return switch (size) {
                case 1 -> "readLong1";
                case 2 -> "readLongBE2";
                case 3 -> "readLongBE3";
                case 4 -> "readLongBE4";
                case 5 -> "readLongBE5";
                case 6 -> "readLongBE6";
                case 7 -> "readLongBE7";
                case 8 -> "readLongBE8";
                default -> throw new AssertionError();
            };
        }

        @Override
        public void generateCode(JitCodeGenerator gen, Varnode vn, MethodVisitor rv) {
            long offset = vn.getOffset();
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int size = vn.getSize();
            AddressSpace space = vn.getAddress().getAddressSpace();
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                blkField.generateLoadCode(gen, rv);
                rv.visitLdcInsn((Object)off);
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true);
                return;
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            blkField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)off);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true);
            rv.visitLdcInsn((Object)(off + size - 4096));
            rv.visitInsn(121);
            nxtField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)0);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true);
            rv.visitInsn(129);
        }
    }
    ,
    LE{

        @Override
        public String chooseName(int size) {
            return switch (size) {
                case 1 -> "readLong1";
                case 2 -> "readLongLE2";
                case 3 -> "readLongLE3";
                case 4 -> "readLongLE4";
                case 5 -> "readLongLE5";
                case 6 -> "readLongLE6";
                case 7 -> "readLongLE7";
                case 8 -> "readLongLE8";
                default -> throw new AssertionError();
            };
        }

        @Override
        public void generateCode(JitCodeGenerator gen, Varnode vn, MethodVisitor rv) {
            long offset = vn.getOffset();
            long block = offset / 4096L * 4096L;
            int off = (int)(offset - block);
            int size = vn.getSize();
            AddressSpace space = vn.getAddress().getAddressSpace();
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                blkField.generateLoadCode(gen, rv);
                rv.visitLdcInsn((Object)off);
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true);
                return;
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            nxtField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)0);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true);
            rv.visitLdcInsn((Object)(4096 - off));
            rv.visitInsn(121);
            blkField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)off);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__READ_LONGX, true);
            rv.visitInsn(129);
        }
    };

}

