/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.GlobalSymbol;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class GlobalNamespace
implements Namespace {
    public static final String GLOBAL_NAMESPACE_NAME = "Global";
    final Memory memory;
    final Symbol globalSymbol;

    public GlobalNamespace(Memory memory) {
        this.memory = memory;
        this.globalSymbol = new GlobalSymbol(this);
    }

    @Override
    public Symbol getSymbol() {
        return this.globalSymbol;
    }

    @Override
    public String getName() {
        return GLOBAL_NAMESPACE_NAME;
    }

    @Override
    public long getID() {
        return 0L;
    }

    @Override
    public Namespace getParentNamespace() {
        return null;
    }

    @Override
    public AddressSetView getBody() {
        return new AddressSet(this.memory);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public String getName(boolean includeNamespacePath) {
        return this.getName();
    }

    @Override
    public void setParentNamespace(Namespace parentNamespace) throws DuplicateNameException, InvalidInputException {
        throw new InvalidInputException("Can't parent this namespace");
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

