/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.util.Lock;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class LazyLoadingCachingMap<K, V> {
    private Lock lock;
    private SoftReference<Map<K, V>> softRef;

    protected LazyLoadingCachingMap(Lock lock) {
        this.lock = lock;
    }

    protected abstract Map<K, V> loadMap();

    public synchronized void put(K key, V value) {
        Map<K, V> map = this.getMap();
        if (map != null) {
            map.put(key, value);
        }
    }

    public synchronized void remove(K key) {
        Map<K, V> map = this.getMap();
        if (map != null) {
            map.remove(key);
        }
    }

    public synchronized void clear() {
        this.softRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Map<K, V> map = this.getOrLoadMap();
        LazyLoadingCachingMap lazyLoadingCachingMap = this;
        synchronized (lazyLoadingCachingMap) {
            return map.get(key);
        }
    }

    public Collection<V> values() {
        Map<K, V> map = this.getOrLoadMap();
        return Collections.unmodifiableCollection(map.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getOrLoadMap() {
        Map<K, V> map;
        Object object = this;
        synchronized (object) {
            map = this.getMap();
            if (map != null) {
                return map;
            }
        }
        this.lock.acquire();
        try {
            map = this.getMap();
            if (map == null) {
                map = this.loadMap();
                this.softRef = new SoftReference<Map<K, V>>(map);
            }
            object = map;
            return object;
        }
        finally {
            this.lock.release();
        }
    }

    protected Map<K, V> getMap() {
        if (this.softRef == null) {
            return null;
        }
        return this.softRef.get();
    }
}

