/*
 * Decompiled with CFR 0.152.
 */
package resources;

import generic.theme.CloseIcon;
import generic.theme.GIcon;
import ghidra.util.Msg;
import java.lang.reflect.Field;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.IconProvider;
import resources.ResourceManager;

public class Icons {
    public static final Icon EMPTY_ICON = new GIcon("icon.empty");
    public static final Icon HELP_ICON = new GIcon("icon.help");
    public static final Icon ADD_ICON = new GIcon("icon.add");
    public static final Icon COPY_ICON = new GIcon("icon.copy");
    public static final Icon CUT_ICON = new GIcon("icon.cut");
    public static final Icon PASTE_ICON = new GIcon("icon.paste");
    public static final Icon COLLAPSE_ALL_ICON = new GIcon("icon.collapse.all");
    public static final Icon EXPAND_ALL_ICON = new GIcon("icon.expand.all");
    public static final Icon CONFIGURE_FILTER_ICON = new GIcon("icon.configure.filter");
    public static final Icon CLEAR_ICON = new GIcon("icon.clear");
    public static final Icon DELETE_ICON = new GIcon("icon.delete");
    public static final Icon ERROR_ICON = new GIcon("icon.error");
    public static final Icon HOME_ICON = new GIcon("icon.home");
    public static final Icon NAVIGATE_ON_INCOMING_EVENT_ICON = new GIcon("icon.navigate.in");
    public static final Icon NAVIGATE_ON_OUTGOING_EVENT_ICON = new GIcon("icon.navigate.out");
    public static final Icon NOT_ALLOWED_ICON = new GIcon("icon.not.allowed");
    public static final Icon OPEN_FOLDER_ICON = new GIcon("icon.folder.open");
    public static final Icon CLOSED_FOLDER_ICON = new GIcon("icon.folder.closed");
    public static final Icon REFRESH_ICON = new GIcon("icon.refresh");
    public static final Icon SORT_ASCENDING_ICON = new GIcon("icon.sort.ascending");
    public static final Icon SORT_DESCENDING_ICON = new GIcon("icon.sort.descending");
    public static final Icon STOP_ICON = new GIcon("icon.stop");
    public static final Icon STRONG_WARNING_ICON = new GIcon("icon.warning.strong");
    public static final Icon WARNING_ICON = new GIcon("icon.warning");
    public static final Icon INFO_ICON = new GIcon("icon.information");
    public static final Icon LEFT_ICON = new GIcon("icon.left");
    public static final Icon RIGHT_ICON = new GIcon("icon.right");
    public static final Icon UP_ICON = new GIcon("icon.up");
    public static final Icon DOWN_ICON = new GIcon("icon.down");
    public static final Icon LEFT_ALTERNATE_ICON = new GIcon("icon.left.alt");
    public static final Icon RIGHT_ALTERNATE_ICON = new GIcon("icon.right.alt");
    public static final Icon SAVE_ICON = new GIcon("icon.save");
    public static final Icon SAVE_AS_ICON = new GIcon("icon.save.as");
    public static final Icon MAKE_SELECTION_ICON = new GIcon("icon.make.selection");
    public static final Icon ARROW_DOWN_RIGHT_ICON = new GIcon("icon.arrow.down.right");
    public static final Icon ARROW_UP_LEFT_ICON = new GIcon("icon.arrow.up.left");
    public static final Icon CLOSE_ICON = new CloseIcon(false);

    public static boolean isIconsReference(String snippet) {
        return snippet.startsWith(Icons.class.getSimpleName());
    }

    public static IconProvider getIconForIconsReference(String snippet) {
        String fieldName = Icons.getIconName(snippet);
        if (fieldName == null) {
            return null;
        }
        Icon icon = Icons.getIconByFieldName(fieldName);
        if (icon == null) {
            return null;
        }
        URL url = Icons.getUrlFromIcon(icon);
        return new IconProvider(icon, url);
    }

    public static ImageIcon get(String iconPath) {
        return ResourceManager.loadImage(iconPath);
    }

    public static ImageIcon get(String iconPath, int width, int height) {
        return ResourceManager.loadImage(iconPath, width, height);
    }

    private static String getIconName(String snippet) {
        if (!Icons.isIconsReference(snippet)) {
            return null;
        }
        String fieldName = snippet.substring(Icons.class.getSimpleName().length() + 1);
        return fieldName;
    }

    private static Icon getIconByFieldName(String fieldName) {
        try {
            Field field = Icons.class.getField(fieldName);
            Object object = field.get(Icons.class);
            Icon icon = (Icon)object;
            return icon;
        }
        catch (Exception e) {
            Msg.debug(Icons.class, (Object)("No icon named '" + fieldName + "' in class " + Icons.class.getName()));
            return null;
        }
    }

    private static URL getUrlFromIcon(Icon icon) {
        GIcon gIcon;
        URL url;
        if (icon instanceof GIcon && (url = (gIcon = (GIcon)icon).getUrl()) != null) {
            return url;
        }
        return null;
    }

    private Icons() {
    }
}

