/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.quickconnect;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.quickconnect.QuickConnectDirectory;
import org.apache.guacamole.auth.quickconnect.QuickConnectionGroup;
import org.apache.guacamole.auth.quickconnect.rest.QuickConnectREST;
import org.apache.guacamole.net.auth.AbstractUserContext;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleObjectPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleUser;

public class QuickConnectUserContext
extends AbstractUserContext {
    public static final String ROOT_IDENTIFIER = "ROOT";
    @Inject
    private AuthenticationProvider authProvider;
    private User self;
    @Inject
    private QuickConnectDirectory connectionDirectory;
    private ConnectionGroup rootGroup;

    public void init(String username) throws GuacamoleException {
        this.rootGroup = new QuickConnectionGroup(ROOT_IDENTIFIER, ROOT_IDENTIFIER);
        this.connectionDirectory.init(this.rootGroup);
        this.self = new SimpleUser(username){

            public ObjectPermissionSet getConnectionPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet((Collection)QuickConnectUserContext.this.connectionDirectory.getIdentifiers());
            }

            public ObjectPermissionSet getConnectionGroupPermissions() throws GuacamoleException {
                return new SimpleObjectPermissionSet(Collections.singleton(QuickConnectUserContext.ROOT_IDENTIFIER));
            }
        };
    }

    public QuickConnectDirectory getConnectionDirectory() {
        return this.connectionDirectory;
    }

    public User self() {
        return this.self;
    }

    public Object getResource() throws GuacamoleException {
        return new QuickConnectREST(this.connectionDirectory);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authProvider;
    }

    public ConnectionGroup getRootConnectionGroup() throws GuacamoleException {
        return this.rootGroup;
    }
}

