// Generated by gmmproc 2.50.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MESSAGE_H
#define _GSTREAMERMM_MESSAGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/format.h>
#include <gstreamermm/clock.h>
#include <gstreamermm/query.h>
#include <gstreamermm/context.h>
#include <gstreamermm/toc.h>


namespace Gst
{

  template<typename T>
  Glib::RefPtr<T> wrap_msg_derived(GstMessage* object, bool take_copy)
  {
    if(take_copy && object)
      gst_message_ref(object);

    // See the comment at the top of this file, if you want to know why the cast works.
    return Glib::RefPtr<T>(reinterpret_cast<T*>(object));
  }

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var MessageType MESSAGE_UNKNOWN
 * An undefined message.
 * 
 *  @var MessageType MESSAGE_EOS
 * End-of-stream reached in a pipeline. The application will
 * only receive this message in the PLAYING state and every time it sets a
 * pipeline to PLAYING that is in the EOS state. The application can perform a
 * flushing seek in the pipeline, which will undo the EOS state again.
 * 
 *  @var MessageType MESSAGE_ERROR
 * An error occurred. When the application receives an error
 * message it should stop playback of the pipeline and not assume that more
 * data will be played.
 * 
 *  @var MessageType MESSAGE_WARNING
 * A warning occurred.
 * 
 *  @var MessageType MESSAGE_INFO
 * An info message occurred.
 * 
 *  @var MessageType MESSAGE_TAG
 * A tag was found.
 * 
 *  @var MessageType MESSAGE_BUFFERING
 * The pipeline is buffering. When the application
 * receives a buffering message in the PLAYING state for a non-live pipeline it
 * must PAUSE the pipeline until the buffering completes, when the percentage
 * field in the message is 100%. For live pipelines, no action must be
 * performed and the buffering percentage can be used to inform the user about
 * the progress.
 * 
 *  @var MessageType MESSAGE_STATE_CHANGED
 * A state change happened.
 * 
 *  @var MessageType MESSAGE_STATE_DIRTY
 * An element changed state in a streaming thread.
 * This message is deprecated.
 * 
 *  @var MessageType MESSAGE_STEP_DONE
 * A stepping operation finished.
 * 
 *  @var MessageType MESSAGE_CLOCK_PROVIDE
 * An element notifies its capability of providing
 * a clock. This message is used internally and
 * never forwarded to the application.
 * 
 *  @var MessageType MESSAGE_CLOCK_LOST
 * The current clock as selected by the pipeline became
 * unusable. The pipeline will select a new clock on
 * the next PLAYING state change. The application
 * should set the pipeline to PAUSED and back to
 * PLAYING when this message is received.
 * 
 *  @var MessageType MESSAGE_NEW_CLOCK
 * A new clock was selected in the pipeline.
 * 
 *  @var MessageType MESSAGE_STRUCTURE_CHANGE
 * The structure of the pipeline changed. This
 * message is used internally and never forwarded to the application.
 * 
 *  @var MessageType MESSAGE_STREAM_STATUS
 * Status about a stream, emitted when it starts,
 * stops, errors, etc..
 * 
 *  @var MessageType MESSAGE_APPLICATION
 * Message posted by the application, possibly
 * via an application-specific element.
 * 
 *  @var MessageType MESSAGE_ELEMENT
 * Element-specific message, see the specific element's
 * documentation.
 * 
 *  @var MessageType MESSAGE_SEGMENT_START
 * Pipeline started playback of a segment. This
 * message is used internally and never forwarded to the application.
 * 
 *  @var MessageType MESSAGE_SEGMENT_DONE
 * Pipeline completed playback of a segment. This
 * message is forwarded to the application after all elements that posted
 *  @a GST_MESSAGE_SEGMENT_START posted a GST_MESSAGE_SEGMENT_DONE message.
 * 
 *  @var MessageType MESSAGE_DURATION_CHANGED
 * The duration of a pipeline changed. The
 * application can get the new duration with a duration query.
 * 
 *  @var MessageType MESSAGE_ASYNC_START
 * Posted by elements when they start an ASYNC
 * Gst::StateChange. This message is not forwarded to the application but is used
 * internally.
 * 
 *  @var MessageType MESSAGE_ASYNC_DONE
 * Posted by elements when they complete an ASYNC
 * Gst::StateChange. The application will only receive this message from the toplevel
 * pipeline.
 * 
 *  @var MessageType MESSAGE_LATENCY
 * Posted by elements when their latency changes. The
 * application should recalculate and distribute a new latency.
 * 
 *  @var MessageType MESSAGE_REQUEST_STATE
 * Posted by elements when they want the pipeline to
 * change state. This message is a suggestion to the application which can
 * decide to perform the state change on (part of) the pipeline.
 * 
 *  @var MessageType MESSAGE_STEP_START
 * A stepping operation was started.
 * 
 *  @var MessageType MESSAGE_QOS
 * A buffer was dropped or an element changed its processing
 * strategy for Quality of Service reasons.
 * 
 *  @var MessageType MESSAGE_PROGRESS
 * A progress message.
 * 
 *  @var MessageType MESSAGE_TOC
 * A new table of contents (TOC) was found or previously found TOC
 * was updated.
 * 
 *  @var MessageType MESSAGE_RESET_TIME
 * Message to request resetting the pipeline's
 * running time from the pipeline. This is an internal message which
 * applications will likely never receive.
 * 
 *  @var MessageType MESSAGE_STREAM_START
 * Message indicating start of a new stream. Useful
 * e.g. when using playbin in gapless playback mode, to get notified when
 * the next title actually starts playing (which will be some time after
 * the URI for the next title has been set).
 * 
 *  @var MessageType MESSAGE_NEED_CONTEXT
 * Message indicating that an element wants a specific context (Since 1.2).
 * 
 *  @var MessageType MESSAGE_HAVE_CONTEXT
 * Message indicating that an element created a context (Since 1.2).
 * 
 *  @var MessageType MESSAGE_EXTENDED
 * Message is an extended message type (see below).
 * These extended message IDs can't be used directly with mask-based API
 * like Gst::Bus::poll() or Gst::Bus::timed_pop_filtered(), but you can still
 * filter for GST_MESSAGE_EXTENDED and then check the result for the
 * specific type. (Since 1.4).
 * 
 *  @var MessageType MESSAGE_DEVICE_ADDED
 * Message indicating a Gst::Device was added to
 * a Gst::DeviceProvider (Since 1.4).
 * 
 *  @var MessageType MESSAGE_DEVICE_REMOVED
 * Message indicating a Gst::Device was removed
 * from a Gst::DeviceProvider (Since 1.4).
 * 
 *  @var MessageType MESSAGE_ANY
 * Mask for all of the above messages.
 * 
 *  @enum MessageType
 * 
 * The different message types that are available.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MessageType operator|(MessageType, MessageType)</tt><br>
 * <tt>%MessageType operator&(MessageType, MessageType)</tt><br>
 * <tt>%MessageType operator^(MessageType, MessageType)</tt><br>
 * <tt>%MessageType operator~(MessageType)</tt><br>
 * <tt>%MessageType& operator|=(MessageType&, MessageType)</tt><br>
 * <tt>%MessageType& operator&=(MessageType&, MessageType)</tt><br>
 * <tt>%MessageType& operator^=(MessageType&, MessageType)</tt><br>
 */
enum MessageType
{
  MESSAGE_UNKNOWN = 0x0,
  MESSAGE_EOS = (1 << 0),
  MESSAGE_ERROR = (1 << 1),
  MESSAGE_WARNING = (1 << 2),
  MESSAGE_INFO = (1 << 3),
  MESSAGE_TAG = (1 << 4),
  MESSAGE_BUFFERING = (1 << 5),
  MESSAGE_STATE_CHANGED = (1 << 6),
  MESSAGE_STATE_DIRTY = (1 << 7),
  MESSAGE_STEP_DONE = (1 << 8),
  MESSAGE_CLOCK_PROVIDE = (1 << 9),
  MESSAGE_CLOCK_LOST = (1 << 10),
  MESSAGE_NEW_CLOCK = (1 << 11),
  MESSAGE_STRUCTURE_CHANGE = (1 << 12),
  MESSAGE_STREAM_STATUS = (1 << 13),
  MESSAGE_APPLICATION = (1 << 14),
  MESSAGE_ELEMENT = (1 << 15),
  MESSAGE_SEGMENT_START = (1 << 16),
  MESSAGE_SEGMENT_DONE = (1 << 17),
  MESSAGE_DURATION_CHANGED = (1 << 18),
  MESSAGE_LATENCY = (1 << 19),
  MESSAGE_ASYNC_START = (1 << 20),
  MESSAGE_ASYNC_DONE = (1 << 21),
  MESSAGE_REQUEST_STATE = (1 << 22),
  MESSAGE_STEP_START = (1 << 23),
  MESSAGE_QOS = (1 << 24),
  MESSAGE_PROGRESS = (1 << 25),
  MESSAGE_TOC = (1 << 26),
  MESSAGE_RESET_TIME = (1 << 27),
  MESSAGE_STREAM_START = (1 << 28),
  MESSAGE_NEED_CONTEXT = (1 << 29),
  MESSAGE_HAVE_CONTEXT = (1 << 30),
  MESSAGE_EXTENDED = (1 << 31)
};

/** @ingroup gstreamermmEnums */
inline MessageType operator|(MessageType lhs, MessageType rhs)
  { return static_cast<MessageType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MessageType operator&(MessageType lhs, MessageType rhs)
  { return static_cast<MessageType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MessageType operator^(MessageType lhs, MessageType rhs)
  { return static_cast<MessageType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MessageType operator~(MessageType flags)
  { return static_cast<MessageType>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MessageType& operator|=(MessageType& lhs, MessageType rhs)
  { return (lhs = static_cast<MessageType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MessageType& operator&=(MessageType& lhs, MessageType rhs)
  { return (lhs = static_cast<MessageType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MessageType& operator^=(MessageType& lhs, MessageType rhs)
  { return (lhs = static_cast<MessageType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MessageType> : public Glib::Value_Flags<Gst::MessageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var ProgressType PROGRESS_TYPE_START
 * A new task started.
 * 
 *  @var ProgressType PROGRESS_TYPE_CONTINUE
 * A task completed and a new one continues.
 * 
 *  @var ProgressType PROGRESS_TYPE_COMPLETE
 * A task completed.
 * 
 *  @var ProgressType PROGRESS_TYPE_CANCELED
 * A task was canceled.
 * 
 *  @var ProgressType PROGRESS_TYPE_ERROR
 * A task caused an error. An error message is also
 * posted on the bus.
 * 
 *  @enum ProgressType
 * 
 * The type of a Gst::MESSAGE_PROGRESS. The progress messages inform the
 * application of the status of asynchronous tasks.
 *
 * @ingroup gstreamermmEnums
 */
enum ProgressType
{
  PROGRESS_TYPE_START,
  PROGRESS_TYPE_CONTINUE,
  PROGRESS_TYPE_COMPLETE,
  PROGRESS_TYPE_CANCELED,
  PROGRESS_TYPE_ERROR
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::ProgressType> : public Glib::Value_Enum<Gst::ProgressType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var StructureChangeType STRUCTURE_CHANGE_TYPE_PAD_LINK
 * Pad linking is starting or done.
 * 
 *  @var StructureChangeType STRUCTURE_CHANGE_TYPE_PAD_UNLINK
 * Pad unlinking is starting or done.
 * 
 *  @enum StructureChangeType
 * 
 * The type of a Gst::MESSAGE_STRUCTURE_CHANGE.
 *
 * @ingroup gstreamermmEnums
 */
enum StructureChangeType
{
  STRUCTURE_CHANGE_TYPE_PAD_LINK,
  STRUCTURE_CHANGE_TYPE_PAD_UNLINK
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::StructureChangeType> : public Glib::Value_Enum<Gst::StructureChangeType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var StreamStatusType STREAM_STATUS_TYPE_CREATE
 * A new thread need to be created.
 * 
 *  @var StreamStatusType STREAM_STATUS_TYPE_ENTER
 * A thread entered its loop function.
 * 
 *  @var StreamStatusType STREAM_STATUS_TYPE_LEAVE
 * A thread left its loop function.
 * 
 *  @var StreamStatusType STREAM_STATUS_TYPE_DESTROY
 * A thread is destroyed.
 * 
 *  @var StreamStatusType STREAM_STATUS_TYPE_START
 * A thread is started.
 * 
 *  @var StreamStatusType STREAM_STATUS_TYPE_PAUSE
 * A thread is paused.
 * 
 *  @var StreamStatusType STREAM_STATUS_TYPE_STOP
 * A thread is stopped.
 * 
 *  @enum StreamStatusType
 * 
 * The type of a Gst::MESSAGE_STREAM_STATUS. The stream status messages inform the
 * application of new streaming threads and their status.
 *
 * @ingroup gstreamermmEnums
 */
enum StreamStatusType
{
  STREAM_STATUS_TYPE_CREATE = 0,
  STREAM_STATUS_TYPE_ENTER = 1,
  STREAM_STATUS_TYPE_LEAVE = 2,
  STREAM_STATUS_TYPE_DESTROY = 3,
  STREAM_STATUS_TYPE_START = 8,
  STREAM_STATUS_TYPE_PAUSE = 9,
  STREAM_STATUS_TYPE_STOP = 10
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::StreamStatusType> : public Glib::Value_Enum<Gst::StreamStatusType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


namespace Enums
{

/** Gets a printable name for the given message type.
 * @param type The message type.
 * @return The name of the message type.
 */
Glib::ustring get_name(MessageType type);

/** Gets the unique quark for the given message type.
 * @param type The message type.
 * @return The quark associated with the message type.
 */
Glib::QueryQuark get_quark(MessageType type);

} //namespace Enums

class Element;
class Pad;
class Structure;
class TagList;

/** A class that represents lightweight objects to signal the application of
 * pipeline events.
 * Messages are implemented as a subclass of Gst::MiniObject with a generic
 * Gst::Structure as the content. This allows for writing custom messages
 * without requiring an API change while allowing a wide range of different
 * types of messages.
 *
 * Messages are posted by objects in the pipeline and are passed to the
 * application using the Gst::Bus.
 *
 * The basic use pattern of posting a message on a Gst::Bus is as follows: 
 * @code
 * bus->post(Gst::MessageEos::create(my_element));
 * @endcode
 *
 * Last reviewed on 2016-06-06 (1.8.0)
 */
class Message : public Gst::MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Message;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstMessage*       gobj();

  ///Provides access to the underlying C instance.
  const GstMessage* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstMessage* gobj_copy() const;

  Message() = delete;

  // noncopyable
  Message(const Message&) = delete;
  Message& operator=(const Message&) = delete;

protected:
  // Do not derive this.  Gst::Message can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
// A copy is taken so that the original is not freed by the wrapper.
 

  /** Access the structure of the message.
   * 
   * @return The structure of the message. The structure is
   * still owned by the message, which means that you should not free it and
   * that the pointer becomes invalid when you free the message.
   * 
   * MT safe.
   */
  Gst::Structure get_structure() const;

  /** Checks if a message is writable. If not, a writable copy is made and
   * returned.
   * @return A Gst::Message (possibly the same pointer) that is writable.
   */
  Glib::RefPtr<Gst::Message> create_writable();

  
  /** Retrieve the sequence number of a message.
   * 
   * Messages have ever-incrementing sequence numbers, which may also be set
   * explicitly via gst_message_set_seqnum(). Sequence numbers are typically used
   * to indicate that a message corresponds to some other set of messages or
   * events, for example a SEGMENT_DONE message corresponding to a SEEK event. It
   * is considered good practice to make this correspondence when possible, though
   * it is not required.
   * 
   * Note that events and messages share the same sequence number incrementor;
   * two events or messages will never have the same sequence number unless
   * that correspondence was made explicitly.
   * 
   * @return The message's sequence number.
   * 
   * MT safe.
   */
  guint32 get_seqnum() const;
  
  /** Set the sequence number of a message.
   * 
   * This function might be called by the creator of a message to indicate that
   * the message relates to other messages or events. See gst_message_get_seqnum()
   * for more information.
   * 
   * MT safe.
   * 
   * @param seqnum A sequence number.
   */
  void set_seqnum(guint32 seqnum);
  
  /** Creates a copy of the message. Returns a copy of the message.
   * 
   * @return A new copy of @a msg.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Message> copy() const;

  /** Get the GstMessageType of message.
   */
  MessageType get_message_type() const;

  /** Get the timestamp of message. This is the timestamp when the message was
   * created.
   */
  Gst::ClockTime get_timestamp() const;

  /** Get the object that posted the message.
   */
  Glib::RefPtr<Gst::Object> get_source();
  Glib::RefPtr<const Gst::Object> get_source() const;

  
  /** Checks if @a message has the given @a name. This function is usually used to
   * check the name of a custom message.
   * 
   * @param name Name to check.
   * @return <tt>true</tt> if @a name matches the name of the message structure.
   */
  bool has_name(const Glib::ustring& name) const;


};

/** An end of stream message.
 * See create() for more details.
 */
class MessageEos : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageEos;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new eos message. This message is generated and posted in
   * the sink elements of a GstBin. The bin will only forward the EOS
   * message to the application if all sinks have posted an EOS message.
   * 
   * @param src The object originating the message.
   * @return The new eos message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageEos> create(const Glib::RefPtr<Gst::Object>& src);


};

/** An error message.
 * See create() for more details.
 */
class MessageError : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageError;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new error message. The message will copy @a error and
   *  @a debug. This message is posted by element when a fatal event
   * occurred. The pipeline will probably (partially) stop. The application
   * receiving this message should stop the pipeline.
   * 
   * @param src The object originating the message.
   * @param error The GError for this message.
   * @param debug A debugging string.
   * @return The new error message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageError> create(const Glib::RefPtr<Gst::Object>& src, const Glib::Error& error, const std::string& debug);

  /** Extracts the Glib::Error and debug string from the Gst::MessageError.
   *
   * MT safe.
   *
   * @param error Location for the Glib::Error.
   * @param debug Location for the debug message.
   */
  void parse(Glib::Error& error, std::string& debug) const;
  

  /** Extracts and returns the Glib::Error from the Gst::MessageError.
   *
   * MT safe.
   *
   * @return The Glib::Error.
   */
  Glib::Error parse_error() const;

  /** Extracts and returns the debug message from the Gst::MessageError.
   *
   * MT safe.
   *
   * @return The debug message.
   */
  std::string parse_debug() const;


};

/** A warning message.
 * See create() for more details.
 */
class MessageWarning : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageWarning;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new warning message. The message will make copies of @a error and
   *  @a debug.
   * 
   * @param src The object originating the message.
   * @param error The GError for this message.
   * @param debug A debugging string.
   * @return The new warning message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageWarning> create(const Glib::RefPtr<Gst::Object>& src, const Glib::Error& error, const std::string& debug);

  /** Extracts the Glib::Error and debug string from the Gst::MessageWarning.
   *
   * MT safe.
   *
   * @param error Location for the Glib::Error.
   * @param debug Location for the debug message.
   */
  void parse(Glib::Error& error, std::string& debug) const;
  

  /** Extracts and returns the Glib::Error from the Gst::MessageWarning.
   *
   * MT safe.
   *
   * @return The Glib::Error.
   */
  Glib::Error parse_error() const;

  /** Extracts and returns the debug message from the Gst::MessageWarning.
   *
   * MT safe.
   *
   * @return The debug message.
   */
  std::string parse_debug() const;


};

/** An informational message.
 * See create() for more details.
 */
class MessageInfo : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageInfo;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new info message. The message will make copies of @a error and
   *  @a debug.
   * 
   * MT safe.
   * 
   * @param src The object originating the message.
   * @param error The GError for this message.
   * @param debug A debugging string.
   * @return The new info message.
   */
  static Glib::RefPtr<Gst::MessageInfo> create(const Glib::RefPtr<Gst::Object>& src, const Glib::Error& error, const std::string& debug);

  /** Extracts the Glib::Error and debug string from the Gst::MessageInfo.
   *
   * MT safe.
   *
   * @param error Location for the Glib::Error.
   * @param debug Location for the debug message.
   */
  void parse(Glib::Error& error, std::string& debug) const;
  

  /** Extracts and returns the Glib::Error from the Gst::MessageInfo.
   *
   * MT safe.
   *
   * @return The Glib::Error.
   */
  Glib::Error parse_error() const;

  /** Extracts and returns the debug message from the Gst::MessageInfo.
   *
   * MT safe.
   *
   * @return The debug message.
   */
  std::string parse_debug() const;


};

/** A tag message.
 * See create() for more details.
 */
class MessageTag : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageTag;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new tag message. The message will take ownership of the tag list.
   * The message is posted by elements that discovered a new taglist.
   * 
   * @param src The object originating the message.
   * @param taglist The tag list for the message.
   * @return The new tag message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageTag> create(const Glib::RefPtr<Gst::Object>& src, const Gst::TagList& taglist);


  /** Extracts and returns the Gst::TagList from the Gst::MessageTag.
   *
   * MT safe.
   *
   * @return A copy of the Gst::TagList.
   */
  Gst::TagList parse_tag_list() const;
  

};

/** A buffering message.
 * See create() for more details.
 */
class MessageBuffering : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageBuffering;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new buffering message. This message can be posted by an element that
   * needs to buffer data before it can continue processing. @a percent should be a
   * value between 0 and 100. A value of 100 means that the buffering completed.
   * 
   * When @a percent is < 100 the application should PAUSE a PLAYING pipeline. When
   *  @a percent is 100, the application can set the pipeline (back) to PLAYING.
   * The application must be prepared to receive BUFFERING messages in the
   * PREROLLING state and may only set the pipeline to PLAYING after receiving a
   * message with @a percent set to 100, which can happen after the pipeline
   * completed prerolling.
   * 
   * MT safe.
   * 
   * @param src The object originating the message.
   * @param percent The buffering percent.
   * @return The new buffering message.
   */
  static Glib::RefPtr<Gst::MessageBuffering> create(const Glib::RefPtr<Gst::Object>& src, int percent);

  /** Extracts and returns the buffering percent from the
   * Gst::MessageBuffering.
   * @return The percent as an integer.
   */
  int parse_buffering() const;
  

  /** Configures the buffering stats values in message.
   *
   * @param mode A buffering mode.
   * @param avg_in The average input rate.
   * @param avg_out The average output rate.
   * @param buffering_left Amount of buffering time left in milliseconds.
   *
   * Since 0.10.20.
   */
  void set_stats(BufferingMode mode, int avg_in, int avg_out, gint64 buffering_left);
  

  /** Extracts the buffering stats values from message.
   *
   * @param mode Location for the buffering mode.
   * @param avg_in Location for the average input rate.
   * @param avg_out Location for the average output rate.
   * @param buffering_left Location for the amount of buffering time left.
   *
   * Since 0.10.20.
   */
  void parse_stats(BufferingMode& mode, int& avg_in, int& avg_out, gint64& buffering_left) const;
  

  /** Extracts and returns the buffering mode from message.
   *
   * @return The buffering mode.
   */
  BufferingMode parse_stats_buffering_mode() const;

  /** Extracts and returns the average input rate from message.
   *
   * @return The average input rate.
   */
  int parse_stats_avg_in() const;

  /** Extracts and returns the average output rate from message.
   *
   * @return The average output rate.
   */
  int parse_stats_avg_out() const;

  /** Extracts and returns the buffering time in milliseconds remaining from
   * message.
   *
   * @return The buffering time remaining.
   */
  gint64 parse_stats_buffering_left() const;


};

/** A state change message.
 * See create() for more details.
 */
class MessageStateChanged : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageStateChanged;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a state change message. This message is posted whenever an element
   * changed its state.
   * 
   * @param src The object originating the message.
   * @param oldstate The previous state.
   * @param newstate The new (current) state.
   * @param pending The pending (target) state.
   * @return The new state change message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageStateChanged> create(const Glib::RefPtr<Gst::Object>& src, State oldstate, State newstate, State pending);

  /** Extracts the old, new and pending states from the
   * Gst::MessageStateChanged.
   *
   * MT safe.
   *
   * @param oldstate The previous state.
   * @param newstate The new (current) state.
   * @param pending The pending (target) state.
   */
  void parse(State& oldstate, State& newstate, State& pending) const;
  

  /** Extracts and returns the new state from the Gst::MessageStateChanged.
   *
   * MT safe.
   *
   * @return The new (current) state.
   */
  State parse_new_state() const;

  /** Extracts and returns the old state from the Gst::MessageStateChanged.
   *
   * MT safe.
   *
   * @return The old state.
   */
  State parse_old_state() const;

  /** Extracts and returns the pending state from the Gst::MessageStateChanged.
   *
   * MT safe.
   *
   * @return The pending state.
   */
  State parse_pending_state() const;


};

/** A state dirty message.
 * See create() for more details.
 */
class MessageStateDirty : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageStateDirty;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a state dirty message. This message is posted whenever an element
   * changed its state asynchronously and is used internally to update the
   * states of container objects.
   * 
   * @param src The object originating the message.
   * @return The new state dirty message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageStateDirty> create(const Glib::RefPtr<Gst::Object>& src);


};

/** A step done message.
 * See create() for more details.
 */
class MessageStepDone : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageStepDone;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** This message is posted by elements when they complete a part, when @a intermediate set
   * to <tt>true</tt>, or a complete step operation.
   * 
   *  @a duration will contain the amount of time (in GST_FORMAT_TIME) of the stepped
   *  @a amount of media in format @a format.
   * 
   * @param src The object originating the message.
   * @param format The format of @a amount.
   * @param amount The amount of stepped data.
   * @param rate The rate of the stepped amount.
   * @param flush Is this an flushing step.
   * @param intermediate Is this an intermediate step.
   * @param duration The duration of the data.
   * @param eos The step caused EOS.
   * @return The new step_done message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageStepDone> create(const Glib::RefPtr<Gst::Object>& src, Gst::Format format, guint64 amount, double rate, bool flush, bool intermediate, guint64 duration, bool eos);

  /** Extract the values of the step done message.
   *
   * MT safe.
   *
   * @param format Result location for the format.
   * @param amount Result location for the amount.
   * @param rate Result location for the rate.
   * @param flush Result location for the flush flag.
   * @param intermediate Result location for the intermediate flag.
   * @param duration Result location for the duration.
   * @param eos Result location for the EOS flag.
   *
   * Since 0.10.24.
   */
  void parse(Gst::Format& format, guint64& amount, double& rate, bool& flush,
    bool& intermediate, guint64& duration, bool& eos) const;
  

  /** Extracts the duration of the step done message.
   * @return The duration.
   */
  guint64 parse_duration() const;

  /** Extracts the format of the step done message.
   * @return The format.
   */
  Gst::Format parse_format() const;

  /** Extracts the amount of the step done message.
   * @return The amount.
   */
  guint64 parse_amount() const;

  /** Extracts the rate of the step done message.
   * @return The rate.
   */
  double parse_rate() const;

  /** Extracts the flush flag of the step done message.
   * @return The flush flag.
   */
  bool parse_flush() const;

  /** Extracts the intermediate flag of the step done message.
   * @return The intermediate flag.
   */
  bool parse_intermediate() const;

  /** Extracts the eos flag of the step done message.
   * @return The eos flag.
   */
  bool parse_eos() const;


};

/** A clock provide message.
 * See create() for more details.
 */
class MessageClockProvide : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageClockProvide;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a clock provide message. This message is posted whenever an
   * element is ready to provide a clock or lost its ability to provide
   * a clock (maybe because it paused or became EOS).
   * 
   * This message is mainly used internally to manage the clock
   * selection.
   * 
   * @param src The object originating the message.
   * @param clock The clock it provides.
   * @param ready <tt>true</tt> if the sender can provide a clock.
   * @return The new provide clock message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageClockProvide> create(const Glib::RefPtr<Gst::Object>& src, const Glib::RefPtr<Gst::Clock>& clock, bool ready);

  /** Extracts the clock and ready flag from the Gst::MessageClockProvide. The
   * clock object returned remains valid until the message is freed.
   *
   * MT safe.
   *
   * @param clock Location in which to hold a clock object.
   * @param ready Location in which to hold the ready flag.
   */
  void parse(Glib::RefPtr<Gst::Clock>& clock, bool& ready) const;
  

  /** Extracts and returns the clock from the Gst::MessageClockProvide. The
   * clock object returned remains valid until the message is freed.
   *
   * MT safe.
   *
   * @return The clock object of the message.
   */
  Glib::RefPtr<Gst::Clock> parse_clock_provide();

  /** Extracts and returns the clock from the Gst::MessageClockProvide. The
   * clock object returned remains valid until the message is freed.
   *
   * MT safe.
   *
   * @return The clock object of the message.
   */
  Glib::RefPtr<const Gst::Clock> parse_clock_provide() const;

  /** Extracts and returns the ready flag from the Gst::MessageClockProvide.
   *
   * MT safe.
   *
   * @return The ready flag of the message.
   */
  bool parse_ready() const;


};

/** A clock lost message.
 * See create() for more details.
 */
class MessageClockLost : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageClockLost;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a clock lost message. This message is posted whenever the
   * clock is not valid anymore.
   * 
   * If this message is posted by the pipeline, the pipeline will
   * select a new clock again when it goes to PLAYING. It might therefore
   * be needed to set the pipeline to PAUSED and PLAYING again.
   * 
   * @param src The object originating the message.
   * @param clock The clock that was lost.
   * @return The new clock lost message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageClockLost> create(const Glib::RefPtr<Gst::Object>& src, const Glib::RefPtr<Gst::Clock>& clock);

  /** Extracts and returns the lost clock from the Gst::MessageClockLost. The
   * clock object returned remains valid until the message is freed.
   *
   * MT safe.
   * @return The lost clock.
   */
  Glib::RefPtr<Gst::Clock> parse_clock_lost();
  

  /** Extracts and returns the lost clock from the Gst::MessageClockLost. The
   * clock object returned remains valid until the message is freed.
   *
   * MT safe.
   * @return The lost clock.
   */
  Glib::RefPtr<const Gst::Clock> parse_clock_lost() const;


};

/** A new clock message.
 * See create() for more details.
 */
class MessageNewClock: public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageNewClock;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new clock message. This message is posted whenever the
   * pipeline selects a new clock for the pipeline.
   * 
   * @param src The object originating the message.
   * @param clock The new selected clock.
   * @return The new new clock message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageNewClock> create(const Glib::RefPtr<Gst::Object>& src, const Glib::RefPtr<Gst::Clock>& clock);

  /** Extracts and returns the new clock from the Gst::MessageNewClock. The
   * clock object returned remains valid until the message is freed.
   *
   * MT safe.
   *
   * @return The selected new clock.
   */
  Glib::RefPtr<Gst::Clock> parse_new_clock();
  

  /** Extracts and returns the new clock from the Gst::MessageNewClock. The
   * clock object returned remains valid until the message is freed.
   *
   * MT safe.
   *
   * @return The selected new clock.
   */
  Glib::RefPtr<const Gst::Clock> parse_new_clock() const;


};

/** An application message.
 * See create() for more details.
 */
class MessageApplication : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageApplication;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new application-typed message. GStreamer will never create these
   * messages; they are a gift from us to you. Enjoy.
   * 
   * @param src The object originating the message.
   * @param structure The structure for the message. The message
   * will take ownership of the structure.
   * @return The new application message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageApplication> create(const Glib::RefPtr<Gst::Object>& src, Gst::Structure&& structure);

  /** Create a new application-typed message. GStreamer will never create these
   * messages; they are a gift from us to you. Enjoy.
   *
   * @param src The object originating the message.
   * @param structure The structure for the message. The message
   * will take ownership of the structure.
   * @return The new application message.
   *
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageApplication> create(const Glib::RefPtr<Gst::Object>& src, const Gst::Structure& structure);


};

/** An element specific message.
 * See create() for more details.
 */
class MessageElement : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageElement;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new element-specific message. This is meant as a generic way of
   * allowing one-way communication from an element to an application, for example
   * "the firewire cable was unplugged". The format of the message should be
   * documented in the element's documentation. The structure field can be <tt>nullptr</tt>.
   * 
   * @param src The object originating the message.
   * @param structure The structure for the
   * message. The message will take ownership of the structure.
   * @return The new element message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageElement> create(const Glib::RefPtr<Gst::Object>& src, Gst::Structure&& structure);

  /// A create() convenience overload.
  static Glib::RefPtr<Gst::MessageElement> create(const Glib::RefPtr<Gst::Object>& src);

  /** Create a new element-specific message. This is meant as a generic way of
   * allowing one-way communication from an element to an application, for example
   * "the firewire cable was unplugged". The format of the message should be
   * documented in the element's documentation. The structure field can be <tt>0</tt>.
   *
   * @param src The object originating the message.
   * @param structure The structure for the
   * message. The message will take ownership of the structure.
   * @return The new element message.
   *
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageElement> create(const Glib::RefPtr<Gst::Object>& src, const Gst::Structure& structure);


};

/** A custom message.
 * See create() for more details.
 */
class MessageCustom : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageCustom;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new custom-typed message. This can be used for anything not
   * handled by other message-specific functions to pass a message to the
   * app. The structure field can be <tt>nullptr</tt>.
   * 
   * @param type The Gst::MessageType to distinguish messages.
   * @param src The object originating the message.
   * @param structure The structure for the
   * message. The message will take ownership of the structure.
   * @return The new message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageCustom> create(MessageType type, const Glib::RefPtr<Gst::Object>& src, Gst::Structure& structure);

  /// A create() convenience overload.
  static Glib::RefPtr<Gst::MessageCustom> create(MessageType type, const Glib::RefPtr<Gst::Object>& src);


};

/** A segment start message.
 * See create() for more details.
 */
class MessageSegmentStart : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageSegmentStart;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new segment message. This message is posted by elements that
   * start playback of a segment as a result of a segment seek. This message
   * is not received by the application but is used for maintenance reasons in
   * container elements.
   * 
   * @param src The object originating the message.
   * @param format The format of the position being played.
   * @param position The position of the segment being played.
   * @return The new segment start message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageSegmentStart> create(const Glib::RefPtr<Gst::Object>& src, Format format, gint64 position);

  /** Extracts the position and format from the segment start message.
   *
   * MT safe.
   *
   * @param format Result location for the format.
   * @param position Result location for the position.
   */
  void parse(Format& format, gint64& position) const;
  

  /** Extracts and returns the position from the segment start message.
   *
   * MT safe.
   *
   * @return The position.
   */
  gint64 parse_position() const;

  /** Extracts and returns the format from the segment start message.
   *
   * MT safe.
   *
   * @return The format.
   */
  Format parse_format() const;


};

/** A segment done message.
 * See create() for more details.
 */
class MessageSegmentDone : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageSegmentDone;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new segment done message. This message is posted by elements that
   * finish playback of a segment as a result of a segment seek. This message
   * is received by the application after all elements that posted a segment_start
   * have posted the segment_done.
   * 
   * @param src The object originating the message.
   * @param format The format of the position being done.
   * @param position The position of the segment being done.
   * @return The new segment done message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageSegmentDone> create(const Glib::RefPtr<Gst::Object>& src, Format format, gint64 position);

  /** Extracts the position and format from the segment done message.
   *
   * MT safe.
   *
   * @param format Result location for the format.
   * @param position Result location for the position.
   */
  void parse(Format& format, gint64& position) const;
  

  /** Extracts and returns the position from the segment done message.
   *
   * MT safe.
   *
   * @return The position.
   */
  gint64 parse_position() const;

  /** Extracts and returns the format from the segment done message.
   *
   * MT safe.
   *
   * @return The format.
   */
  Format parse_format() const;


};

/** A duration message.
 * See create() for more details.
 */
class MessageDurationChanged : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageDurationChanged;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new duration changed message. This message is posted by elements
   * that know the duration of a stream when the duration changes. This message
   * is received by bins and is used to calculate the total duration of a
   * pipeline. Elements may post a duration message with a duration of
   * GST_CLOCK_TIME_NONE to indicate that the duration has changed and the 
   * cached duration should be discarded. The new duration can then be 
   * retrieved via a query.
   * 
   * @param src The object originating the message.
   * @return The new duration-changed message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageDurationChanged> create(const Glib::RefPtr<Gst::Object>& src);


};

/** A latency message.
 * See create() for more details.
 */
class MessageLatency : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageLatency;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** This message can be posted by elements when their latency requirements have
   * changed.
   * 
   * @param src The object originating the message.
   * @return The new latency message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageLatency> create(const Glib::RefPtr<Gst::Object>& src);


};

/** An asynchronous start message.
 * See create() for more details.
 */
class MessageAsyncStart : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageAsyncStart;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** This message is posted by elements when they start an ASYNC state change.
   * 
   * @param src The object originating the message.
   * @return The new async_start message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageAsyncStart> create(const Glib::RefPtr<Gst::Object>& src);


};

/** An asynchronous done message.
 * See create() for more details.
 */
class MessageAsyncDone : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageAsyncDone;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** The message is posted when elements completed an ASYNC state change.
   *  @a running_time contains the time of the desired running_time when this
   * elements goes to PLAYING. A value of Gst::CLOCK_TIME_NONE for @a running_time
   * means that the element has no clock interaction and thus doesn't care about
   * the running_time of the pipeline.
   * 
   * @param src The object originating the message.
   * @param running_time The desired running_time.
   * @return The new async_done message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageAsyncDone> create(const Glib::RefPtr<Gst::Object>& src, Gst::ClockTime running_time);

  /** Extract the running_time from the async_done message.
   *
   * MT safe.
   *
   * @return The running time from the async_done message.
   */
  Gst::ClockTime parse_running_time() const;
  

};

/** A step start message.
 * See create() for more details.
 */
class MessageStepStart : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageStepStart;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** This message is posted by elements when they accept or activate a new step
   * event for @a amount in @a format. 
   * 
   *  @a active is set to <tt>false</tt> when the element accepted the new step event and has
   * queued it for execution in the streaming threads.
   * 
   *  @a active is set to <tt>true</tt> when the element has activated the step operation and
   * is now ready to start executing the step in the streaming thread. After this
   * message is emitted, the application can queue a new step operation in the
   * element.
   * 
   * @param src The object originating the message.
   * @param active If the step is active or queued.
   * @param format The format of @a amount.
   * @param amount The amount of stepped data.
   * @param rate The rate of the stepped amount.
   * @param flush Is this an flushing step.
   * @param intermediate Is this an intermediate step.
   * @return The new step_start message. 
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageStepStart> create(const Glib::RefPtr<Gst::Object>& src, bool active, Gst::Format format, guint64 amount, double rate, bool flush, bool intermediate);

  /** Extract the values of the step start message.
   *
   * MT safe.
   *
   * @param active Result location for the active flag.
   * @param format Result location for the format.
   * @param amount Result location for the amount.
   * @param rate Result location for the rate.
   * @param flush Result location for the flush flag.
   * @param intermediate Result location for the intermediate flag.
   *
   * Since 0.10.24.
   */
  void parse(bool& active, Gst::Format& format, guint64& amount, double& rate,
    bool& flush, bool& intermediate) const;
  

  /** Extracts the amount of the step start message.
   * @return The amount.
   */
  guint64 parse_amount() const;

  /** Extracts the active flag of the step start message.
   * @return The active flag.
   */
  bool parse_active() const;

  /** Extracts the format of the step start message.
   * @return The format.
   */
  Gst::Format parse_format() const;

  /** Extracts the rate of the step start message.
   * @return The rate.
   */
  double parse_rate() const;

  /** Extracts the flush flag of the step start message.
   * @return The flush flag.
   */
  bool parse_flush() const;

  /** Extracts the intermediate flag of the step start message.
   * @return The intermediate flag.
   */
  bool parse_intermediate() const;


};

/** A structure change message.
 * See create() for more details.
 */
class MessageStructureChange : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageStructureChange;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new structure change message. This message is posted when the
   * structure of a pipeline is in the process of being changed, for example
   * when pads are linked or unlinked.
   * 
   *  @a src should be the sinkpad that unlinked or linked.
   * 
   * @param src The object originating the message.
   * @param type The change type.
   * @param owner The owner element of @a src.
   * @param busy Whether the structure change is busy.
   * @return The new structure change message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageStructureChange> create(const Glib::RefPtr<Gst::Object>& src, Gst::StructureChangeType type, const Glib::RefPtr<Gst::Element>& owner, bool busy);

  /** Extracts the change type and completion status from the Gst::Message.
   * MT safe.
   *
   * @param type A reference to hold the change type.
   * @param owner The owner element of the message source.
   * @param busy A reference to hold whether the change is in progress or has
   * been completed.
   *
   * Since 0.10.22.
   */
  void parse(Gst::StructureChangeType& type,
    Glib::RefPtr<Gst::Element>& owner, bool& busy) const;
  

  /** Extracts the change type from the Gs::tMessage.
   * MT safe.
   *
   * @return The change type.
   *
   * Since 0.10.22.
   */
  Gst::StructureChangeType parse_type() const;

  /** Extracts the owner from the Gst::Message.
   * MT safe.
   *
   * @return The owner element of the message source.
   *
   * Since 0.10.22.
   */
  Glib::RefPtr<Gst::Element> parse_owner() const;

  /** Extracts the completion status from the Gst::Message.
   * MT safe.
   *
   * @return whether the change is in progress or has been completed.
   *
   * Since 0.10.22.
   */
  bool parse_busy() const;


};

/** A request state message.
 * See create() for more details.
 */
class MessageRequestState : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageRequestState;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** This message can be posted by elements when they want to have their state
   * changed. A typical use case would be an audio server that wants to pause the
   * pipeline because a higher priority stream is being played.
   * 
   * @param src The object originating the message.
   * @param state The new requested state.
   * @return The new request state message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageRequestState> create(const Glib::RefPtr<Gst::Object>& src, Gst::State state);

  /** Extract the requested state from the request_state message.
   * @return The state. MT safe.
   *
   * Since 0.10.23.
   */
  Gst::State parse_state() const;
  

};

/** A stream status message.
 * See create() for more details.
 */
class MessageStreamStatus : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageStreamStatus;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new stream status message. This message is posted when a streaming
   * thread is created/destroyed or when the state changed.
   * 
   * @param src The object originating the message.
   * @param type The stream status type.
   * @param owner The owner element of @a src.
   * @return The new stream status message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageStreamStatus> create(const Glib::RefPtr<Gst::Object>& src, Gst::StreamStatusType type, const Glib::RefPtr<Gst::Element>& owner);

  /** Configures the object handling the streaming thread. This is usually a
   * Gst::Task object but other objects might be added in the future.
   * @param object The object controlling the streaming.
   *
   * Since 0.10.24.
   */
  void set_object(const Glib::RefPtr<Gst::Object>& object);
  

  /** Extracts the object managing the streaming thread from message.
   * @return The object that manages the streaming thread. The actual object
   * is usually a Gst::Task but other types can be added in the future. The
   * object remains valid as long as the message is valid. 
   */
  Glib::RefPtr<Gst::Object> get_object() const;
  

  /** Extracts the stream status type and owner of the Gst::Message. The
   * returned owner remains valid for as long as the reference to the message
   * is valid.
   *
   * MT safe.
   *
   * @param type A reference to hold the status type.
   * @param owner A reference to hold the owner Gst::Element.
   *
   * Since 0.10.24.
   */
  void parse(Gst::StreamStatusType& type, Glib::RefPtr<Gst::Element>& owner) const;
  

  /** Extracts the stream status type.
   *
   * MT safe.
   *
   * @return The stream status type.
   *
   * Since 0.10.24.
   */
  Gst::StreamStatusType parse_type() const;

  /** Extracts the owner of the Gst::Message. The returned owner remains valid
   * for as long as the reference to the message is valid.
   *
   * MT safe.
   *
   * @return The owner Gst::Element.
   *
   * Since 0.10.24.
   */
  Glib::RefPtr<Gst::Element> parse_owner() const;


};

/** A qos message.
 * See create() for more details.
 */
class MessageQos : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageQos;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** A QOS message is posted on the bus whenever an element decides to drop a
   * buffer because of QoS reasons or whenever it changes its processing strategy
   * because of QoS reasons (quality adjustments such as processing at lower
   * accuracy).
   * 
   * This message can be posted by an element that performs synchronisation against the
   * clock (live) or it could be dropped by an element that performs QoS because of QOS
   * events received from a downstream element (!live).
   * 
   *  @a running_time, @a stream_time, @a timestamp, @a duration should be set to the
   * respective running-time, stream-time, timestamp and duration of the (dropped)
   * buffer that generated the QoS event. Values can be left to
   * GST_CLOCK_TIME_NONE when unknown.
   * 
   * @param src The object originating the message.
   * @param live If the message was generated by a live element.
   * @param running_time The running time of the buffer that generated the message.
   * @param stream_time The stream time of the buffer that generated the message.
   * @param timestamp The timestamps of the buffer that generated the message.
   * @param duration The duration of the buffer that generated the message.
   * @return The new qos message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageQos> create(const Glib::RefPtr<Gst::Object>& src, bool live, guint64 running_time, guint64 stream_time, guint64 timestamp, guint64 duration);

  /** Set the QoS values that have been calculated/analysed from the QoS data.
   *
   * MT safe.
   *
   * @param jitter The difference of the running-time against the deadline.
   * @param proportion Long term prediction of the ideal rate relative to normal rate
   *    to get optimal quality.
   * @param quality An element dependent integer value that specifies the current
   *     quality level of the element. The default maximum quality is 1000000.
   */
  void set_values(gint64 jitter, double proportion, gint quality);
  

  /** Set the QoS stats representing the history of the current continuous pipeline
   * playback period.
   *
   * When @a format is Gst::FORMAT_UNDEFINED both @a dropped and @a processed are
   * invalid. Values of -1 for either @a processed or @a dropped mean unknown values.
   *
   * MT safe.
   *
   * @param format Units of the @a processed and @a dropped fields. Video sinks and video
   *    filters will use Gst::FORMAT_BUFFERS (frames). Audio sinks and audio filters
   *    will likely use Gst::FORMAT_DEFAULT (samples).
   * @param processed Total number of units correctly processed since the last state
   *    change to READY or a flushing operation.
   * @param dropped Total number of units dropped since the last state change to READY
   *    or a flushing operation.
   */
  void set_stats(Gst::Format format, guint64 processed, guint64 dropped);
  

  /** Extract the timestamps and live status from the QoS message.
   *
   * The returned values give the running_time, stream_time, timestamp and
   * duration of the dropped buffer. Values of Gst::CLOCK_TIME_NONE mean unknown
   * values.
   *
   * MT safe.
   *
   * @param live If the message was generated by a live element.
   * @param running_time The running time of the buffer that
   *     generated the message.
   * @param stream_time The stream time of the buffer that
   *     generated the message.
   * @param timestamp The timestamps of the buffer that
   *     generated the message.
   * @param duration The duration of the buffer that
   *     generated the message.
   */
  void parse(bool& live, guint64& running_time, guint64& stream_time,
    guint64& timestamp, guint64& duration) const;
  

  /** Extract the QoS values that have been calculated/analysed from the QoS data.
   * @param jitter The difference of the running-time against
   *     the deadline.
   * @param proportion Long term prediction of the ideal rate
   *     relative to normal rate to get optimal quality.
   * @param quality An element dependent integer value that
   *     specifies the current quality level of the element. The default
   *     maximum quality is 1000000.
   *
   * MT safe.
   */
  void parse_values(gint64& jitter, double& proportion, gint& quality) const;
  

  /** Extract the QoS stats representing the history of the current continuous
   * pipeline playback period.
   *
   * @param format Units of the 'processed' and 'dropped' fields.
   *     Video sinks and video filters will use GST_FORMAT_BUFFERS (frames).
   *     Audio sinks and audio filters will likely use GST_FORMAT_DEFAULT
   *     (samples).
   * @param processed Total number of units correctly processed
   *     since the last state change to READY or a flushing operation.
   * @param dropped Total number of units dropped since the last
   *     state change to READY or a flushing operation.
   *
   * MT_safe.
   *
   * When @a format is Gst::FORMAT_UNDEFINED both @a dropped and @a processed are
   * invalid. Values of -1 for either @a processed or @a dropped mean unknown values.
   */
  void parse_stats(Gst::Format& format, guint64& processed, guint64& dropped) const;
  

};

/** A stream-start message.
 * See create() for more details.
 */
class MessageStreamStart : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageStreamStart;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new stream_start message. This message is generated and posted in
   * the sink elements of a GstBin. The bin will only forward the STREAM_START
   * message to the application if all sinks have posted an STREAM_START message.
   * 
   * @param src The object originating the message.
   * @return The new stream_start message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageStreamStart> create(const Glib::RefPtr<Gst::Object>& src);

  /** Sets the group id on the stream-start message.
   *
   * All streams that have the same group id are supposed to be played
   * together, i.e. all streams inside a container file should have the
   * same group id but different stream ids. The group id should change
   * each time the stream is started, resulting in different group ids
   * each time a file is played for example.
   *
   * MT safe.
   *
   * @param group_id The group id.
   */
  void set_group_id(guint group_id);
  

  /** Extract the group from the STREAM_START message.
   *
   * MT safe
   *
   * @param group_id Result location for the group id.
   *
   * @return true if the message had a group id set, false otherwse.
   */
  bool parse_group_id(guint& group_id) const;
  

};

/** A have-context message.
 * See create() for more details.
 */
class MessageHaveContext : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageHaveContext;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** This message is posted when an element has a new local Gst::Context.
   * 
   * @param src The object originating the message.
   * @param context The context.
   * @return The new have-context message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageHaveContext> create(const Glib::RefPtr<Gst::Object>& src, const Glib::RefPtr<Gst::Context>& context);

  /** Extract the context from the HAVE_CONTEXT message.
   *
   * MT safe.
   *
   * @return context Result location for the context.
   */
  Glib::RefPtr<Gst::Context> parse_have_context();
  

  /** Extract the context from the HAVE_CONTEXT message.
   *
   * MT safe.
   *
   * @return context Result location for the context.
   */
  Glib::RefPtr<const Gst::Context> parse_have_context() const;


};

/** A need-context message.
 * See create() for more details.
 */
class MessageNeedContext : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageNeedContext;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** This message is posted when an element needs a specific Gst::Context.
   * 
   * @param src The object originating the message.
   * @param context_type The context type that is needed.
   * @return The new need-context message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageNeedContext> create(const Glib::RefPtr<Gst::Object>& src, const Glib::ustring& context_type);

  /** Parse a context type from an existing Gst::MESSAGE_NEED_CONTEXT message.
   *
   * @param context_type The context type.
   *
   * @return a bool indicating if the parsing succeeded.
   */
  bool parse(Glib::ustring& context_type) const;
  

};

/** A reset-time message.
 * See create() for more details.
 */
class MessageResetTime : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageResetTime;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** This message is posted when the pipeline running-time should be reset to
   *  @a running_time, like after a flushing seek.
   * 
   * @param src The object originating the message.
   * @param running_time The requested running-time.
   * @return The new reset_time message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageResetTime> create(const Glib::RefPtr<Gst::Object>& src, Gst::ClockTime running_time);

  /** Extract the running-time from the RESET_TIME message.
   *
   * MT safe.
   *
   * @return Result location for the running_time.
   */
  Gst::ClockTime parse_running_time() const;
  

};

/** A toc message.
 * See create() for more details.
 */
class MessageToc : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageToc;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new TOC message. The message is posted by elements
   * that discovered or updated a TOC.
   * 
   * @param src The object originating the message.
   * @param toc Gst::Toc structure for the message.
   * @param updated Whether TOC was updated or not.
   * @return A new TOC message.
   * 
   * MT safe.
   */
  static Glib::RefPtr<Gst::MessageToc> create(const Glib::RefPtr<Gst::Object>& src, const Glib::RefPtr<Gst::Toc>& toc, bool updated);

  /** Extract the TOC from the Gst::Message.
   *
   * MT safe.
   *
   * @param toc Return location for the TOC.
   * @param updated Return location for the updated flag.
   */
  void parse(Glib::RefPtr<Gst::Toc>& toc, bool& updated) const;
  

};

/** A progress message.
 * See create() for more details.
 */
class MessageProgress : public Message
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MessageProgress;
  using BaseObjectType = GstMessage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Progress messages are posted by elements when they use an asynchronous task
   * to perform actions triggered by a state change.
   * 
   *  @a code contains a well defined string describing the action.
   *  @a test should contain a user visible string detailing the current action.
   * 
   * @param src The object originating the message.
   * @param type A Gst::ProgressType.
   * @param code A progress code.
   * @param text Free, user visible text describing the progress.
   * @return The new qos message.
   */
  static Glib::RefPtr<Gst::MessageProgress> create(const Glib::RefPtr<Gst::Object>& src, Gst::ProgressType type, const Glib::ustring& code, const Glib::ustring& text);

  /** Parses the progress @a type, @a code and @a text.
   *
   * @param type A Gst::ProgressType.
   * @param code A code.
   * @param text A text.
   */
  void parse(Gst::ProgressType& type, Glib::ustring& code, Glib::ustring& text) const;
  

  /** Extracts and returns the ProgressType from the Gst::MessageProgress.
   *
   * @return The ProgressType.
   */
  Gst::ProgressType parse_type() const;

  /** Extracts and returns the code from the Gst::MessageProgress.
   *
   * @return The code.
   */
  Glib::ustring parse_code() const;

  /** Extracts and returns the text from the Gst::MessageProgress.
   *
   * @return The text.
   */
  Glib::ustring parse_text() const;


};

} //namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Message
   */
  Glib::RefPtr<Gst::Message> wrap(GstMessage* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_MESSAGE_H */

