/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;

public abstract class BaseTreeAdaptor
implements TreeAdaptor {
    protected int uniqueNodeID = 1;

    public Object nil() {
        return this.create(null);
    }

    public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
        CommonErrorNode t = new CommonErrorNode(input, start, stop, e);
        return t;
    }

    public boolean isNil(Object tree) {
        return ((Tree)tree).isNil();
    }

    public Object dupTree(Object tree) {
        return this.dupTree(tree, null);
    }

    public Object dupTree(Object t, Object parent) {
        if (t == null) {
            return null;
        }
        Object newTree = this.dupNode(t);
        this.setChildIndex(newTree, this.getChildIndex(t));
        this.setParent(newTree, parent);
        int n = this.getChildCount(t);
        for (int i = 0; i < n; ++i) {
            Object child = this.getChild(t, i);
            Object newSubTree = this.dupTree(child, t);
            this.addChild(newTree, newSubTree);
        }
        return newTree;
    }

    public void addChild(Object t, Object child) {
        if (t != null && child != null) {
            ((Tree)t).addChild((Tree)child);
        }
    }

    public Object becomeRoot(Object newRoot, Object oldRoot) {
        Tree newRootTree = (Tree)newRoot;
        Tree oldRootTree = (Tree)oldRoot;
        if (oldRoot == null) {
            return newRoot;
        }
        if (newRootTree.isNil()) {
            int nc = newRootTree.getChildCount();
            if (nc == 1) {
                newRootTree = newRootTree.getChild(0);
            } else if (nc > 1) {
                throw new RuntimeException("more than one node as root (TODO: make exception hierarchy)");
            }
        }
        newRootTree.addChild(oldRootTree);
        return newRootTree;
    }

    public Object rulePostProcessing(Object root) {
        Tree r = (Tree)root;
        if (r != null && r.isNil()) {
            if (r.getChildCount() == 0) {
                r = null;
            } else if (r.getChildCount() == 1) {
                r = r.getChild(0);
                r.setParent(null);
                r.setChildIndex(-1);
            }
        }
        return r;
    }

    public Object create(int tokenType, Token fromToken) {
        fromToken = this.createToken(fromToken);
        fromToken.setType(tokenType);
        Tree t = (Tree)this.create(fromToken);
        return t;
    }

    public Object create(int tokenType, Token fromToken, String text) {
        if (fromToken == null) {
            return this.create(tokenType, text);
        }
        fromToken = this.createToken(fromToken);
        fromToken.setType(tokenType);
        fromToken.setText(text);
        Tree t = (Tree)this.create(fromToken);
        return t;
    }

    public Object create(int tokenType, String text) {
        Token fromToken = this.createToken(tokenType, text);
        Tree t = (Tree)this.create(fromToken);
        return t;
    }

    public int getType(Object t) {
        return ((Tree)t).getType();
    }

    public String getText(Object t) {
        return ((Tree)t).getText();
    }

    public Object getChild(Object t, int i) {
        return ((Tree)t).getChild(i);
    }

    public int getChildCount(Object t) {
        return ((Tree)t).getChildCount();
    }

    public abstract Token createToken(int var1, String var2);

    public abstract Token createToken(Token var1);
}

