/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.popupswitcher;

import java.awt.Image;
import javax.swing.Icon;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

abstract class Item {
    private final String displayName;
    private final String description;
    private final Icon icon;
    private final boolean active;

    protected Item(String string, String string2, Icon icon, boolean bl) {
        this.displayName = string;
        this.description = string2;
        this.icon = icon;
        this.active = bl;
    }

    public static Item create(TopComponent topComponent) {
        return new TopItem(topComponent);
    }

    public abstract void activate();

    public final String toString() {
        return this.displayName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final Icon getIcon() {
        return this.icon;
    }

    public abstract boolean hasSubItems();

    public abstract Item[] getActivatableSubItems();

    public abstract Item getActiveSubItem();

    public final boolean isActive() {
        return this.active;
    }

    public abstract boolean isTopItem();

    public abstract boolean isParentOf(Item var1);

    private static String extractDisplayName(TopComponent topComponent) {
        String string = topComponent.getShortName();
        if (string == null || string.isEmpty()) {
            string = topComponent.getHtmlDisplayName();
        }
        if (string == null || string.isEmpty()) {
            string = topComponent.getDisplayName();
        }
        if (string == null || string.isEmpty()) {
            string = topComponent.getName();
        }
        return string;
    }

    private static Icon extractIcon(TopComponent topComponent) {
        Image image = topComponent.getIcon();
        if (null != image) {
            return ImageUtilities.image2Icon((Image)image);
        }
        return null;
    }

    private static class SubItem
    extends Item {
        private final TopComponent.SubComponent subComponent;
        private final TopComponent parent;

        public SubItem(TopComponent topComponent, TopComponent.SubComponent subComponent) {
            super(subComponent.getDisplayName(), subComponent.getDescription(), null, subComponent.isActive());
            this.subComponent = subComponent;
            this.parent = topComponent;
        }

        @Override
        public void activate() {
            this.parent.requestActive();
            this.subComponent.activate();
        }

        @Override
        public boolean hasSubItems() {
            return false;
        }

        @Override
        public boolean isTopItem() {
            return false;
        }

        @Override
        public Item[] getActivatableSubItems() {
            return null;
        }

        @Override
        public Item getActiveSubItem() {
            return null;
        }

        @Override
        public boolean isParentOf(Item item) {
            return false;
        }
    }

    private static class TopItem
    extends Item {
        private final TopComponent tc;
        private final Item[] subItems;
        private final Item activeSubItem;

        public TopItem(TopComponent topComponent) {
            super(Item.extractDisplayName(topComponent), topComponent.getToolTipText(), Item.extractIcon(topComponent), false);
            this.tc = topComponent;
            Item[] itemArray = null;
            SubItem subItem = null;
            TopComponent.SubComponent[] subComponentArray = topComponent.getSubComponents();
            if (null != subComponentArray && subComponentArray.length > 0) {
                for (TopComponent.SubComponent subComponent : subComponentArray) {
                    if (!subComponent.isActive()) continue;
                    subItem = new SubItem(topComponent, subComponent);
                    break;
                }
                itemArray = new Item[null == subItem ? subComponentArray.length : subComponentArray.length - 1];
                int n = 0;
                for (TopComponent.SubComponent subComponent : subComponentArray) {
                    if (subComponent.isActive()) continue;
                    itemArray[n++] = new SubItem(topComponent, subComponent);
                }
            }
            this.subItems = itemArray;
            this.activeSubItem = subItem;
        }

        @Override
        public void activate() {
            this.tc.requestActive();
        }

        @Override
        public boolean hasSubItems() {
            return null != this.subItems;
        }

        @Override
        public Item[] getActivatableSubItems() {
            return this.subItems;
        }

        @Override
        public boolean isTopItem() {
            return true;
        }

        @Override
        public Item getActiveSubItem() {
            return this.activeSubItem;
        }

        @Override
        public boolean isParentOf(Item item) {
            if (null != this.subItems) {
                for (Item item2 : this.subItems) {
                    if (item2 != item) continue;
                    return true;
                }
            }
            return null != item && item == this.activeSubItem;
        }
    }
}

