/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java.com.lowagie.text;

import com.gitlab.pdftk_java.com.lowagie.text.Chunk;
import com.gitlab.pdftk_java.com.lowagie.text.DocumentException;
import com.gitlab.pdftk_java.com.lowagie.text.ExceptionConverter;
import com.gitlab.pdftk_java.com.lowagie.text.Font;
import com.gitlab.pdftk_java.com.lowagie.text.markup.MarkupParser;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FontFactory {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES = "Times";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    private static Properties trueTypeFonts = new Properties();
    private static String[] TTFamilyOrder = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};
    private static Hashtable fontFamilies;
    public static String defaultEncoding;
    public static boolean defaultEmbedding;

    private FontFactory() {
    }

    public static Font getFont(String fontname, String encoding, boolean embedded, float size, int style, Color color) {
        if (fontname == null) {
            return new Font(-1, size, style, color);
        }
        String lowercasefontname = fontname.toLowerCase();
        ArrayList tmp = (ArrayList)fontFamilies.get(lowercasefontname);
        if (tmp != null) {
            int s = style == -1 ? 0 : style;
            int fs = 0;
            boolean found = false;
            for (String f : tmp) {
                String lcf = f.toLowerCase();
                fs = 0;
                if (lcf.toLowerCase().indexOf("bold") != -1) {
                    fs |= 1;
                }
                if (lcf.toLowerCase().indexOf("italic") != -1 || lcf.toLowerCase().indexOf("oblique") != -1) {
                    fs |= 2;
                }
                if ((s & 3) != fs) continue;
                fontname = f;
                found = true;
                break;
            }
            if (style != -1 && found) {
                style &= ~fs;
            }
        }
        BaseFont basefont = null;
        try {
            try {
                basefont = BaseFont.createFont(fontname, encoding, embedded);
            }
            catch (DocumentException de) {
                fontname = trueTypeFonts.getProperty(fontname.toLowerCase());
                if (fontname == null) {
                    return new Font(-1, size, style, color);
                }
                basefont = BaseFont.createFont(fontname, encoding, embedded);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            return new Font(-1, size, style, color);
        }
        catch (NullPointerException npe) {
            return new Font(-1, size, style, color);
        }
        return new Font(basefont, size, style, color);
    }

    public static Font getFont(Properties attributes) {
        String fontname = null;
        String encoding = defaultEncoding;
        boolean embedded = defaultEmbedding;
        float size = -1.0f;
        int style = 0;
        Color color = null;
        String value = (String)attributes.remove("style");
        if (value != null && value.length() > 0) {
            Properties styleAttributes = MarkupParser.parseAttributes(value);
            if (styleAttributes.size() == 0) {
                attributes.put("style", value);
            } else {
                fontname = (String)styleAttributes.remove("font-family");
                if (fontname != null) {
                    while (fontname.indexOf(",") != -1) {
                        String tmp = fontname.substring(0, fontname.indexOf(","));
                        if (FontFactory.isRegistered(tmp)) {
                            fontname = tmp;
                            continue;
                        }
                        fontname = fontname.substring(fontname.indexOf(",") + 1);
                    }
                }
                if ((value = (String)styleAttributes.remove("font-size")) != null) {
                    size = MarkupParser.parseLength(value);
                }
                if ((value = (String)styleAttributes.remove("font-weight")) != null) {
                    style |= Font.getStyleValue(value);
                }
                if ((value = (String)styleAttributes.remove("font-style")) != null) {
                    style |= Font.getStyleValue(value);
                }
                if ((value = (String)styleAttributes.remove("color")) != null) {
                    color = MarkupParser.decodeColor(value);
                }
                attributes.putAll((Map<?, ?>)styleAttributes);
                Enumeration<Object> e = styleAttributes.keys();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    attributes.put(o, styleAttributes.get(o));
                }
            }
        }
        if ((value = (String)attributes.remove("encoding")) != null) {
            encoding = value;
        }
        if ("true".equals(attributes.remove("embedded"))) {
            embedded = true;
        }
        if ((value = (String)attributes.remove("font")) != null) {
            fontname = value;
        }
        if ((value = (String)attributes.remove("size")) != null) {
            size = Float.valueOf(value + "f").floatValue();
        }
        if ((value = (String)attributes.remove("style")) != null) {
            style |= Font.getStyleValue(value);
        }
        if ((value = (String)attributes.remove("fontstyle")) != null) {
            style |= Font.getStyleValue(value);
        }
        String r = (String)attributes.remove("red");
        String g = (String)attributes.remove("green");
        String b = (String)attributes.remove("blue");
        if (r != null || g != null || b != null) {
            int red = 0;
            int green = 0;
            int blue = 0;
            if (r != null) {
                red = Integer.parseInt(r);
            }
            if (g != null) {
                green = Integer.parseInt(g);
            }
            if (b != null) {
                blue = Integer.parseInt(b);
            }
            color = new Color(red, green, blue);
        } else {
            value = (String)attributes.remove("color");
            if (value != null) {
                color = MarkupParser.decodeColor(value);
            }
        }
        if (fontname == null) {
            return FontFactory.getFont(null, encoding, embedded, size, style, color);
        }
        return FontFactory.getFont(fontname, encoding, embedded, size, style, color);
    }

    public static Font getFont(String fontname, String encoding, boolean embedded, float size, int style) {
        return FontFactory.getFont(fontname, encoding, embedded, size, style, null);
    }

    public static Font getFont(String fontname, String encoding, boolean embedded, float size) {
        return FontFactory.getFont(fontname, encoding, embedded, size, -1, null);
    }

    public static Font getFont(String fontname, String encoding, boolean embedded) {
        return FontFactory.getFont(fontname, encoding, embedded, -1.0f, -1, null);
    }

    public static Font getFont(String fontname, String encoding, float size, int style, Color color) {
        return FontFactory.getFont(fontname, encoding, defaultEmbedding, size, style, color);
    }

    public static Font getFont(String fontname, String encoding, float size, int style) {
        return FontFactory.getFont(fontname, encoding, defaultEmbedding, size, style, null);
    }

    public static Font getFont(String fontname, String encoding, float size) {
        return FontFactory.getFont(fontname, encoding, defaultEmbedding, size, -1, null);
    }

    public static Font getFont(String fontname, String encoding) {
        return FontFactory.getFont(fontname, encoding, defaultEmbedding, -1.0f, -1, null);
    }

    public static Font getFont(String fontname, float size, int style, Color color) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, size, style, color);
    }

    public static Font getFont(String fontname, float size, int style) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, size, style, null);
    }

    public static Font getFont(String fontname, float size) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, size, -1, null);
    }

    public static Font getFont(String fontname) {
        return FontFactory.getFont(fontname, defaultEncoding, defaultEmbedding, -1.0f, -1, null);
    }

    public static void register(String path) {
        FontFactory.register(path, null);
    }

    public static void register(String path, String alias) {
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().endsWith(".otf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                int i;
                Object[] allNames = BaseFont.getAllFontNames(path, "Cp1252", null);
                trueTypeFonts.setProperty(((String)allNames[0]).toLowerCase(), path);
                if (alias != null) {
                    trueTypeFonts.setProperty(alias, path);
                }
                String[][] names = (String[][])allNames[2];
                for (int i2 = 0; i2 < names.length; ++i2) {
                    trueTypeFonts.setProperty(names[i2][3].toLowerCase(), path);
                }
                String fullName = null;
                String familyName = null;
                names = (String[][])allNames[1];
                block4: for (int k = 0; k < TTFamilyOrder.length; k += 3) {
                    for (i = 0; i < names.length; ++i) {
                        if (!TTFamilyOrder[k].equals(names[i][0]) || !TTFamilyOrder[k + 1].equals(names[i][1]) || !TTFamilyOrder[k + 2].equals(names[i][2])) continue;
                        familyName = names[i][3].toLowerCase();
                        k = TTFamilyOrder.length;
                        continue block4;
                    }
                }
                if (familyName != null) {
                    String lastName = "";
                    names = (String[][])allNames[2];
                    block6: for (i = 0; i < names.length; ++i) {
                        for (int k = 0; k < TTFamilyOrder.length; k += 3) {
                            if (!TTFamilyOrder[k].equals(names[i][0]) || !TTFamilyOrder[k + 1].equals(names[i][1]) || !TTFamilyOrder[k + 2].equals(names[i][2]) || (fullName = names[i][3]).equals(lastName)) continue;
                            lastName = fullName;
                            ArrayList<String> tmp = (ArrayList<String>)fontFamilies.get(familyName);
                            if (tmp == null) {
                                tmp = new ArrayList<String>();
                                tmp.add(fullName);
                                fontFamilies.put(familyName, tmp);
                                continue block6;
                            }
                            int fullNameLength = fullName.length();
                            boolean inserted = false;
                            for (int j = 0; j < tmp.size(); ++j) {
                                if (((String)tmp.get(j)).length() < fullNameLength) continue;
                                tmp.add(j, fullName);
                                inserted = true;
                                break;
                            }
                            if (inserted) continue block6;
                            tmp.add(fullName);
                            continue block6;
                        }
                    }
                }
            } else if (path.toLowerCase().endsWith(".ttc")) {
                if (alias != null) {
                    System.err.println("class FontFactory: You can't define an alias for a true type collection.");
                }
                String[] names = BaseFont.enumerateTTCNames(path);
                for (int i = 0; i < names.length; ++i) {
                    FontFactory.register(path + "," + i);
                }
            } else if (path.toLowerCase().endsWith(".afm")) {
                BaseFont bf = BaseFont.createFont(path, "Cp1252", false);
                trueTypeFonts.setProperty(bf.getPostscriptFontName().toLowerCase(), path);
                trueTypeFonts.setProperty(bf.getFullFontName()[0][3].toLowerCase(), path);
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public static int registerDirectory(String dir) {
        int count = 0;
        try {
            File file = new File(dir);
            if (!file.exists() || !file.isDirectory()) {
                return 0;
            }
            String[] files = file.list();
            if (files == null) {
                return 0;
            }
            for (int k = 0; k < files.length; ++k) {
                try {
                    file = new File(dir, files[k]);
                    if (file.isDirectory()) {
                        FontFactory.registerDirectory(file.getPath());
                        continue;
                    }
                    String name = file.getPath().toLowerCase();
                    if (!name.endsWith(".ttf") && !name.endsWith(".otf") && !name.endsWith(".afm") && !name.endsWith(".ttc")) continue;
                    FontFactory.register(file.getPath(), null);
                    ++count;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static int registerDirectories() {
        int count = 0;
        count += FontFactory.registerDirectory("c:/windows/fonts");
        count += FontFactory.registerDirectory("c:/winnt/fonts");
        count += FontFactory.registerDirectory("d:/windows/fonts");
        count += FontFactory.registerDirectory("d:/winnt/fonts");
        count += FontFactory.registerDirectory("/usr/X/lib/X11/fonts/TrueType");
        count += FontFactory.registerDirectory("/usr/openwin/lib/X11/fonts/TrueType");
        count += FontFactory.registerDirectory("/usr/share/fonts");
        return count += FontFactory.registerDirectory("/usr/X11R6/lib/X11/fonts/ttf");
    }

    public static Set getRegisteredFonts() {
        return Chunk.getKeySet(trueTypeFonts);
    }

    public static Set getRegisteredFamilies() {
        return Chunk.getKeySet(fontFamilies);
    }

    public static boolean contains(String fontname) {
        return trueTypeFonts.containsKey(fontname.toLowerCase());
    }

    public static boolean isRegistered(String fontname) {
        return trueTypeFonts.containsKey(fontname.toLowerCase());
    }

    static {
        trueTypeFonts.setProperty(COURIER.toLowerCase(), COURIER);
        trueTypeFonts.setProperty(COURIER_BOLD.toLowerCase(), COURIER_BOLD);
        trueTypeFonts.setProperty(COURIER_OBLIQUE.toLowerCase(), COURIER_OBLIQUE);
        trueTypeFonts.setProperty(COURIER_BOLDOBLIQUE.toLowerCase(), COURIER_BOLDOBLIQUE);
        trueTypeFonts.setProperty(HELVETICA.toLowerCase(), HELVETICA);
        trueTypeFonts.setProperty(HELVETICA_BOLD.toLowerCase(), HELVETICA_BOLD);
        trueTypeFonts.setProperty(HELVETICA_OBLIQUE.toLowerCase(), HELVETICA_OBLIQUE);
        trueTypeFonts.setProperty(HELVETICA_BOLDOBLIQUE.toLowerCase(), HELVETICA_BOLDOBLIQUE);
        trueTypeFonts.setProperty(SYMBOL.toLowerCase(), SYMBOL);
        trueTypeFonts.setProperty(TIMES_ROMAN.toLowerCase(), TIMES_ROMAN);
        trueTypeFonts.setProperty(TIMES_BOLD.toLowerCase(), TIMES_BOLD);
        trueTypeFonts.setProperty(TIMES_ITALIC.toLowerCase(), TIMES_ITALIC);
        trueTypeFonts.setProperty(TIMES_BOLDITALIC.toLowerCase(), TIMES_BOLDITALIC);
        trueTypeFonts.setProperty(ZAPFDINGBATS.toLowerCase(), ZAPFDINGBATS);
        fontFamilies = new Hashtable();
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(COURIER);
        tmp.add(COURIER_BOLD);
        tmp.add(COURIER_OBLIQUE);
        tmp.add(COURIER_BOLDOBLIQUE);
        fontFamilies.put(COURIER.toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add(HELVETICA);
        tmp.add(HELVETICA_BOLD);
        tmp.add(HELVETICA_OBLIQUE);
        tmp.add(HELVETICA_BOLDOBLIQUE);
        fontFamilies.put(HELVETICA.toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add(SYMBOL);
        fontFamilies.put(SYMBOL.toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add(TIMES_ROMAN);
        tmp.add(TIMES_BOLD);
        tmp.add(TIMES_ITALIC);
        tmp.add(TIMES_BOLDITALIC);
        fontFamilies.put(TIMES.toLowerCase(), tmp);
        fontFamilies.put(TIMES_ROMAN.toLowerCase(), tmp);
        tmp = new ArrayList();
        tmp.add(ZAPFDINGBATS);
        fontFamilies.put(ZAPFDINGBATS.toLowerCase(), tmp);
        defaultEncoding = "Cp1252";
        defaultEmbedding = false;
    }
}

