/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config;

import com.oracle.labs.mlrg.olcut.config.ArgumentException;
import com.oracle.labs.mlrg.olcut.config.ComponentListener;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.ConfigurableName;
import com.oracle.labs.mlrg.olcut.config.ConfigurationData;
import com.oracle.labs.mlrg.olcut.config.FieldType;
import com.oracle.labs.mlrg.olcut.config.InternalConfigurationException;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.config.PropertySheet;
import com.oracle.labs.mlrg.olcut.config.SerializedObject;
import com.oracle.labs.mlrg.olcut.config.Startable;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoaderException;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriter;
import com.oracle.labs.mlrg.olcut.config.io.ConfigWriterException;
import com.oracle.labs.mlrg.olcut.config.io.FileFormatFactory;
import com.oracle.labs.mlrg.olcut.config.io.URLLoader;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperties;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperty;
import com.oracle.labs.mlrg.olcut.config.property.ImmutableGlobalProperties;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import com.oracle.labs.mlrg.olcut.config.xml.XMLConfigFactory;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.MBeanServer;

public class ConfigurationManager
implements Closeable {
    private static final Logger logger = Logger.getLogger(ConfigurationManager.class.getName());
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    public static final Option configFileOption = new Option(){

        @Override
        public String longName() {
            return "config-file";
        }

        @Override
        public char charName() {
            return 'c';
        }

        @Override
        public String usage() {
            return "A comma separated list of OLCUT config files.";
        }

        public Class<? extends Option> annotationType() {
            return Option.class;
        }
    };
    public static final Function<String, Option> defaultConfigOptionFunction = path -> new Option((String)path){
        final /* synthetic */ String val$path;
        {
            this.val$path = string;
        }

        @Override
        public char charName() {
            return '\u0000';
        }

        @Override
        public String longName() {
            return "";
        }

        @Override
        public String usage() {
            return "Default configuration is loaded from '" + this.val$path + "'.";
        }

        public Class<? extends Option> annotationType() {
            return Option.class;
        }
    };
    public static final Option fileFormatOption = new Option(){

        @Override
        public String longName() {
            return "config-file-formats";
        }

        @Override
        public char charName() {
            return '\u0000';
        }

        @Override
        public String usage() {
            return "A comma separated list of OLCUT FileFormatFactory implementations (assumed to be on the classpath).";
        }

        public Class<? extends Option> annotationType() {
            return Option.class;
        }
    };
    public static final Option usageOption = new Option(){

        @Override
        public String longName() {
            return "usage";
        }

        @Override
        public char charName() {
            return '\u0000';
        }

        @Override
        public String usage() {
            return "Write out this usage/help statement.";
        }

        public Class<? extends Option> annotationType() {
            return Option.class;
        }
    };
    public static final Option helpOption = new Option(){

        @Override
        public String longName() {
            return "help";
        }

        @Override
        public char charName() {
            return '\u0000';
        }

        @Override
        public String usage() {
            return "Write out this usage/help statement.";
        }

        public Class<? extends Option> annotationType() {
            return Option.class;
        }
    };
    public static final char ARG_DELIMITER = ',';
    public static final char UNIX_ESCAPE_CHAR = '\\';
    public static final char WIN_ESCAPE_CHAR = '^';
    @Deprecated
    public static final char ESCAPE_CHAR = '\\';
    public static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static final char CUR_ESCAPE_CHAR = (char)(IS_WINDOWS ? 94 : 92);
    public static final char CONFIGURABLE_CHAR = '@';
    public static final String SHORT_ARG = "-";
    public static final String LONG_ARG = "--";
    public static final String CONFIGURABLE_OVERRIDE = "--@";
    public static final Options EMPTY_OPTIONS = new Options(){};
    private static final Map<String, FileFormatFactory> formatFactoryMap = Collections.synchronizedMap(new HashMap());
    protected final Map<String, PropertySheet<? extends Configurable>> symbolTable;
    protected final Map<ConfigWrapper, PropertySheet<? extends Configurable>> configuredComponents = new LinkedHashMap<ConfigWrapper, PropertySheet<? extends Configurable>>();
    protected final Map<String, ConfigurationData> configurationDataMap;
    protected final IdentityHashMap<Configurable, String> configurationNameMap;
    protected final GlobalProperties globalProperties;
    protected final Map<String, SerializedObject> serializedObjects;
    protected final GlobalProperties origGlobal;
    protected final boolean showCreations;
    private final LinkedList<URL> configURLs = new LinkedList();
    private String[] unnamedArguments = new String[0];
    private String usage;
    private MBeanServer mbs;

    public ConfigurationManager() throws PropertyException, ConfigLoaderException {
        this(new String[0]);
    }

    public ConfigurationManager(String path) throws PropertyException, ConfigLoaderException {
        this(new String[]{SHORT_ARG + configFileOption.charName(), path}, EMPTY_OPTIONS);
    }

    public ConfigurationManager(URL url) throws PropertyException, ConfigLoaderException {
        this(new String[]{SHORT_ARG + configFileOption.charName(), url.toString()}, EMPTY_OPTIONS);
    }

    public ConfigurationManager(List<String> configFilePaths) throws PropertyException, ConfigLoaderException {
        this(ConfigurationManager.createConfigFileList(configFilePaths), EMPTY_OPTIONS);
    }

    public ConfigurationManager(String[] arguments) throws UsageException, ArgumentException, PropertyException, ConfigLoaderException {
        this(arguments, EMPTY_OPTIONS);
    }

    public ConfigurationManager(String[] arguments, String defaultConfigPath) throws UsageException, ArgumentException, PropertyException, ConfigLoaderException {
        this(arguments, EMPTY_OPTIONS, defaultConfigPath, true);
    }

    public ConfigurationManager(String[] arguments, Options options) throws UsageException, ArgumentException, PropertyException, ConfigLoaderException {
        this(arguments, options, true);
    }

    public ConfigurationManager(String[] arguments, Options options, boolean useConfigFiles) throws UsageException, ArgumentException, PropertyException, ConfigLoaderException {
        this(arguments, options, "", useConfigFiles);
    }

    public ConfigurationManager(String[] arguments, Options options, String defaultConfigPath, boolean useConfigFiles) throws UsageException, ArgumentException, PropertyException, ConfigLoaderException {
        this(arguments, Collections.emptyList(), options, defaultConfigPath, useConfigFiles);
    }

    public ConfigurationManager(String[] arguments, List<ConfigurationData> configData, Options options, String defaultConfigPath, boolean useConfigFiles) throws UsageException, ArgumentException, PropertyException, ConfigLoaderException {
        List<URL> urls;
        this.usage = ConfigurationManager.validateOptions(options, defaultConfigPath, useConfigFiles);
        this.symbolTable = new LinkedHashMap<String, PropertySheet<? extends Configurable>>();
        if (arguments.length == 1 && (arguments[0].equals(LONG_ARG + usageOption.longName()) || arguments[0].equals(LONG_ARG + helpOption.longName()))) {
            throw new UsageException(this.usage);
        }
        LinkedList<String> argumentsList = new LinkedList<String>(Arrays.asList(arguments));
        if (useConfigFiles) {
            urls = ConfigurationManager.parseConfigFiles(argumentsList);
            if (urls.isEmpty() && defaultConfigPath != null && !defaultConfigPath.isEmpty()) {
                urls.add(ConfigurationManager.findURL(defaultConfigPath, "default-config-file"));
            }
        } else {
            urls = new ArrayList<URL>();
        }
        this.configURLs.addAll(urls);
        URLLoader loader = new URLLoader(this.configURLs, formatFactoryMap);
        loader.load();
        this.configurationDataMap = loader.getPropertyMap();
        this.configurationNameMap = new IdentityHashMap();
        this.globalProperties = loader.getGlobalProperties();
        this.serializedObjects = new HashMap<String, SerializedObject>();
        for (Map.Entry<String, SerializedObject> e : loader.getSerializedObjects().entrySet()) {
            e.getValue().setConfigurationManager(this);
            this.serializedObjects.put(e.getKey(), e.getValue());
        }
        this.origGlobal = new GlobalProperties(this.globalProperties);
        for (ConfigurationData cd : configData) {
            String instanceName = cd.getName();
            if (this.symbolTable.containsKey(instanceName)) {
                logger.fine("Overwriting " + instanceName + " loaded from file.");
            }
            this.configurationDataMap.put(instanceName, cd);
        }
        this.parseConfigurableArguments(argumentsList);
        this.globalProperties.importSystemProperties();
        GlobalProperty sC = this.globalProperties.get("showCreations");
        this.showCreations = sC != null ? Boolean.parseBoolean(sC.getValue()) : false;
        try {
            this.unnamedArguments = AccessController.doPrivileged(() -> this.parseOptionArguments(argumentsList, options));
        }
        catch (PrivilegedActionException e) {
            Exception inner = e.getException();
            if (inner instanceof IllegalAccessException) {
                throw new ArgumentException(e, "Failed to write argument into Options");
            }
            if (inner instanceof InstantiationException || inner instanceof NoSuchMethodException || inner instanceof InvocationTargetException) {
                throw new ArgumentException(e, "Failed to instantiate a field of Options.");
            }
            throw new ArgumentException(inner, "Unexpected exception thrown when reading arguments - " + inner.getMessage());
        }
        catch (PropertyException e) {
            throw new ArgumentException(e, e.getMessage() + "\n\n" + this.usage);
        }
    }

    private ConfigurationManager(Map<String, ConfigurationData> newrpm, GlobalProperties newgp, Map<String, PropertySheet<? extends Configurable>> newSymbolTable, Map<String, SerializedObject> newSerializedObjects, GlobalProperties newOrigGlobal) {
        this.configurationDataMap = newrpm;
        this.configurationNameMap = new IdentityHashMap();
        this.globalProperties = newgp;
        this.symbolTable = newSymbolTable;
        this.serializedObjects = newSerializedObjects;
        this.origGlobal = newOrigGlobal;
        GlobalProperty sC = this.globalProperties.get("showCreations");
        this.showCreations = sC != null ? Boolean.parseBoolean(sC.getValue()) : false;
    }

    private static String[] createConfigFileList(List<String> configFiles) {
        StringBuilder sb = new StringBuilder();
        for (String s : configFiles) {
            sb.append(s);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return new String[]{SHORT_ARG + configFileOption.charName(), sb.toString()};
    }

    public static void addFileFormatFactory(FileFormatFactory f) {
        formatFactoryMap.put(f.getExtension(), f);
    }

    public static FileFormatFactory getFileFormatFactory(String extension) {
        return formatFactoryMap.get(extension);
    }

    public static String validateOptions(Options options, boolean useConfigFiles) throws ArgumentException {
        return ConfigurationManager.validateOptions(options, "", useConfigFiles);
    }

    public static String validateOptions(Options options, String defaultConfigPath, boolean useConfigFiles) throws ArgumentException {
        HashSet<Field> optionFields = new HashSet<Field>();
        Set<Class<? extends Options>> allOptions = Options.getAllOptions(options.getClass());
        StringBuilder builder = new StringBuilder();
        builder.append("Usage:\n\n");
        ArrayList<List<String>> usageList = new ArrayList<List<String>>();
        usageList.add(new ArrayList<String>(Collections.singletonList("Built-in Options")));
        usageList.add(Options.header);
        if (useConfigFiles) {
            usageList.add(Options.getOptionUsage(configFileOption, "java.lang.String"));
            if (defaultConfigPath != null && !defaultConfigPath.isEmpty()) {
                usageList.add(Options.getOptionUsage(defaultConfigOptionFunction.apply(defaultConfigPath), "java.lang.String"));
            }
            usageList.add(Options.getOptionUsage(fileFormatOption, "java.lang.String"));
        }
        usageList.add(Options.getOptionUsage(usageOption, ""));
        for (Class<? extends Options> o : allOptions) {
            usageList.addAll(Options.getUsage(o));
            optionFields.addAll(Options.getOptionFields(o));
        }
        builder.append(Options.formatUsage(usageList));
        HashMap<Character, Option> charNameMap = new HashMap<Character, Option>();
        HashMap<String, Option> longNameMap = new HashMap<String, Option>();
        if (useConfigFiles) {
            charNameMap.put(Character.valueOf(configFileOption.charName()), configFileOption);
            longNameMap.put(configFileOption.longName(), configFileOption);
            longNameMap.put(fileFormatOption.longName(), fileFormatOption);
        }
        longNameMap.put(usageOption.longName(), usageOption);
        longNameMap.put(helpOption.longName(), helpOption);
        for (Field f : optionFields) {
            Option annotation = f.getAnnotation(Option.class);
            FieldType ft = FieldType.getFieldType(f);
            char charName = annotation.charName();
            String longName = annotation.longName();
            if (ft == null) {
                throw new ArgumentException(longName, "Argument has an unsupported type " + f.getType().getName());
            }
            if (!useConfigFiles) {
                if (FieldType.configurableTypes.contains((Object)ft)) {
                    throw new ArgumentException(longName, "Argument has a Configurable type, which requires using a config file.");
                }
                if (FieldType.listTypes.contains((Object)ft)) {
                    List<Class<?>> list = PropertySheet.getGenericClass(f);
                    if (list.size() == 1) {
                        Class<?> genericClazz = list.get(0);
                        FieldType genericFieldType = FieldType.getFieldType(genericClazz);
                        if (FieldType.configurableTypes.contains((Object)genericFieldType)) {
                            throw new ArgumentException(longName, "Argument has a Configurable type, which requires using a config file.");
                        }
                    } else {
                        throw new ArgumentException(longName, "Failed to parse the type parameters of the argument.");
                    }
                }
            }
            if (charName == '-' || charName == ' ') {
                throw new ArgumentException(longName, "'-' and ' ' are reserved characters.");
            }
            if (longName.startsWith("@")) {
                throw new ArgumentException(longName, "Arguments starting '--@' are reserved for the configuration system.");
            }
            if (longName.startsWith(SHORT_ARG)) {
                throw new ArgumentException(longName, "Arguments must not start with '-'");
            }
            if (WHITESPACE.matcher(longName).matches()) {
                throw new ArgumentException("'" + longName + "'", "Arguments must not contain whitespace.");
            }
            if (charName != '\u0000' && charNameMap.containsKey(Character.valueOf(charName))) {
                if (charName == configFileOption.charName() && useConfigFiles) {
                    throw new ArgumentException("config-file", longName, "The -" + configFileOption.charName() + " argument is reserved for the configuration system");
                }
                throw new ArgumentException(((Option)charNameMap.get(Character.valueOf(charName))).longName(), longName, "Two arguments have the same character");
            }
            if (longNameMap.containsKey(longName)) {
                throw new ArgumentException(((Option)longNameMap.get(longName)).longName(), longName, "Two arguments have the same long name");
            }
            charNameMap.put(Character.valueOf(charName), annotation);
            longNameMap.put(longName, annotation);
        }
        return builder.toString();
    }

    private static boolean parseableAsBoolean(String input) {
        String lowercase = input.toLowerCase();
        return lowercase.equals("false") || lowercase.equals("true");
    }

    private static URL findURL(String input, String argumentName) {
        return AccessController.doPrivileged(() -> {
            URL url = ConfigurationManager.class.getResource(input);
            if (url == null) {
                File file = new File(input);
                if (file.exists()) {
                    try {
                        url = file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new ArgumentException(e, argumentName, "Can't load config file: " + input);
                    }
                }
                try {
                    url = new URI(input).toURL();
                }
                catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                    throw new ArgumentException(argumentName, "Can't find config file: " + input);
                }
            }
            if (IOUtil.isDisallowedProtocol(url)) {
                throw new ConfigLoaderException("Unable to load configurations from URLs with protocol: " + url.getProtocol());
            }
            return url;
        });
    }

    private void parseConfigurableArguments(List<String> arguments) throws ArgumentException {
        Iterator<String> argsItr = arguments.iterator();
        while (argsItr.hasNext()) {
            String curArg = argsItr.next();
            if (!curArg.startsWith(CONFIGURABLE_OVERRIDE)) continue;
            String[] split = curArg.substring(3).split("\\.");
            if (split.length == 2) {
                ConfigurationData rpd = this.configurationDataMap.get(split[0]);
                if (rpd != null) {
                    if (this.checkConfigurableField(rpd.getClassName(), split[1])) {
                        argsItr.remove();
                        if (argsItr.hasNext()) {
                            String param = argsItr.next();
                            List<String> list = ConfigurationManager.parseStringList(param);
                            if (list.size() == 1) {
                                rpd.add(split[1], new SimpleProperty(list.get(0)));
                            } else {
                                rpd.add(split[1], ListProperty.createFromStringList(list));
                            }
                            argsItr.remove();
                            continue;
                        }
                        throw new ArgumentException(curArg, "No parameter for configurable override argument");
                    }
                    throw new ArgumentException(curArg, "Failed to find field " + split[1] + " in component " + split[0] + " with class " + rpd.getClassName());
                }
                throw new ArgumentException(curArg, "Failed to find component " + split[0]);
            }
            if (split.length == 1) {
                argsItr.remove();
                if (argsItr.hasNext()) {
                    String param = argsItr.next();
                    this.globalProperties.setValue(split[0], param);
                    argsItr.remove();
                    continue;
                }
                throw new ArgumentException(curArg, "No parameter for global property argument");
            }
            throw new ArgumentException(curArg, "Failed to parse configuration override argument");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] parseOptionArguments(List<String> arguments, Options options) throws ArgumentException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        HashMap<String, Pair<Field, Options>> longNameMap = new HashMap<String, Pair<Field, Options>>();
        HashMap<Character, Pair<Field, Options>> charNameMap = new HashMap<Character, Pair<Field, Options>>();
        arguments = new ArrayList<String>(arguments);
        LinkedList<Options> objectQueue = new LinkedList<Options>();
        objectQueue.add(options);
        while (!objectQueue.isEmpty()) {
            Options o = (Options)objectQueue.poll();
            Set<Field> fields = Options.getOptionFields(o.getClass());
            for (Field f : fields) {
                Option ann = f.getAnnotation(Option.class);
                longNameMap.put(ann.longName(), new Pair<Field, Options>(f, o));
                if (ann.charName() == '\u0000') continue;
                charNameMap.put(Character.valueOf(ann.charName()), new Pair<Field, Options>(f, o));
            }
            fields = Options.getOptions(o.getClass());
            for (Field f : fields) {
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                if (f.get(o) != null) {
                    logger.fine("Warning: overwriting Options field.");
                }
                f.set(o, f.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                objectQueue.add((Options)f.get(o));
                f.setAccessible(accessible);
            }
        }
        int i = 0;
        while (true) {
            boolean consumed;
            block32: {
                boolean accessible;
                Field f;
                block30: {
                    FieldType ft;
                    Pair arg;
                    char[] args;
                    List<Class<?>> genericList;
                    List<String> list;
                    String param;
                    String curArg;
                    block33: {
                        boolean accessible2;
                        block31: {
                            if (i >= arguments.size()) {
                                return arguments.toArray(new String[0]);
                            }
                            consumed = false;
                            curArg = arguments.get(i);
                            if (!curArg.startsWith(LONG_ARG)) break block31;
                            String argName = curArg.substring(2);
                            Pair arg2 = (Pair)longNameMap.get(argName);
                            if (arg2 == null) {
                                throw new ArgumentException(curArg, "Unknown argument.");
                            }
                            f = (Field)arg2.getA();
                            FieldType ft2 = FieldType.getFieldType(f);
                            arguments.remove(i);
                            consumed = true;
                            if (i >= arguments.size()) {
                                throw new ArgumentException(curArg, "No parameter for argument");
                            }
                            accessible2 = f.isAccessible();
                            f.setAccessible(true);
                            param = arguments.get(i);
                            list = ConfigurationManager.parseStringList(param);
                            if (FieldType.arrayTypes.contains((Object)ft2)) {
                                f.set(arg2.getB(), PropertySheet.parseArrayField(this, curArg, f.getName(), f.getType(), ft2, ListProperty.createFromStringList(list)));
                            } else if (FieldType.listTypes.contains((Object)ft2)) {
                                genericList = PropertySheet.getGenericClass(f);
                                if (genericList.size() != 1) {
                                    f.setAccessible(accessible2);
                                    throw new ArgumentException(curArg, "Unknown generic type in argument");
                                }
                                f.set(arg2.getB(), PropertySheet.parseListField(this, curArg, f.getName(), f.getType(), genericList.get(0), ft2, ListProperty.createFromStringList(list)));
                            } else {
                                if (list.size() != 1) {
                                    f.setAccessible(accessible2);
                                    throw new ArgumentException(curArg, "Parsed a list where a single argument was expected. Type = " + f.getType() + ", parsed output = " + list.toString());
                                }
                                f.set(arg2.getB(), PropertySheet.parseSimpleField(this, curArg, f.getName(), f.getType(), ft2, list.get(0)));
                            }
                            arguments.remove(i);
                            f.setAccessible(accessible2);
                            break block32;
                        }
                        if (!curArg.startsWith(SHORT_ARG)) break block32;
                        args = curArg.substring(1).toCharArray();
                        if (args.length <= 0) {
                            throw new ArgumentException(curArg, "Empty argument found.");
                        }
                        arguments.remove(i);
                        consumed = true;
                        for (int j = 0; j < args.length - 1; ++j) {
                            Pair arg3 = (Pair)charNameMap.get(Character.valueOf(args[j]));
                            if (arg3 == null) {
                                throw new ArgumentException(curArg + " on element " + args[j], "Unknown argument");
                            }
                            Field f2 = (Field)arg3.getA();
                            accessible2 = f2.isAccessible();
                            f2.setAccessible(true);
                            FieldType ft3 = FieldType.getFieldType(f2);
                            if (!FieldType.isBoolean(ft3)) {
                                f2.setAccessible(accessible2);
                                throw new ArgumentException(curArg + " on element " + args[j], "Non boolean argument found where boolean expected");
                            }
                            f2.set(arg3.getB(), true);
                            f2.setAccessible(accessible2);
                        }
                        arg = (Pair)charNameMap.get(Character.valueOf(args[args.length - 1]));
                        if (arg == null) break block32;
                        f = (Field)arg.getA();
                        accessible = f.isAccessible();
                        f.setAccessible(true);
                        ft = FieldType.getFieldType(f);
                        if (!FieldType.isBoolean(ft)) break block33;
                        if (i < arguments.size()) {
                            String nextArg = arguments.get(i);
                            if (ConfigurationManager.parseableAsBoolean(nextArg)) {
                                f.set(arg.getB(), Boolean.parseBoolean(nextArg));
                                arguments.remove(i);
                                break block30;
                            } else {
                                f.set(arg.getB(), true);
                            }
                            break block30;
                        } else {
                            f.set(arg.getB(), true);
                        }
                        break block30;
                    }
                    curArg = args[args.length - 1] + "";
                    if (i >= arguments.size()) {
                        f.setAccessible(accessible);
                        throw new ArgumentException(curArg, "No parameter for argument");
                    }
                    param = arguments.get(i);
                    list = ConfigurationManager.parseStringList(param);
                    if (FieldType.arrayTypes.contains((Object)ft)) {
                        f.set(arg.getB(), PropertySheet.parseArrayField(this, curArg, f.getName(), f.getType(), ft, ListProperty.createFromStringList(list)));
                    } else if (FieldType.listTypes.contains((Object)ft)) {
                        genericList = PropertySheet.getGenericClass(f);
                        if (genericList.size() != 1) {
                            f.setAccessible(accessible);
                            throw new ArgumentException(curArg, "Unknown generic type in argument");
                        }
                        f.set(arg.getB(), PropertySheet.parseListField(this, curArg, f.getName(), f.getType(), genericList.get(0), ft, ListProperty.createFromStringList(list)));
                    } else {
                        if (list.size() != 1) {
                            f.setAccessible(accessible);
                            throw new ArgumentException(curArg, "Parsed a list where a single argument was expected. Type = " + f.getType() + ", parsed output = " + list.toString());
                        }
                        f.set(arg.getB(), PropertySheet.parseSimpleField(this, curArg, f.getName(), f.getType(), ft, list.get(0)));
                    }
                    arguments.remove(i);
                }
                f.setAccessible(accessible);
            }
            if (consumed) {
                --i;
            }
            ++i;
        }
    }

    private static List<URL> parseConfigFiles(List<String> arguments) throws ArgumentException {
        ArrayList<URL> urls = new ArrayList<URL>();
        String confStr = SHORT_ARG + configFileOption.charName();
        String longStr = LONG_ARG + configFileOption.longName();
        String fileFormatStr = LONG_ARG + fileFormatOption.longName();
        Iterator<String> argsItr = arguments.iterator();
        while (argsItr.hasNext()) {
            String curParam;
            String curArg = argsItr.next();
            if (confStr.equals(curArg) || longStr.equals(curArg)) {
                argsItr.remove();
                if (argsItr.hasNext()) {
                    curParam = argsItr.next();
                    if (!curParam.startsWith(SHORT_ARG)) {
                        List<String> urlList = ConfigurationManager.parseStringList(curParam);
                        urls.clear();
                        for (String s : urlList) {
                            URL url = ConfigurationManager.findURL(s, curArg);
                            urls.add(url);
                        }
                        argsItr.remove();
                        continue;
                    }
                    throw new ArgumentException(curArg, "No parameter supplied for argument");
                }
                throw new ArgumentException(curArg, "No parameter supplied for argument");
            }
            if (!fileFormatStr.equals(curArg)) continue;
            argsItr.remove();
            if (argsItr.hasNext()) {
                curParam = argsItr.next();
                if (!curParam.startsWith(SHORT_ARG)) {
                    List<String> fileFormatFactoryList = ConfigurationManager.parseStringList(curParam);
                    for (String className : fileFormatFactoryList) {
                        try {
                            Class<?> clazz = Class.forName(className);
                            if (FileFormatFactory.class.isAssignableFrom(clazz)) {
                                FileFormatFactory fff = (FileFormatFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                ConfigurationManager.addFileFormatFactory(fff);
                                continue;
                            }
                            throw new ArgumentException(curArg, className + " does not implement FileFormatFactory");
                        }
                        catch (ClassNotFoundException e) {
                            throw new ArgumentException(e, curArg, "Class not found");
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            throw new ArgumentException(e, curArg, "Could not instantiate class");
                        }
                    }
                    argsItr.remove();
                    continue;
                }
                throw new ArgumentException(curArg, "No parameter supplied for argument");
            }
            throw new ArgumentException(curArg, "No parameter supplied for argument");
        }
        return urls;
    }

    public String usage() {
        return this.usage;
    }

    public static List<String> parseStringList(String input) {
        ArrayList<String> tokensList = new ArrayList<String>();
        boolean inQuotes = false;
        boolean escaped = false;
        StringBuilder buffer = new StringBuilder();
        block6: for (char c : input.toCharArray()) {
            switch (c) {
                case ',': {
                    if (inQuotes || escaped) {
                        buffer.append(c);
                    } else {
                        tokensList.add(buffer.toString());
                        buffer = new StringBuilder();
                    }
                    escaped = false;
                    continue block6;
                }
                case '^': {
                    if (IS_WINDOWS && !escaped) {
                        escaped = true;
                        continue block6;
                    }
                    buffer.append(c);
                    escaped = false;
                    continue block6;
                }
                case '\\': {
                    if (!IS_WINDOWS && !escaped) {
                        escaped = true;
                        continue block6;
                    }
                    buffer.append(c);
                    escaped = false;
                    continue block6;
                }
                case '\"': {
                    inQuotes = !inQuotes;
                }
                default: {
                    buffer.append(c);
                    escaped = false;
                }
            }
        }
        tokensList.add(buffer.toString());
        return tokensList;
    }

    private boolean checkConfigurableField(String configurableClass, String fieldName) {
        PropertySheet.StoredFieldType sft = this.getStoredFieldType(configurableClass, fieldName);
        if (sft == PropertySheet.StoredFieldType.MAP) {
            logger.warning("Dude seriously, a Map? On the command line? Maps aren't supported.");
        }
        return sft == PropertySheet.StoredFieldType.LIST || sft == PropertySheet.StoredFieldType.STRING;
    }

    private PropertySheet.StoredFieldType getStoredFieldType(String configurableClass, String fieldName) {
        Class<?> clazz = null;
        try {
            Class<?> tmpClazz = Class.forName(configurableClass);
            if (!Configurable.class.isAssignableFrom(tmpClazz)) {
                throw new PropertyException("", fieldName, configurableClass + " does not extends Configurable.");
            }
            clazz = tmpClazz;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to load " + configurableClass);
        }
        return this.getStoredFieldType(clazz, fieldName);
    }

    private PropertySheet.StoredFieldType getStoredFieldType(Class<? extends Configurable> configurableClass, String fieldName) {
        Set<Field> fields = PropertySheet.getAllFields(configurableClass);
        for (Field f : fields) {
            if (!f.getName().equals(fieldName) || f.getAnnotation(Config.class) == null) continue;
            FieldType ft = FieldType.getFieldType(f);
            if (ft == null) {
                return PropertySheet.StoredFieldType.NONE;
            }
            logger.log(Level.FINEST, "Found field of type " + ft.name());
            if (FieldType.arrayTypes.contains((Object)ft)) {
                return PropertySheet.StoredFieldType.LIST;
            }
            if (FieldType.listTypes.contains((Object)ft)) {
                return PropertySheet.StoredFieldType.LIST;
            }
            if (FieldType.simpleTypes.contains((Object)ft)) {
                return PropertySheet.StoredFieldType.STRING;
            }
            if (FieldType.mapTypes.contains((Object)ft)) {
                return PropertySheet.StoredFieldType.MAP;
            }
            return PropertySheet.StoredFieldType.NONE;
        }
        return PropertySheet.StoredFieldType.NONE;
    }

    public boolean showCreations() {
        return this.showCreations;
    }

    public void addProperties(URL url) throws ConfigLoaderException {
        this.configURLs.add(url);
        URLLoader loader = new URLLoader(this.configURLs, formatFactoryMap);
        loader.load();
        GlobalProperties tgp = loader.getGlobalProperties();
        Map<String, ConfigurationData> trpm = loader.getPropertyMap();
        for (Map.Entry<String, SerializedObject> entry : loader.getSerializedObjects().entrySet()) {
            entry.getValue().setConfigurationManager(this);
            this.serializedObjects.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : tgp) {
            this.globalProperties.setValue(entry.getKey(), (GlobalProperty)entry.getValue());
            this.origGlobal.setValue(entry.getKey(), (GlobalProperty)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : trpm.entrySet()) {
            ConfigurationData configurationData = this.configurationDataMap.put(entry.getKey(), (ConfigurationData)entry.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void overrideConfigurableProperty(String componentName, String propertyName, Property value) {
        ConfigurationData rpd = this.configurationDataMap.get(componentName);
        if (rpd == null) throw new PropertyException(componentName, "Failed to find component " + componentName);
        if (this.symbolTable.containsKey(componentName)) throw new PropertyException(componentName, "Properties can only be overridden before the object is constructed.");
        PropertySheet.StoredFieldType type = this.getStoredFieldType(rpd.getClassName(), propertyName);
        if (type == PropertySheet.StoredFieldType.STRING && value instanceof SimpleProperty) {
            rpd.add(propertyName, value);
            return;
        } else if (type == PropertySheet.StoredFieldType.LIST && value instanceof ListProperty) {
            rpd.add(propertyName, value);
            return;
        } else if (type == PropertySheet.StoredFieldType.MAP && value instanceof MapProperty) {
            rpd.add(propertyName, value);
            return;
        } else {
            if (type != PropertySheet.StoredFieldType.NONE) throw new PropertyException(componentName, propertyName, "Incompatible field type, found " + (Object)((Object)type) + ", expected " + value.getClass().getSimpleName());
            throw new PropertyException(componentName, propertyName, "Failed to find field " + propertyName + " in component " + componentName + " with class " + rpd.getClassName());
        }
    }

    @Override
    public synchronized void close() {
    }

    public String[] getUnnamedArguments() {
        return Arrays.copyOf(this.unnamedArguments, this.unnamedArguments.length);
    }

    public Optional<ConfigurationData> getConfigurationData(String instanceName) {
        ConfigurationData data = this.configurationDataMap.get(instanceName);
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(data);
    }

    public boolean containsConfigurable(String instanceName) {
        return this.configurationDataMap.containsKey(instanceName);
    }

    public Optional<String> getConfiguredName(Configurable conf) {
        if (this.configurationNameMap.containsKey(conf)) {
            return Optional.of(this.configurationNameMap.get(conf));
        }
        return Optional.empty();
    }

    protected PropertySheet<? extends Configurable> getPropertySheet(String instanceName) {
        ConfigurationData rpd;
        if (!this.symbolTable.containsKey(instanceName) && (rpd = this.configurationDataMap.get(instanceName)) != null) {
            String className = rpd.getClassName();
            try {
                Class<?> confClass = Class.forName(className);
                if (!Configurable.class.isAssignableFrom(confClass)) {
                    throw new PropertyException(rpd.getName(), "Class " + className + " does not implement Configurable.");
                }
                PropertySheet propertySheet = new PropertySheet(confClass, this, rpd);
                this.symbolTable.put(instanceName, propertySheet);
            }
            catch (ClassNotFoundException e) {
                throw new PropertyException(e, rpd.getName(), "Class " + className + " not found");
            }
        }
        return this.symbolTable.get(instanceName);
    }

    public Set<String> getInstanceNames(Class<? extends Configurable> type) {
        HashSet<String> instanceNames = new HashSet<String>();
        for (PropertySheet<? extends Configurable> ps : this.symbolTable.values()) {
            if (!ps.isInstantiated() || !type.isAssignableFrom(ps.getClass())) continue;
            instanceNames.add(ps.getInstanceName());
        }
        return instanceNames;
    }

    public Set<String> getComponentNames() {
        return new HashSet<String>(this.configurationDataMap.keySet());
    }

    public Object lookupSerializedObject(String objectName) {
        SerializedObject so = this.serializedObjects.get(objectName);
        if (so == null) {
            return null;
        }
        return so.getObject();
    }

    public Configurable lookup(String instanceName) throws InternalConfigurationException {
        return this.lookup(instanceName, null, true);
    }

    public Configurable lookup(String instanceName, boolean reuseComponent) throws InternalConfigurationException {
        return this.lookup(instanceName, null, reuseComponent);
    }

    public Configurable lookup(String instanceName, ComponentListener cl) throws InternalConfigurationException {
        return this.lookup(instanceName, cl, true);
    }

    public Configurable lookup(String instanceName, ComponentListener cl, boolean reuseComponent) throws InternalConfigurationException {
        return this.innerLookup(instanceName, cl, reuseComponent);
    }

    private Configurable innerLookup(String instanceName, ComponentListener cl, boolean reuseComponent) throws InternalConfigurationException {
        instanceName = this.getStrippedComponentName(instanceName);
        PropertySheet<? extends Configurable> ps = this.getPropertySheet(instanceName);
        logger.log(Level.FINER, String.format("lookup: %s", instanceName));
        if (ps == null) {
            throw new PropertyException(instanceName, "Failed to find component.");
        }
        Configurable ret = ps.getOwner(reuseComponent);
        if (!this.configurationNameMap.containsKey(ret)) {
            this.configurationNameMap.put(ret, instanceName);
        }
        if (ret instanceof Startable) {
            Startable stret = (Startable)((Object)ret);
            Thread t = new Thread(stret);
            t.setName(instanceName + "_thread");
            stret.setThread(t);
            t.start();
        }
        this.configuredComponents.put(new ConfigWrapper(ret), ps);
        return ret;
    }

    public int getNumInstantiated() {
        return this.configuredComponents.size();
    }

    public <T extends Configurable> T lookup(Class<T> c, ComponentListener<T> cl) {
        List<T> comps = this.lookupAll(c, cl);
        if (comps.isEmpty()) {
            return null;
        }
        Collections.shuffle(comps);
        return (T)((Configurable)comps.get(0));
    }

    public <T extends Configurable> Map<String, T> lookupAllMap(Class<T> c) {
        HashMap<String, Configurable> ret = new HashMap<String, Configurable>();
        if (!c.isInterface()) {
            String className = c.getName();
            for (Map.Entry<String, ConfigurationData> e : this.configurationDataMap.entrySet()) {
                if (!e.getValue().getClassName().equals(className) || e.getValue().isImportable()) continue;
                ret.put(e.getKey(), this.lookup(e.getKey()));
            }
        } else {
            for (Map.Entry<String, ConfigurationData> e : this.configurationDataMap.entrySet()) {
                try {
                    Class<?> clazz = Class.forName(e.getValue().getClassName());
                    if (e.getValue().isImportable() || !c.isAssignableFrom(clazz) || clazz.isInterface()) continue;
                    ret.put(e.getKey(), this.innerLookup(e.getKey(), null, true));
                }
                catch (ClassNotFoundException ex) {
                    throw new PropertyException(ex, e.getKey(), "Class not found for component " + e.getKey());
                }
            }
        }
        return ret;
    }

    public <T extends Configurable> List<T> lookupAll(Class<T> c) {
        ArrayList<Configurable> ret = new ArrayList<Configurable>();
        if (!c.isInterface()) {
            String className = c.getName();
            for (Map.Entry<String, ConfigurationData> e : this.configurationDataMap.entrySet()) {
                if (!e.getValue().getClassName().equals(className) || e.getValue().isImportable()) continue;
                ret.add(this.lookup(e.getKey()));
            }
        } else {
            for (Map.Entry<String, ConfigurationData> e : this.configurationDataMap.entrySet()) {
                try {
                    Class<?> clazz = Class.forName(e.getValue().getClassName());
                    if (e.getValue().isImportable() || !c.isAssignableFrom(clazz) || clazz.isInterface()) continue;
                    ret.add(this.innerLookup(e.getKey(), null, true));
                }
                catch (ClassNotFoundException ex) {
                    throw new PropertyException(ex, e.getKey(), "Class not found for component " + e.getKey());
                }
            }
        }
        return ret;
    }

    public <T extends Configurable> List<T> lookupAll(Class<T> c, ComponentListener<T> cl) {
        return this.lookupAll(c);
    }

    public <T extends Configurable> T lookupSingleton(Class<T> c, boolean allowAssignable) throws PropertyException {
        ArrayList<String> instanceNames = new ArrayList<String>();
        for (Map.Entry<String, ConfigurationData> e : this.configurationDataMap.entrySet()) {
            ConfigurationData rpd = e.getValue();
            try {
                Class<?> pclass = Class.forName(rpd.getClassName());
                if (rpd.isImportable() || (!allowAssignable || !c.isAssignableFrom(pclass)) && (allowAssignable || !rpd.getClassName().equals(c.getName()))) continue;
                instanceNames.add(e.getKey());
            }
            catch (ClassNotFoundException ex) {
                logger.warning(String.format("No class %s found in ConfigurationManager", rpd.getClassName()));
            }
        }
        if (instanceNames.isEmpty()) {
            return null;
        }
        if (instanceNames.size() > 1) {
            String names = instanceNames.stream().collect(Collectors.joining(", "));
            throw new PropertyException("", "Multiple instances of " + c.getName() + " found in configuration: " + names);
        }
        String matchedName = (String)instanceNames.get(0);
        ConfigurationData cd = this.configurationDataMap.get(matchedName);
        try {
            Class<?> matchedClass = Class.forName(cd.getClassName());
            if (!matchedClass.isInterface()) {
                return (T)this.lookup(matchedName);
            }
            throw new PropertyException("matchedName", "Cannot instantiate component with type " + matchedClass + " since it is an interface");
        }
        catch (ClassNotFoundException e) {
            throw new PropertyException(e, matchedName, "Class not found for component " + matchedName);
        }
    }

    public <T extends Configurable> List<String> listAll(Class<T> c) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, ConfigurationData> e : this.configurationDataMap.entrySet()) {
            ConfigurationData rpd = e.getValue();
            try {
                Class<?> pclass = Class.forName(rpd.getClassName());
                if (!c.isAssignableFrom(pclass)) continue;
                ret.add(e.getKey());
            }
            catch (ClassNotFoundException ex) {
                logger.warning(String.format("No class %s found in ConfigurationManager", rpd.getClassName()));
            }
        }
        return ret;
    }

    public void addConfiguration(Class<? extends Configurable> confClass, String instanceName) {
        if (instanceName == null || instanceName.isEmpty()) {
            instanceName = confClass.getSimpleName();
        }
        ConfigurationData data = new ConfigurationData(instanceName, confClass.getName());
        this.addConfiguration(data);
    }

    public boolean removeConfigurable(String name) {
        if (this.configurationDataMap.containsKey(name)) {
            PropertySheet<? extends Configurable> ps;
            this.configurationDataMap.remove(name);
            if (this.symbolTable.containsKey(name) && (ps = this.symbolTable.remove(name)).isInstantiated()) {
                this.configuredComponents.remove(new ConfigWrapper(ps.getOwner()));
            }
            return true;
        }
        return false;
    }

    public void addSubConfiguration(ConfigurationManager subCM) {
        this.addSubConfiguration(subCM, false);
    }

    public void addSubConfiguration(ConfigurationManager subCM, boolean overwrite) {
        Set<String> compNames = this.getComponentNames();
        if (!overwrite) {
            for (String string : subCM.getComponentNames()) {
                if (!compNames.contains(string)) continue;
                throw new PropertyException(string, string + " is already registered to system configuration");
            }
            for (String string : subCM.globalProperties.keySet()) {
                if (!this.globalProperties.keySet().contains(string)) continue;
                throw new PropertyException(string, string + " is already registered as global property");
            }
        }
        this.globalProperties.putAll(subCM.globalProperties);
        for (Map.Entry entry : subCM.symbolTable.entrySet()) {
            PropertySheet newPS = ((PropertySheet)entry.getValue()).copy();
            newPS.setCM(this);
            this.symbolTable.put((String)entry.getKey(), newPS);
        }
        this.configurationDataMap.putAll(subCM.configurationDataMap);
    }

    public void addConfiguration(ConfigurationData newData) {
        String instanceName = newData.getName();
        if (this.symbolTable.containsKey(instanceName)) {
            throw new IllegalArgumentException("tried to override existing instantiated component name");
        }
        this.configurationDataMap.put(instanceName, newData);
    }

    public void addConfiguration(List<ConfigurationData> newData) {
        for (ConfigurationData data : newData) {
            this.addConfiguration(data);
        }
    }

    public GlobalProperties getGlobalProperties() {
        return new GlobalProperties(this.globalProperties);
    }

    public ImmutableGlobalProperties getImmutableGlobalProperties() {
        return this.globalProperties.getImmutableProperties();
    }

    public String getGlobalProperty(String propertyName) {
        GlobalProperty globProp = this.globalProperties.get(propertyName);
        if (globProp == null) {
            return null;
        }
        return this.globalProperties.replaceGlobalProperties("_global", propertyName, globProp.toString());
    }

    public List<URL> getConfigURLs() {
        return this.configURLs;
    }

    public void setGlobalProperty(String propertyName, String value) {
        if (value == null) {
            this.globalProperties.remove(propertyName);
            this.origGlobal.remove(propertyName);
        } else {
            this.globalProperties.setValue(propertyName, value);
            this.origGlobal.setValue(propertyName, value);
        }
    }

    protected String getStrippedComponentName(String propertyName) {
        assert (propertyName != null);
        while (propertyName.startsWith("$")) {
            propertyName = this.globalProperties.get(GlobalProperty.stripGlobalSymbol(propertyName)).toString();
        }
        return propertyName;
    }

    public boolean equals(Object obj) {
        HashSet<String> setB;
        if (!(obj instanceof ConfigurationManager)) {
            return false;
        }
        ConfigurationManager cm = (ConfigurationManager)obj;
        HashSet<String> setA = new HashSet<String>(this.getComponentNames());
        if (!setA.equals(setB = new HashSet<String>(cm.getComponentNames()))) {
            return false;
        }
        for (String instanceName : this.getComponentNames()) {
            ConfigurationData otherData;
            ConfigurationData myData = this.configurationDataMap.get(instanceName);
            if (myData.equals(otherData = cm.configurationDataMap.get(instanceName))) continue;
            return false;
        }
        return cm.getImmutableGlobalProperties().equals(this.getImmutableGlobalProperties());
    }

    public int hashCode() {
        return Objects.hash(this.configuredComponents, this.configurationDataMap, this.globalProperties, this.serializedObjects, this.origGlobal, this.showCreations);
    }

    public void save(File file) throws IOException {
        this.save(file, false);
    }

    public void save(File file, boolean writeAll) throws IOException {
        String filename = file.getName();
        int i = filename.lastIndexOf(46);
        String extension = i > 0 ? filename.substring(i + 1).toLowerCase() : "";
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.save(fos, extension, writeAll);
        }
    }

    public void save(OutputStream writer, String extension, boolean writeAll) throws IOException {
        FileFormatFactory factory = formatFactoryMap.get(extension);
        if (factory == null) {
            throw new IllegalArgumentException("Extension " + extension + " does not have a registered FileFormatFactory.");
        }
        try {
            ConfigWriter configWriter = factory.getWriter(writer);
            this.write(configWriter, writeAll);
        }
        catch (ConfigWriterException e) {
            throw new IOException("Error generating " + extension + " file.", e);
        }
    }

    protected void write(ConfigWriter writer, boolean writeAll) throws ConfigWriterException {
        writer.writeStartDocument();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String propName : this.origGlobal.keySet()) {
            String propVal = this.globalProperties.get(propName).toString();
            Matcher matcher = GlobalProperty.globalSymbolPattern.matcher(propName);
            propName = matcher.matches() ? matcher.group(1) : propName;
            properties.put(propName, propVal);
        }
        writer.writeGlobalProperties(properties);
        if (!this.serializedObjects.isEmpty()) {
            writer.writeSerializedObjects(this.serializedObjects);
        }
        writer.writeStartComponents();
        HashSet<String> allNames = new HashSet<String>(this.configurationDataMap.keySet());
        for (PropertySheet<? extends Configurable> ps : this.configuredComponents.values()) {
            this.configurationDataMap.get(ps.getInstanceName()).save(writer, ps.getRedactedFieldNames());
            allNames.remove(ps.getInstanceName());
        }
        if (writeAll) {
            for (String instanceName : allNames) {
                this.configurationDataMap.get(instanceName).save(writer);
            }
        }
        writer.writeEndComponents();
        writer.writeEndDocument();
        writer.close();
    }

    protected <T extends Configurable> PropertySheet<T> createPropertySheet(T configurable, ConfigurationManager cm, ConfigurationData rpd) {
        return new PropertySheet<T>(configurable, cm, rpd);
    }

    public String importConfigurable(Configurable configurable) throws PropertyException {
        String configName = "";
        try {
            Set<Field> fields = PropertySheet.getAllFields(configurable.getClass());
            for (Field field : fields) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                ConfigurableName nameAnnotation = field.getAnnotation(ConfigurableName.class);
                if (nameAnnotation != null) {
                    configName = (String)field.get(configurable);
                    field.setAccessible(accessible);
                    break;
                }
                field.setAccessible(accessible);
            }
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException(ex, configName, "Failed to read the ConfigurableName field");
        }
        if (configName.equals("")) {
            throw new PropertyException("", "Failed to extract name from @ConfigurableName field");
        }
        return this.importConfigurable(configurable, configName);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public String importConfigurable(Configurable configurable, String name) throws PropertyException {
        m = new LinkedHashMap<String, Property>();
        wrapper = new ConfigWrapper(configurable);
        if (this.configuredComponents.containsKey(wrapper)) {
            return this.configuredComponents.get(wrapper).getInstanceName();
        }
        if (this.symbolTable.containsKey(name)) {
            throw new PropertyException(name, "Tried to override existing component name");
        }
        propertyName = null;
        confClass = configurable.getClass();
        try {
            fields = PropertySheet.getAllFields(confClass);
            for (Field field : fields) {
                block47: {
                    accessible = field.isAccessible();
                    field.setAccessible(true);
                    configAnnotation = field.getAnnotation(Config.class);
                    if (configAnnotation == null) break block47;
                    propertyName = field.getName();
                    fieldClass = field.getType();
                    if (configAnnotation.redact()) ** GOTO lbl115
                    if (field.get(configurable) == null) {
                        if (!configAnnotation.mandatory()) continue;
                        throw new PropertyException(name, field.getName(), "Expected to extract a value from mandatory field, but found null");
                    }
                    ft = FieldType.getFieldType(fieldClass);
                    genericList = PropertySheet.getGenericClass(field);
                    genericType = Object.class;
                    if (genericList.size() == 1) {
                        genericType = genericList.get(0);
                    } else if (genericList.size() == 2) {
                        genericType = genericList.get(1);
                    }
                    ConfigurationManager.logger.log(Level.FINER, "field %s, class=%s, configurable? %s; genericType=%s configurable? %s", new Object[]{field.getName(), fieldClass.getCanonicalName(), Configurable.class.isAssignableFrom(fieldClass), genericType.getCanonicalName(), Configurable.class.isAssignableFrom(genericType)});
                    if (FieldType.simpleTypes.contains((Object)ft)) {
                        m.put(propertyName, this.importSimpleField(fieldClass, name, field.getName(), field.get(configurable)));
                    } else if (FieldType.listTypes.contains((Object)ft)) {
                        m.put(propertyName, this.importCollection(genericType, name, propertyName, (Collection)field.get(configurable)));
                    } else if (FieldType.arrayTypes.contains((Object)ft)) {
                        arrayComponentType = fieldClass.getComponentType();
                        if (Configurable.class.isAssignableFrom(arrayComponentType)) {
                            m.put(propertyName, this.importCollection(Configurable.class, name, propertyName, Arrays.asList((Configurable[])field.get(configurable))));
                        } else {
                            stringList = new ArrayList<String>();
                            if (Byte.TYPE.isAssignableFrom(arrayComponentType)) {
                                for (Object b : (Object)((byte[])field.get(configurable))) {
                                    stringList.add("" + (int)b);
                                }
                            } else if (Character.TYPE.isAssignableFrom(arrayComponentType)) {
                                for (Object c : (Object)((char[])field.get(configurable))) {
                                    stringList.add("" + (char)c);
                                }
                            } else if (Short.TYPE.isAssignableFrom(arrayComponentType)) {
                                for (Object s : (Object)((short[])field.get(configurable))) {
                                    stringList.add("" + (int)s);
                                }
                            } else if (Integer.TYPE.isAssignableFrom(arrayComponentType)) {
                                for (Object i : (Object)((int[])field.get(configurable))) {
                                    stringList.add("" + (int)i);
                                }
                            } else if (Long.TYPE.isAssignableFrom(arrayComponentType)) {
                                for (Object l : (Object)((long[])field.get(configurable))) {
                                    stringList.add("" + (long)l);
                                }
                            } else if (Float.TYPE.isAssignableFrom(arrayComponentType)) {
                                for (Object f : (Object)((float[])field.get(configurable))) {
                                    stringList.add("" + (float)f);
                                }
                            } else if (Double.TYPE.isAssignableFrom(arrayComponentType)) {
                                for (Object d : (Object)((double[])field.get(configurable))) {
                                    stringList.add("" + (double)d);
                                }
                            } else if (Boolean.TYPE.isAssignableFrom(arrayComponentType)) {
                                for (Object b : (Object)((boolean[])field.get(configurable))) {
                                    stringList.add("" + (boolean)b);
                                }
                            } else if (String.class.isAssignableFrom(arrayComponentType)) {
                                stringList.addAll(Arrays.asList((String[])field.get(configurable)));
                            } else {
                                throw new PropertyException(name, "Unsupported array type " + fieldClass.toString());
                            }
                            m.put(propertyName, ListProperty.createFromStringList(stringList));
                        }
                    } else if (FieldType.mapTypes.contains((Object)ft)) {
                        fieldMap = (Map)field.get(configurable);
                        newMap = new HashMap<String, SimpleProperty>();
                        for (Map.Entry e : fieldMap.entrySet()) {
                            key = (String)e.getKey();
                            value = e.getValue();
                            newMap.put(key, this.importSimpleField(genericType, name + "-" + field.getName(), key, value));
                        }
                        m.put(propertyName, new MapProperty(newMap));
                    } else {
                        throw new PropertyException(name, "Unknown field type " + fieldClass.toString() + " found when importing " + name + " of class " + configurable.getClass().toString());
lbl115:
                        // 1 sources

                        ConfigurationManager.logger.log(Level.FINER, "Redacting field %s, class=%s, configurable? %s; genericType=%s configurable? %s", new Object[]{field.getName(), fieldClass.getCanonicalName(), Configurable.class.isAssignableFrom(fieldClass)});
                    }
                }
                field.setAccessible(accessible);
            }
            rpd = new ConfigurationData(name, confClass.getName(), m);
            ps = this.createPropertySheet(configurable, this, rpd);
            this.symbolTable.put(name, ps);
            this.configurationDataMap.put(name, rpd);
            this.configuredComponents.put(new ConfigWrapper(configurable), ps);
            return name;
        }
        catch (PropertyException ex) {
            throw ex;
        }
        catch (IllegalAccessException | RuntimeException ex) {
            throw new PropertyException(ex, name, propertyName, String.format("Error importing %s for propName %s", new Object[]{name, propertyName}));
        }
    }

    private SimpleProperty importSimpleField(Class<?> type, String prefix, String fieldName, Object input) {
        if (Configurable.class.isAssignableFrom(type)) {
            String newName = prefix + SHORT_ARG + fieldName;
            return new SimpleProperty(this.importConfigurable((Configurable)input, newName));
        }
        if (Random.class.isAssignableFrom(type)) {
            return new SimpleProperty("" + ((Random)input).nextInt());
        }
        return new SimpleProperty(input.toString());
    }

    private ListProperty importCollection(Class<?> innerType, String prefix, String fieldName, Collection<?> input) {
        ArrayList<SimpleProperty> propList = new ArrayList<SimpleProperty>();
        int i = 0;
        for (Object o : input) {
            String newName = prefix + SHORT_ARG + fieldName;
            SimpleProperty output = this.importSimpleField(innerType, newName, "" + i, o);
            propList.add(output);
            ++i;
        }
        return new ListProperty(propList);
    }

    protected MBeanServer getMBeanServer() {
        if (this.mbs == null) {
            this.mbs = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbs;
    }

    static {
        formatFactoryMap.put("xml", new XMLConfigFactory());
    }

    private static class ConfigWrapper {
        public final Configurable config;

        ConfigWrapper(Configurable config) {
            this.config = config;
        }

        public boolean equals(Object other) {
            if (other instanceof ConfigWrapper) {
                return this.config == ((ConfigWrapper)other).config;
            }
            return false;
        }

        public int hashCode() {
            return this.config.hashCode();
        }
    }
}

