/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class ECCPrivateKey {
    private final ByteBuffer pem;

    protected ECCPrivateKey(BuilderImpl builder) {
        this.pem = builder.pem();
    }

    public ByteBuffer pem() {
        return this.pem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer pem;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ECCPrivateKey model) {
            this.pem = model.pem();
        }

        @Override
        public Builder pem(ByteBuffer pem) {
            this.pem = pem;
            return this;
        }

        @Override
        public ByteBuffer pem() {
            return this.pem;
        }

        @Override
        public ECCPrivateKey build() {
            if (Objects.isNull(this.pem())) {
                throw new IllegalArgumentException("Missing value for required field `pem`");
            }
            return new ECCPrivateKey(this);
        }
    }

    public static interface Builder {
        public Builder pem(ByteBuffer var1);

        public ByteBuffer pem();

        public ECCPrivateKey build();
    }
}

