/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexLambdaRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelBuilder;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.calcite.ExtendedRexBuilder;
import org.opensearch.sql.calcite.utils.CalciteToolsHelper;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.expression.function.FunctionProperties;

public class CalcitePlanContext {
    public FrameworkConfig config;
    public final Connection connection;
    public final RelBuilder relBuilder;
    public final ExtendedRexBuilder rexBuilder;
    public final FunctionProperties functionProperties;
    public final QueryType queryType;
    public final Integer querySizeLimit;
    private boolean isResolvingJoinCondition = false;
    private boolean isResolvingSubquery = false;
    private boolean isProjectVisited = false;
    private final Stack<RexCorrelVariable> correlVar = new Stack();
    private final Stack<List<RexNode>> windowPartitions = new Stack();
    public Map<String, RexLambdaRef> rexLambdaRefMap;

    private CalcitePlanContext(FrameworkConfig config, Integer querySizeLimit, QueryType queryType) {
        this.config = config;
        this.querySizeLimit = querySizeLimit;
        this.queryType = queryType;
        this.connection = CalciteToolsHelper.connect(config, (JavaTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY);
        this.relBuilder = CalciteToolsHelper.create(config, (JavaTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY, this.connection);
        this.rexBuilder = new ExtendedRexBuilder(this.relBuilder.getRexBuilder());
        this.functionProperties = new FunctionProperties(QueryType.PPL);
        this.rexLambdaRefMap = new HashMap<String, RexLambdaRef>();
    }

    public RexNode resolveJoinCondition(UnresolvedExpression expr, BiFunction<UnresolvedExpression, CalcitePlanContext, RexNode> transformFunction) {
        this.isResolvingJoinCondition = true;
        RexNode result = transformFunction.apply(expr, this);
        this.isResolvingJoinCondition = false;
        return result;
    }

    public Optional<RexCorrelVariable> popCorrelVar() {
        if (!this.correlVar.empty()) {
            return Optional.of(this.correlVar.pop());
        }
        return Optional.empty();
    }

    public void pushCorrelVar(RexCorrelVariable v) {
        this.correlVar.push(v);
    }

    public Optional<RexCorrelVariable> peekCorrelVar() {
        if (!this.correlVar.empty()) {
            return Optional.of(this.correlVar.peek());
        }
        return Optional.empty();
    }

    public CalcitePlanContext clone() {
        return new CalcitePlanContext(this.config, this.querySizeLimit, this.queryType);
    }

    public static CalcitePlanContext create(FrameworkConfig config, Integer querySizeLimit, QueryType queryType) {
        return new CalcitePlanContext(config, querySizeLimit, queryType);
    }

    public void putRexLambdaRefMap(Map<String, RexLambdaRef> candidateMap) {
        this.rexLambdaRefMap.putAll(candidateMap);
    }

    @Generated
    public boolean isResolvingJoinCondition() {
        return this.isResolvingJoinCondition;
    }

    @Generated
    public void setResolvingJoinCondition(boolean isResolvingJoinCondition) {
        this.isResolvingJoinCondition = isResolvingJoinCondition;
    }

    @Generated
    public boolean isResolvingSubquery() {
        return this.isResolvingSubquery;
    }

    @Generated
    public void setResolvingSubquery(boolean isResolvingSubquery) {
        this.isResolvingSubquery = isResolvingSubquery;
    }

    @Generated
    public boolean isProjectVisited() {
        return this.isProjectVisited;
    }

    @Generated
    public void setProjectVisited(boolean isProjectVisited) {
        this.isProjectVisited = isProjectVisited;
    }

    @Generated
    public Map<String, RexLambdaRef> getRexLambdaRefMap() {
        return this.rexLambdaRefMap;
    }
}

