/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import java.nio.ByteBuffer;
import org.sparkproject.jetty.client.ContentDecoder;
import org.sparkproject.jetty.io.ByteBufferPool;

public class GZIPContentDecoder
extends org.sparkproject.jetty.http.GZIPContentDecoder
implements ContentDecoder {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public GZIPContentDecoder() {
        this(8192);
    }

    public GZIPContentDecoder(int bufferSize) {
        this(null, bufferSize);
    }

    public GZIPContentDecoder(ByteBufferPool byteBufferPool, int bufferSize) {
        super(byteBufferPool, bufferSize);
    }

    protected boolean decodedChunk(ByteBuffer chunk) {
        super.decodedChunk(chunk);
        return true;
    }

    public static class Factory
    extends ContentDecoder.Factory {
        private final int bufferSize;
        private final ByteBufferPool byteBufferPool;

        public Factory() {
            this(8192);
        }

        public Factory(int bufferSize) {
            this(null, bufferSize);
        }

        public Factory(ByteBufferPool byteBufferPool) {
            this(byteBufferPool, 8192);
        }

        public Factory(ByteBufferPool byteBufferPool, int bufferSize) {
            super("gzip");
            this.byteBufferPool = byteBufferPool;
            this.bufferSize = bufferSize;
        }

        @Override
        public ContentDecoder newContentDecoder() {
            return new GZIPContentDecoder(this.byteBufferPool, this.bufferSize);
        }
    }
}

