/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.RestRequest;
import org.opensearch.securityanalytics.action.IndexCorrelationRuleRequest;
import org.opensearch.securityanalytics.action.IndexCorrelationRuleResponse;
import org.opensearch.securityanalytics.model.CorrelationRule;
import org.opensearch.securityanalytics.util.CorrelationRuleIndices;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportIndexCorrelationRuleAction
extends HandledTransportAction<IndexCorrelationRuleRequest, IndexCorrelationRuleResponse> {
    private static final Logger log = LogManager.getLogger(TransportIndexCorrelationRuleAction.class);
    private final Client client;
    private final CorrelationRuleIndices correlationRuleIndices;
    private final ClusterService clusterService;

    @Inject
    public TransportIndexCorrelationRuleAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, CorrelationRuleIndices correlationRuleIndices) {
        super("cluster:admin/index/correlation/rules/create", transportService, actionFilters, IndexCorrelationRuleRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.correlationRuleIndices = correlationRuleIndices;
    }

    protected void doExecute(Task task, IndexCorrelationRuleRequest request, ActionListener<IndexCorrelationRuleResponse> listener) {
        AsyncIndexCorrelationRuleAction asyncAction = new AsyncIndexCorrelationRuleAction(request, listener);
        asyncAction.start();
    }

    class AsyncIndexCorrelationRuleAction {
        private final IndexCorrelationRuleRequest request;
        private final ActionListener<IndexCorrelationRuleResponse> listener;

        AsyncIndexCorrelationRuleAction(IndexCorrelationRuleRequest request, ActionListener<IndexCorrelationRuleResponse> listener) {
            this.request = request;
            this.listener = listener;
        }

        void start() {
            try {
                if (!TransportIndexCorrelationRuleAction.this.correlationRuleIndices.correlationRuleIndexExists()) {
                    try {
                        TransportIndexCorrelationRuleAction.this.correlationRuleIndices.initCorrelationRuleIndex(new ActionListener<CreateIndexResponse>(){

                            public void onResponse(CreateIndexResponse response) {
                                try {
                                    AsyncIndexCorrelationRuleAction.this.onCreateMappingsResponse(response);
                                    AsyncIndexCorrelationRuleAction.this.indexCorrelationRule();
                                }
                                catch (IOException e) {
                                    AsyncIndexCorrelationRuleAction.this.onFailures(e);
                                }
                            }

                            public void onFailure(Exception e) {
                                AsyncIndexCorrelationRuleAction.this.onFailures(e);
                            }
                        });
                    }
                    catch (IOException e) {
                        this.onFailures(e);
                    }
                } else if (!IndexUtils.correlationRuleIndexUpdated.booleanValue()) {
                    IndexUtils.updateIndexMapping(".opensearch-sap-correlation-rules-config", CorrelationRuleIndices.correlationRuleIndexMappings(), TransportIndexCorrelationRuleAction.this.clusterService.state(), TransportIndexCorrelationRuleAction.this.client.admin().indices(), new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse response) {
                            AsyncIndexCorrelationRuleAction.this.onUpdateMappingsResponse(response);
                            try {
                                AsyncIndexCorrelationRuleAction.this.indexCorrelationRule();
                            }
                            catch (IOException e) {
                                AsyncIndexCorrelationRuleAction.this.onFailures(e);
                            }
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexCorrelationRuleAction.this.onFailures(e);
                        }
                    }, false);
                } else {
                    this.indexCorrelationRule();
                }
            }
            catch (IOException ex) {
                this.onFailures(ex);
            }
        }

        void indexCorrelationRule() throws IOException {
            IndexRequest indexRequest = this.request.getMethod() == RestRequest.Method.POST ? (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-rules-config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.request.getCorrelationRule().toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).timeout(TimeValue.timeValueSeconds((long)60L)) : (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-rules-config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.request.getCorrelationRule().toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).id(this.request.getCorrelationRuleId()).timeout(TimeValue.timeValueSeconds((long)60L));
            TransportIndexCorrelationRuleAction.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    if (response.status().equals((Object)RestStatus.CREATED) || response.status().equals((Object)RestStatus.OK)) {
                        CorrelationRule ruleResponse = AsyncIndexCorrelationRuleAction.this.request.getCorrelationRule();
                        ruleResponse.setId(response.getId());
                        AsyncIndexCorrelationRuleAction.this.onOperation(ruleResponse);
                    } else {
                        AsyncIndexCorrelationRuleAction.this.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexCorrelationRuleAction.this.onFailures(e);
                }
            });
        }

        private void onCreateMappingsResponse(CreateIndexResponse response) throws IOException {
            if (!response.isAcknowledged()) {
                log.error(String.format(Locale.ROOT, "Create %s mappings call not acknowledged.", ".opensearch-sap-correlation-rules-config"));
                throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged", ".opensearch-sap-correlation-rules-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            log.info(String.format(Locale.ROOT, "Created %s with mappings.", ".opensearch-sap-correlation-rules-config"));
            IndexUtils.correlationRuleIndexUpdated();
        }

        private void onUpdateMappingsResponse(AcknowledgedResponse response) {
            if (!response.isAcknowledged()) {
                log.error(String.format(Locale.ROOT, "Create %s mappings call not acknowledged.", ".opensearch-sap-correlation-rules-config"));
                throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged", ".opensearch-sap-correlation-rules-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            log.info(String.format(Locale.ROOT, "Created %s with mappings.", ".opensearch-sap-correlation-rules-config"));
            IndexUtils.correlationRuleIndexUpdated();
        }

        private void onOperation(CorrelationRule correlationRule) {
            this.finishHim(correlationRule, null);
        }

        private void onFailures(Exception t) {
            this.finishHim(null, t);
        }

        private void finishHim(CorrelationRule correlationRule, Exception t) {
            if (t != null) {
                this.listener.onFailure(t);
            } else {
                this.listener.onResponse((Object)new IndexCorrelationRuleResponse(correlationRule.getId(), correlationRule.getVersion(), this.request.getMethod() == RestRequest.Method.POST ? RestStatus.CREATED : RestStatus.OK, correlationRule));
            }
        }
    }
}

