/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.condition;

import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.securityanalytics.rules.condition.ConditionAND;
import org.opensearch.securityanalytics.rules.condition.ConditionBaseVisitor;
import org.opensearch.securityanalytics.rules.condition.ConditionItem;
import org.opensearch.securityanalytics.rules.condition.ConditionNOT;
import org.opensearch.securityanalytics.rules.condition.ConditionOR;
import org.opensearch.securityanalytics.rules.condition.ConditionParser;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.rules.objects.SigmaCondition;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public class ConditionTraverseVisitor
extends ConditionBaseVisitor<Either<ConditionItem, String>> {
    private final SigmaCondition sigmaCondition;

    public ConditionTraverseVisitor(SigmaCondition sigmaCondition) {
        this.sigmaCondition = sigmaCondition;
    }

    @Override
    public Either<ConditionItem, String> visitStart(ConditionParser.StartContext ctx) {
        return (Either)super.visit((ParseTree)ctx.expression());
    }

    @Override
    public Either<ConditionItem, String> visitIdentOrSelectExpression(ConditionParser.IdentOrSelectExpressionContext ctx) {
        if (ctx.IDENTIFIER() != null) {
            return Either.right(ctx.IDENTIFIER().getText());
        }
        return Either.right(ctx.SELECTOR().getText());
    }

    @Override
    public Either<ConditionItem, String> visitNotExpression(ConditionParser.NotExpressionContext ctx) {
        try {
            Either exp = (Either)this.visit((ParseTree)ctx.expression());
            ConditionNOT condition = new ConditionNOT(false, List.of(exp.isLeft() ? Either.left(AnyOneOf.leftVal((ConditionItem)exp.getLeft())) : Either.right((String)exp.get())));
            condition.setArgs(this.sigmaCondition.convertArgs(condition.getArgs()));
            return Either.left(condition);
        }
        catch (SigmaConditionError ex) {
            return null;
        }
    }

    @Override
    public Either<ConditionItem, String> visitAndExpression(ConditionParser.AndExpressionContext ctx) {
        try {
            Either left = (Either)this.visit((ParseTree)ctx.left);
            Either right = (Either)this.visit((ParseTree)ctx.right);
            ConditionAND condition = new ConditionAND(false, List.of(left.isLeft() ? Either.left(AnyOneOf.leftVal((ConditionItem)left.getLeft())) : Either.right((String)left.get()), right.isLeft() ? Either.left(AnyOneOf.leftVal((ConditionItem)right.getLeft())) : Either.right((String)right.get())));
            condition.setArgs(this.sigmaCondition.convertArgs(condition.getArgs()));
            return Either.left(condition);
        }
        catch (SigmaConditionError ex) {
            return null;
        }
    }

    @Override
    public Either<ConditionItem, String> visitOrExpression(ConditionParser.OrExpressionContext ctx) {
        try {
            Either left = (Either)this.visit((ParseTree)ctx.left);
            Either right = (Either)this.visit((ParseTree)ctx.right);
            ConditionOR condition = new ConditionOR(false, List.of(left.isLeft() ? Either.left(AnyOneOf.leftVal((ConditionItem)left.getLeft())) : Either.right((String)left.get()), right.isLeft() ? Either.left(AnyOneOf.leftVal((ConditionItem)right.getLeft())) : Either.right((String)right.get())));
            condition.setArgs(this.sigmaCondition.convertArgs(condition.getArgs()));
            return Either.left(condition);
        }
        catch (SigmaConditionError ex) {
            return null;
        }
    }

    @Override
    public Either<ConditionItem, String> visitParenExpression(ConditionParser.ParenExpressionContext ctx) {
        return (Either)super.visit((ParseTree)ctx.expression());
    }
}

