/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ThreadCount
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ThreadCount> {
    @Nullable
    private final Long active;
    @Nullable
    private final Long completed;
    @Nullable
    private final Long largest;
    @Nullable
    private final Long queue;
    @Nullable
    private final Long rejected;
    @Nullable
    private final Long threads;
    @Nullable
    private final Time totalWaitTime;
    @Nullable
    private final Long totalWaitTimeInNanos;
    public static final JsonpDeserializer<ThreadCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ThreadCount::setupThreadCountDeserializer);

    private ThreadCount(Builder builder) {
        this.active = builder.active;
        this.completed = builder.completed;
        this.largest = builder.largest;
        this.queue = builder.queue;
        this.rejected = builder.rejected;
        this.threads = builder.threads;
        this.totalWaitTime = builder.totalWaitTime;
        this.totalWaitTimeInNanos = builder.totalWaitTimeInNanos;
    }

    public static ThreadCount of(Function<Builder, ObjectBuilder<ThreadCount>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long active() {
        return this.active;
    }

    @Nullable
    public final Long completed() {
        return this.completed;
    }

    @Nullable
    public final Long largest() {
        return this.largest;
    }

    @Nullable
    public final Long queue() {
        return this.queue;
    }

    @Nullable
    public final Long rejected() {
        return this.rejected;
    }

    @Nullable
    public final Long threads() {
        return this.threads;
    }

    @Nullable
    public final Time totalWaitTime() {
        return this.totalWaitTime;
    }

    @Nullable
    public final Long totalWaitTimeInNanos() {
        return this.totalWaitTimeInNanos;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.active != null) {
            generator.writeKey("active");
            generator.write(this.active.longValue());
        }
        if (this.completed != null) {
            generator.writeKey("completed");
            generator.write(this.completed.longValue());
        }
        if (this.largest != null) {
            generator.writeKey("largest");
            generator.write(this.largest.longValue());
        }
        if (this.queue != null) {
            generator.writeKey("queue");
            generator.write(this.queue.longValue());
        }
        if (this.rejected != null) {
            generator.writeKey("rejected");
            generator.write(this.rejected.longValue());
        }
        if (this.threads != null) {
            generator.writeKey("threads");
            generator.write(this.threads.longValue());
        }
        if (this.totalWaitTime != null) {
            generator.writeKey("total_wait_time");
            this.totalWaitTime.serialize(generator, mapper);
        }
        if (this.totalWaitTimeInNanos != null) {
            generator.writeKey("total_wait_time_in_nanos");
            generator.write(this.totalWaitTimeInNanos.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupThreadCountDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::active, JsonpDeserializer.longDeserializer(), "active");
        op.add(Builder::completed, JsonpDeserializer.longDeserializer(), "completed");
        op.add(Builder::largest, JsonpDeserializer.longDeserializer(), "largest");
        op.add(Builder::queue, JsonpDeserializer.longDeserializer(), "queue");
        op.add(Builder::rejected, JsonpDeserializer.longDeserializer(), "rejected");
        op.add(Builder::threads, JsonpDeserializer.longDeserializer(), "threads");
        op.add(Builder::totalWaitTime, Time._DESERIALIZER, "total_wait_time");
        op.add(Builder::totalWaitTimeInNanos, JsonpDeserializer.longDeserializer(), "total_wait_time_in_nanos");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.active);
        result = 31 * result + Objects.hashCode(this.completed);
        result = 31 * result + Objects.hashCode(this.largest);
        result = 31 * result + Objects.hashCode(this.queue);
        result = 31 * result + Objects.hashCode(this.rejected);
        result = 31 * result + Objects.hashCode(this.threads);
        result = 31 * result + Objects.hashCode(this.totalWaitTime);
        result = 31 * result + Objects.hashCode(this.totalWaitTimeInNanos);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadCount other = (ThreadCount)o;
        return Objects.equals(this.active, other.active) && Objects.equals(this.completed, other.completed) && Objects.equals(this.largest, other.largest) && Objects.equals(this.queue, other.queue) && Objects.equals(this.rejected, other.rejected) && Objects.equals(this.threads, other.threads) && Objects.equals(this.totalWaitTime, other.totalWaitTime) && Objects.equals(this.totalWaitTimeInNanos, other.totalWaitTimeInNanos);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ThreadCount> {
        @Nullable
        private Long active;
        @Nullable
        private Long completed;
        @Nullable
        private Long largest;
        @Nullable
        private Long queue;
        @Nullable
        private Long rejected;
        @Nullable
        private Long threads;
        @Nullable
        private Time totalWaitTime;
        @Nullable
        private Long totalWaitTimeInNanos;

        public Builder() {
        }

        private Builder(ThreadCount o) {
            this.active = o.active;
            this.completed = o.completed;
            this.largest = o.largest;
            this.queue = o.queue;
            this.rejected = o.rejected;
            this.threads = o.threads;
            this.totalWaitTime = o.totalWaitTime;
            this.totalWaitTimeInNanos = o.totalWaitTimeInNanos;
        }

        private Builder(Builder o) {
            this.active = o.active;
            this.completed = o.completed;
            this.largest = o.largest;
            this.queue = o.queue;
            this.rejected = o.rejected;
            this.threads = o.threads;
            this.totalWaitTime = o.totalWaitTime;
            this.totalWaitTimeInNanos = o.totalWaitTimeInNanos;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder active(@Nullable Long value) {
            this.active = value;
            return this;
        }

        @Nonnull
        public final Builder completed(@Nullable Long value) {
            this.completed = value;
            return this;
        }

        @Nonnull
        public final Builder largest(@Nullable Long value) {
            this.largest = value;
            return this;
        }

        @Nonnull
        public final Builder queue(@Nullable Long value) {
            this.queue = value;
            return this;
        }

        @Nonnull
        public final Builder rejected(@Nullable Long value) {
            this.rejected = value;
            return this;
        }

        @Nonnull
        public final Builder threads(@Nullable Long value) {
            this.threads = value;
            return this;
        }

        @Nonnull
        public final Builder totalWaitTime(@Nullable Time value) {
            this.totalWaitTime = value;
            return this;
        }

        @Nonnull
        public final Builder totalWaitTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalWaitTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder totalWaitTimeInNanos(@Nullable Long value) {
            this.totalWaitTimeInNanos = value;
            return this;
        }

        @Override
        @Nonnull
        public ThreadCount build() {
            this._checkSingleUse();
            return new ThreadCount(this);
        }
    }
}

