/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class BiIconEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String BEAN_ICONEDITOR_HELP = "beans.icon";
    private FileObject sourceFileObject;
    private PropertyEnv env;
    static ResourceBundle bundle = NbBundle.getBundle(BiIconEditor.class);

    public static boolean isImage(String s) {
        return (s = s.toLowerCase()).endsWith(".jpg") || s.endsWith(".gif") || s.endsWith(".jpeg") || s.endsWith(".jpe") || s.equals("jpg") || s.equals("gif") || s.equals("jpeg") || s.equals("jpe");
    }

    public BiIconEditor(FileObject sourceFileObject) {
        this.sourceFileObject = sourceFileObject;
    }

    public String getSourceName() {
        if (this.getValue() instanceof BiImageIcon) {
            return this.getValue().getName();
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        BiImageIcon old = this.getValue();
        if (old == value || old != null && old.equals(value)) {
            return;
        }
        if (this.env != null) {
            BiImageIcon newval = (BiImageIcon)value;
            this.env.setState(newval != null && (newval.url == null || newval.getIcon() == null) ? PropertyEnv.STATE_INVALID : PropertyEnv.STATE_VALID);
        }
        super.setValue(value);
    }

    @Override
    public BiImageIcon getValue() {
        return (BiImageIcon)super.getValue();
    }

    @Override
    public String getAsText() {
        BiImageIcon val = this.getValue();
        return String.valueOf(this.textFromIcon(val));
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        try {
            BiImageIcon iconFromText = this.iconFromText(string);
            if (iconFromText == null || iconFromText.url != null) {
                this.setValue(iconFromText);
            } else {
                String msg = NbBundle.getMessage(IconPanel.class, (String)"CTL_Icon_not_exists", (Object)string);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    String textFromIcon(BiImageIcon icon) {
        return icon == null ? null : icon.getName();
    }

    BiImageIcon iconFromText(String string) throws IllegalArgumentException {
        BiImageIcon ii;
        try {
            if (string.length() == 0 || string.equals("null")) {
                ii = null;
            } else {
                URL res = BiIconEditor.resolveIconPath(string, this.sourceFileObject);
                ii = new BiImageIcon(res, string);
            }
        }
        catch (IOException ex) {
            ii = new BiImageIcon(null, string);
        }
        return ii;
    }

    private static URL resolveIconPath(String resourcePath, FileObject beanInfo) throws FileStateInvalidException, FileNotFoundException {
        String path;
        ClassPath cp = ClassPath.getClassPath((FileObject)beanInfo, (String)"classpath/source");
        FileObject res = cp.findResource(path = resourcePath.charAt(0) != '/' ? '/' + cp.getResourceName(beanInfo.getParent()) + '/' + resourcePath : resourcePath);
        if (res != null && res.canRead() && res.isData()) {
            return res.toURL();
        }
        throw new FileNotFoundException(path);
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new IconPanel(this, this.env);
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
        BiImageIcon val = this.getValue();
        if (val != null && (val.url == null || val.getIcon() == null)) {
            env.setState(PropertyEnv.STATE_INVALID);
        }
    }

    public static final class BiImageIcon {
        private String name;
        private URL url;
        private Icon icon;

        public BiImageIcon() {
        }

        BiImageIcon(URL url, String name) {
            this.url = url;
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        public Icon getIcon() {
            if (this.icon == null) {
                if (this.url == null) {
                    return this.icon;
                }
                try {
                    BufferedImage image = ImageIO.read(this.url);
                    if (image == null) {
                        return null;
                    }
                    this.icon = new ImageIcon(image);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.icon;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BiImageIcon other = (BiImageIcon)obj;
            return this.name == other.name || this.name != null && this.name.equals(other.name);
        }
    }

    private static final class IconPanel
    extends JPanel
    implements VetoableChangeListener {
        JRadioButton rbClasspath;
        JRadioButton rbNoPicture;
        JTextField tfName;
        JButton bSelect;
        JScrollPane spImage;
        private final PropertyEnv env;
        private BiImageIcon value;
        private BiIconEditor editor;

        IconPanel(BiIconEditor editor, PropertyEnv env) {
            this.env = env;
            this.editor = editor;
            this.setLayout(new BorderLayout(6, 6));
            this.setBorder(new EmptyBorder(6, 6, 6, 6));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_IconPanelA11yName"));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_IconPanelA11yDesc"));
            JPanel p = new JPanel(new BorderLayout(3, 3));
            JPanel p1 = new JPanel(new BorderLayout());
            p1.setBorder(new TitledBorder(new EtchedBorder(), bundle.getString("CTL_ImageSourceType")));
            JPanel p2 = new JPanel();
            p2.setBorder(new EmptyBorder(0, 3, 0, 3));
            GridBagLayout l = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            p2.setLayout(l);
            c.anchor = 17;
            this.rbClasspath = new JRadioButton(bundle.getString("CTL_Classpath"));
            p2.add(this.rbClasspath);
            this.rbClasspath.setToolTipText(bundle.getString("ACS_ClasspathA11yDesc"));
            this.rbClasspath.setMnemonic(bundle.getString("CTL_Classpath_Mnemonic").charAt(0));
            c.gridwidth = 1;
            l.setConstraints(this.rbClasspath, c);
            JLabel lab = new JLabel(bundle.getString("CTL_ClasspathExample"));
            p2.add(lab);
            lab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClasspathExampleA11yDesc"));
            c.gridwidth = 0;
            l.setConstraints(lab, c);
            this.rbNoPicture = new JRadioButton(bundle.getString("CTL_NoPicture"));
            p2.add(this.rbNoPicture);
            this.rbNoPicture.setToolTipText(bundle.getString("ACS_NoPictureA11yDesc"));
            this.rbNoPicture.setMnemonic(bundle.getString("CTL_NoPicture_Mnemonic").charAt(0));
            c.gridwidth = 1;
            l.setConstraints(this.rbNoPicture, c);
            lab = new JLabel(bundle.getString("CTL_Null"));
            p2.add(lab);
            lab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NullA11yDesc"));
            c.gridwidth = 0;
            l.setConstraints(lab, c);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbClasspath);
            bg.add(this.rbNoPicture);
            this.rbClasspath.setSelected(true);
            p1.add((Component)p2, "West");
            p.add((Component)p1, "North");
            p1 = new JPanel(new BorderLayout(6, 6));
            JLabel nameLabel = new JLabel(bundle.getString("CTL_ImageSourceName"));
            nameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ImageSourceNameA11yDesc"));
            nameLabel.setDisplayedMnemonic(bundle.getString("CTL_ImageSourceName_Mnemonic").charAt(0));
            p1.add((Component)nameLabel, "West");
            this.tfName = new JTextField();
            p1.add((Component)this.tfName, "Center");
            nameLabel.setLabelFor(this.tfName);
            this.tfName.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameTextFieldA11yName"));
            this.tfName.setToolTipText(bundle.getString("ACS_ImageSourceNameTextFieldA11yDesc"));
            this.bSelect = new JButton("...");
            p1.add((Component)this.bSelect, "East");
            this.bSelect.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yName"));
            this.bSelect.setToolTipText(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yDesc"));
            this.bSelect.setEnabled(false);
            p.add((Component)p1, "South");
            this.add((Component)p, "North");
            this.spImage = new JScrollPane(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }
            };
            this.add((Component)this.spImage, "Center");
            this.tfName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setValue();
                }
            });
            this.rbClasspath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    bSelect.setEnabled(true);
                    tfName.setEnabled(true);
                    this.setValue();
                }
            });
            this.rbNoPicture.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    bSelect.setEnabled(false);
                    tfName.setEnabled(false);
                    this.setValue(null);
                    this.updateIcon();
                }
            });
            this.bSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name;
                    if (rbClasspath.isSelected() && (name = this.selectResource()) != null) {
                        tfName.setText("/" + name);
                        this.setValue();
                    }
                }
            });
            env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            env.addVetoableChangeListener((VetoableChangeListener)this);
            this.setValue(editor.getValue());
            this.updateIcon();
            HelpCtx.setHelpIDString((JComponent)this, (String)BiIconEditor.BEAN_ICONEDITOR_HELP);
            BiImageIcon i = this.getValue();
            if (i == null) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            this.rbClasspath.setSelected(true);
            this.bSelect.setEnabled(true);
            this.tfName.setText(i.getName());
        }

        void updateIcon() {
            BiImageIcon bii = this.getValue();
            Icon i = bii == null ? null : bii.getIcon();
            this.spImage.setViewportView(i == null ? new JLabel() : new JLabel(i));
            this.validate();
        }

        void setValue() {
            String val = this.tfName.getText();
            val.trim();
            if ("".equals(val)) {
                this.setValue(null);
                return;
            }
            try {
                this.setValue(this.editor.iconFromText(val));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.updateIcon();
        }

        private void setValue(BiImageIcon icon) {
            this.value = icon;
        }

        private BiImageIcon getValue() {
            return this.value;
        }

        private Object getPropertyValue(PropertyChangeEvent evt) throws PropertyVetoException {
            BiImageIcon ii = null;
            String s = this.tfName.getText().trim();
            if (this.rbClasspath.isSelected() && s.length() != 0) {
                try {
                    URL res = BiIconEditor.resolveIconPath(s, this.editor.sourceFileObject);
                    ii = new BiImageIcon(res, s);
                }
                catch (FileStateInvalidException ex) {
                    throw new PropertyVetoException(NbBundle.getMessage(IconPanel.class, (String)"CTL_Icon_not_exists", (Object)ex.getFileSystemName()), evt);
                }
                catch (FileNotFoundException ex) {
                    throw new PropertyVetoException(NbBundle.getMessage(IconPanel.class, (String)"CTL_Icon_not_exists", (Object)ex.getMessage()), evt);
                }
            }
            return ii;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if ("state" == evt.getPropertyName()) {
                BiImageIcon ii = (BiImageIcon)this.getPropertyValue(evt);
                this.editor.setValue(ii);
            }
        }

        private List<FileObject> getRoots(ClassPath cp) {
            ArrayList<FileObject> list = new ArrayList<FileObject>(cp.entries().size());
            for (ClassPath.Entry e : cp.entries()) {
                URL url = e.getURL();
                SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)url);
                FileObject[] fos = r.getRoots();
                if (fos.length > 0) {
                    for (int i = 0; i < fos.length; ++i) {
                        list.add(fos[i]);
                    }
                    continue;
                }
                if (e.getRoot() == null) continue;
                list.add(e.getRoot());
            }
            return list;
        }

        private String rootDisplayName(FileObject fo) {
            return FileUtil.getFileDisplayName((FileObject)fo);
        }

        private String selectResource() {
            FileObject fob;
            DataObject dob;
            FileObject root;
            ClassPath executionClassPath = ClassPath.getClassPath((FileObject)this.editor.sourceFileObject, (String)"classpath/execute");
            List roots = executionClassPath == null ? Collections.emptyList() : this.getRoots(executionClassPath);
            Node[] nodes = new Node[roots.size()];
            int selRoot = -1;
            try {
                ListIterator iter = roots.listIterator();
                while (iter.hasNext()) {
                    root = (FileObject)iter.next();
                    DataObject dob2 = DataObject.find((FileObject)root);
                    String displayName = this.rootDisplayName(root);
                    nodes[iter.previousIndex()] = new RootNode(dob2.getNodeDelegate(), displayName);
                }
            }
            catch (DataObjectNotFoundException donfex) {
                Exceptions.printStackTrace((Throwable)donfex);
                return null;
            }
            Children.Array children = new Children.Array();
            children.add(nodes);
            root = new AbstractNode((Children)children);
            root.setIconBaseWithExtension("org/netbeans/modules/beans/resources/iconResourceRoot.gif");
            root.setDisplayName(bundle.getString("CTL_ClassPathName"));
            ResourceSelector selector = new ResourceSelector((Node)root);
            DialogDescriptor dd = new DialogDescriptor((Object)selector, bundle.getString("CTL_OpenDialogName"));
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            nodes = res == DialogDescriptor.OK_OPTION ? selector.getNodes() : null;
            String name = null;
            if (nodes != null && nodes.length == 1 && (dob = (DataObject)nodes[0].getCookie(DataObject.class)) != null && (fob = dob.getPrimaryFile()) != null) {
                if (executionClassPath.contains(fob)) {
                    name = executionClassPath.getResourceName(fob);
                } else {
                    ClassPath srcClassPath = ClassPath.getClassPath((FileObject)fob, (String)"classpath/source");
                    name = srcClassPath.getResourceName(fob);
                }
            }
            return name;
        }
    }

    private static final class ResourceSelector
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();

        public ResourceSelector(Node root) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelector"));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelector"));
            this.manager.setRootContext(root);
            BeanTreeView tree = new BeanTreeView();
            tree.setPopupAllowed(false);
            tree.setDefaultActionAllowed(false);
            tree.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
            tree.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelectorView"));
            tree.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelectorView"));
            this.add((Component)tree, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.height = Math.max(dim.height, Utilities.getUsableScreenBounds().height / 2);
            return dim;
        }

        public Node[] getNodes() {
            return this.manager.getSelectedNodes();
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    private static final class RootNode
    extends FilterNode {
        RootNode(Node node, String displayName) {
            super(node);
            if (displayName != null) {
                this.disableDelegation(12);
                this.setDisplayName(displayName);
            }
        }
    }
}

