/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalAddDateNode
extends JavaScriptBaseNode {
    protected TemporalAddDateNode() {
    }

    public abstract JSTemporalPlainDateObject execute(CalendarMethodsRecord var1, JSTemporalPlainDateObject var2, JSTemporalDurationObject var3, JSDynamicObject var4);

    @Specialization
    protected JSTemporalPlainDateObject addDate(CalendarMethodsRecord calendarRec, JSTemporalPlainDateObject plainDate, JSTemporalDurationObject duration, JSDynamicObject options, @Cached(value="createCall()") JSFunctionCallNode callDateAddNode, @Cached InlinedBranchProfile errorBranch, @Cached TemporalGetOptionNode getOptionNode) {
        if (duration.getYears() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0) {
            Object addedDate = callDateAddNode.executeCall(JSArguments.create((Object)calendarRec.receiver(), calendarRec.dateAdd(), new Object[]{plainDate, duration, options}));
            return TemporalUtil.requireTemporalDate(addedDate, this, errorBranch);
        }
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
        double days = TemporalUtil.balanceTimeDuration(duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), TemporalUtil.Unit.DAY).days();
        ISODateRecord result = TemporalUtil.addISODate(plainDate.getYear(), plainDate.getMonth(), plainDate.getDay(), 0.0, 0.0, 0.0, days, overflow);
        return JSTemporalPlainDate.create(ctx, realm, result.year(), result.month(), result.day(), calendarRec.receiver(), this, errorBranch);
    }
}

