/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.PortCollection;
import org.netbeans.modules.glassfish.common.ui.InstancePanel;
import org.netbeans.modules.glassfish.common.ui.IpComboBox;
import org.netbeans.modules.glassfish.common.utils.Util;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;
import org.openide.util.NbBundle;

public class InstanceLocalPanel
extends InstancePanel {
    private static final Logger LOGGER = GlassFishLogger.get(InstanceLocalPanel.class);

    public InstanceLocalPanel(GlassfishInstance instance) {
        super(instance);
        this.hostRemoteLabel.setVisible(false);
        this.hostRemoteField.setVisible(false);
    }

    @Override
    protected void initHost() {
        InetAddress addr;
        String hostProperty = this.instance.getHost();
        try {
            addr = InetAddress.getByName(hostProperty);
            this.localIpCB.setSelected(addr.isLoopbackAddress());
        }
        catch (UnknownHostException uhe) {
            addr = null;
            this.localIpCB.setSelected(true);
            LOGGER.log(Level.INFO, NbBundle.getMessage(InstancePanel.class, (String)"InstanceLocalPanel.initHost.unknownHost", (Object)hostProperty));
        }
        ((IpComboBox)this.hostLocalField).updateModel(this.ips, this.localIpCB.isSelected());
        if (addr != null && this.ips.contains(addr)) {
            ((IpComboBox)this.hostLocalField).setSelectedItem(addr);
        } else {
            ((IpComboBox)this.hostLocalField).getEditor().setItem(hostProperty);
        }
    }

    @Override
    protected void initPorts() {
        PortCollection ports = new PortCollection();
        String domainPath = ServerUtils.getDomainPath((GlassFishServer)this.instance);
        this.configFileParsed = Util.readServerConfiguration(new File(domainPath), ports);
        if (this.configFileParsed) {
            this.dasPortField.setText(Integer.toString(ports.getAdminPort()));
            this.httpPortField.setText(Integer.toString(ports.getHttpPort()));
        } else {
            this.dasPortField.setText(Integer.toString(this.instance.getAdminPort()));
            this.httpPortField.setText(Integer.toString(this.instance.getPort()));
        }
    }

    @Override
    protected String getHost() {
        Object hostValue = this.hostLocalField.getEditor().getItem();
        if (hostValue instanceof IpComboBox.InetAddr) {
            return ((IpComboBox.InetAddr)hostValue).toString();
        }
        if (hostValue instanceof String) {
            return (String)hostValue;
        }
        return "localhost";
    }

    @Override
    protected void enableFields() {
        super.enableFields();
        this.hostLocalField.setEnabled(true);
        this.localIpCB.setEnabled(true);
    }
}

